/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterConnectionManager;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.EventHandler;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.xmppclient.SeeOtherHostDualIPSQLRepository;
import tigase.server.xmppclient.SeeOtherHostHashed;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class SeeOtherHostDualIP
extends SeeOtherHostHashed
implements EventHandler {
    private static final Logger log = Logger.getLogger(SeeOtherHostDualIP.class.getName());
    public static final String SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY = "cm-see-other-host/fallback-redirection-host";
    private BareJID fallback_host = null;
    public static final String SEE_OTHER_HOST_DATA_SOURCE_KEY = "cm-see-other-host/data-source";
    public static final String SEE_OTHER_HOST_DATA_SOURCE_VALUE = SeeOtherHostDualIPSQLRepository.class.getName();
    public static final String SEE_OTHER_HOST_DB_URL_KEY = "cm-see-other-host/db-url";
    protected String get_host_DB_url = "";
    private DualIPRepository repo = null;
    private final Map<BareJID, BareJID> redirectsMap = Collections.synchronizedMap(new HashMap());
    private final EventBus eventBus = EventBusFactory.getInstance();

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        BareJID see_other_host = super.findHostForJID(jid, host);
        BareJID redirection = this.redirectsMap.get(see_other_host);
        if (redirection == null) {
            this.reloadRedirection();
            redirection = this.redirectsMap.get(see_other_host);
        }
        if (redirection == null && this.fallback_host != null) {
            redirection = this.fallback_host;
        }
        return redirection;
    }

    @Override
    public void onEvent(String name, String xmlns, Element event) {
        Element child = event.getChild("repo-item");
        String actionAttr = child.getAttributeStaticStr("action");
        String hostnameStr = child.getAttributeStaticStr("hostname");
        String secondaryStr = child.getAttributeStaticStr("secondary");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Procesing clusterItem event: {0} with action: {1}, hostname: {2}, secondary: {3}", new Object[]{event, actionAttr, hostnameStr, secondaryStr});
        }
        if (null == actionAttr) {
            return;
        }
        ClusterConnectionManager.REPO_ITEM_UPDATE_TYPE action = ClusterConnectionManager.REPO_ITEM_UPDATE_TYPE.valueOf(actionAttr);
        if (null == hostnameStr) {
            return;
        }
        BareJID hostname = BareJID.bareJIDInstanceNS(hostnameStr);
        BareJID secondary = null;
        if (null != secondaryStr && !secondaryStr.trim().isEmpty()) {
            secondary = BareJID.bareJIDInstanceNS(secondaryStr);
        }
        switch (action) {
            case ADDED: 
            case UPDATED: {
                BareJID oldItem = this.redirectsMap.put(hostname, secondary);
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Redirection item :: hostname: {0}, secondary: {1}, added/updated! Replaced: {2}", new Object[]{hostname, secondary, oldItem});
                break;
            }
            case REMOVED: {
                BareJID oldItem = this.redirectsMap.remove(hostname);
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Redirection item :: hostname: {0}, {1}", new Object[]{hostname, oldItem != null ? "removed" : "was not present in redirection map"});
            }
        }
    }

    @Override
    public void setNodes(List<JID> connectedNodes) {
        super.setNodes(connectedNodes);
        this.reloadRedirection();
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        if (params.containsKey("--user-db-uri")) {
            this.get_host_DB_url = (String)params.get("--user-db-uri");
        } else if (params.containsKey("--cm-see-other-host/db-url")) {
            this.get_host_DB_url = (String)params.get("--cm-see-other-host/db-url");
        }
        defs.put(SEE_OTHER_HOST_DB_URL_KEY, this.get_host_DB_url);
        if (params.containsKey("--cm-see-other-host/data-source")) {
            defs.put(SEE_OTHER_HOST_DATA_SOURCE_KEY, params.get("--cm-see-other-host/data-source"));
        }
        if (params.containsKey("--cm-see-other-host/fallback-redirection-host")) {
            try {
                BareJID bareJIDInstance;
                this.fallback_host = bareJIDInstance = BareJID.bareJIDInstance((String)params.get("--cm-see-other-host/fallback-redirection-host"));
                defs.put(SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY, this.fallback_host);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, "Problem creating default redirection JID", ex);
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.containsKey(SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY) && !props.get(SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY).toString().trim().isEmpty()) {
            try {
                BareJID bareJIDInstance;
                this.fallback_host = bareJIDInstance = BareJID.bareJIDInstance(props.get(SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY).toString().trim());
                props.put(SEE_OTHER_HOST_FALLBACK_REDIRECTION_KEY, this.fallback_host);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, "Problem creating default redirection JID", ex);
            }
        }
        if (props.containsKey(SEE_OTHER_HOST_DB_URL_KEY) && !props.get(SEE_OTHER_HOST_DB_URL_KEY).toString().trim().isEmpty()) {
            this.get_host_DB_url = props.get(SEE_OTHER_HOST_DB_URL_KEY).toString().trim();
        }
        props.put(SEE_OTHER_HOST_DB_URL_KEY, this.get_host_DB_url);
        String repo_class = (String)props.get(SEE_OTHER_HOST_DATA_SOURCE_KEY);
        try {
            Class cls = null;
            if (null == repo_class) {
                cls = RepositoryFactory.getRepoClass(DualIPRepository.class, this.get_host_DB_url);
            } else if ("eventbus".equals(repo_class.trim().toLowerCase())) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.log(Level.CONFIG, "Using Evenbus as a source of DualIP data");
                }
                this.eventBus.addHandler("repo-item-modified", "tigase:system:cluster-update", this);
            } else {
                cls = ModulesManagerImpl.getInstance().forName(repo_class);
            }
            if (null != cls) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.log(Level.CONFIG, "Using {0} class for DualIP repository", cls);
                }
                DualIPRepository repoTmp = (DualIPRepository)cls.newInstance();
                if (this.repo == null) {
                    this.repo = repoTmp;
                }
                this.repo.setProperties(props);
                this.repo.initRepository(this.get_host_DB_url, null);
                this.reloadRedirection();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot initialize connection to database: ", ex);
        }
    }

    @Override
    public boolean isRedirectionRequired(BareJID defaultHost, BareJID redirectionHost) {
        return this.redirectsMap.get(defaultHost) != null ? !this.redirectsMap.get(defaultHost).equals(redirectionHost) : false;
    }

    protected void reloadRedirection() {
        if (null == this.repo) {
            return;
        }
        try {
            Map<BareJID, BareJID> queryAllDB = this.repo.queryAllDB();
            if (null != queryAllDB) {
                this.redirectsMap.clear();
                this.redirectsMap.putAll(queryAllDB);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reloaded redirection items: " + Arrays.asList(this.redirectsMap));
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Reloading redirection items failed: ", ex);
        }
    }

    public static interface DualIPRepository
    extends Repository {
        public static final String HOSTNAME_ID = "hostname";
        public static final String SECONDARY_HOSTNAME_ID = "secondary";

        public Map<BareJID, BareJID> queryAllDB() throws SQLException;

        public void setProperties(Map<String, Object> var1);

        public void getDefaults(Map<String, Object> var1, Map<String, Object> var2);
    }
}

