/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.mechanisms.SaslANONYMOUS;
import tigase.auth.mechanisms.SaslEXTERNAL;
import tigase.auth.mechanisms.SaslPLAIN;
import tigase.auth.mechanisms.SaslSCRAM;
import tigase.auth.mechanisms.SaslSCRAMPlus;

public class TigaseSaslServerFactory
implements SaslServerFactory {
    public static final String ANONYMOUS_MECHANISM_ALLOWED = "anonymous-mechanism-allowed";

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
        switch (mechanism) {
            case "SCRAM-SHA-1": {
                return new SaslSCRAM(props, callbackHandler);
            }
            case "SCRAM-SHA-1-PLUS": {
                return new SaslSCRAMPlus(props, callbackHandler);
            }
            case "PLAIN": {
                return new SaslPLAIN(props, callbackHandler);
            }
            case "ANONYMOUS": {
                return new SaslANONYMOUS(props, callbackHandler);
            }
            case "EXTERNAL": {
                return new SaslEXTERNAL(props, callbackHandler);
            }
        }
        throw new SaslException("Mechanism not supported yet.");
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"SCRAM-SHA-1-PLUS", "SCRAM-SHA-1", "PLAIN", "EXTERNAL", "ANONYMOUS"};
    }
}

