/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.Timestamp;
import com.sun.management.snmp.manager.ReqRedirectSrv;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpTooBig
implements SnmpRequestHandler,
SnmpDefinitions,
ReqRedirectSrv,
Serializable {
    private static final long serialVersionUID = -4852815251485423081L;
    String dbgTag = "SnmpTooBig";
    private SnmpRequest _rootRequest;
    private Vector _subRequestList;
    static final String nl = "\n";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTooBig");

    public SnmpTooBig(SnmpRequest request, SnmpVarBindList inputVb) throws SnmpStatusException {
        int size;
        this._rootRequest = request;
        if (logger.finerOn()) {
            logger.finer("constructor", "Initializing too-big handler");
        }
        if ((size = inputVb.size()) < 2) {
            throw new SnmpStatusException("VarBindList has only one element...");
        }
        SnmpVarBindList vbl1 = new SnmpVarBindList(inputVb);
        this._subRequestList = new Vector();
        SnmpVarBindList vbl2 = vbl1.splitAt(size / 2);
        SnmpRequest req1 = this.createRequest();
        SnmpRequest req2 = this.createRequest();
        this._subRequestList.addElement(req1);
        this._subRequestList.addElement(req2);
        req1.start(vbl1, false, 0L);
        req2.start(vbl2, false, 0L);
        if (logger.finerOn()) {
            logger.finer("constructor", "Root = " + this._rootRequest.getRequestId() + ", Request = " + this.subRequestToString());
        }
    }

    public final SnmpPeer getPeer() {
        return this._rootRequest.getPeer();
    }

    public final SnmpSession getSnmpSession() {
        return this._rootRequest.getSnmpSession();
    }

    public final int getCommand() {
        return this._rootRequest.getCommand();
    }

    public synchronized void cancel() {
        Enumeration toobige = this._subRequestList.elements();
        while (toobige.hasMoreElements()) {
            SnmpRequest req = (SnmpRequest)toobige.nextElement();
            if (!req.inProgress()) continue;
            req.cancelRequest();
        }
    }

    public synchronized void cancel(SnmpRequest dummy) {
        this.cancel();
    }

    private synchronized void doSubRequests(SnmpVarBindList vbl1, SnmpRequest req1) throws SnmpStatusException {
        int size = vbl1.size();
        if (size < 2) {
            throw new SnmpStatusException("VarBindList has only one element...");
        }
        SnmpVarBindList vbl2 = vbl1.splitAt(size / 2);
        if (logger.finerOn()) {
            logger.finer("doSubRequests", "Root = " + this._rootRequest.getRequestId() + "\nAfter spliting varBind: first half:" + vbl1.varBindListToString() + "\nsecond half:" + vbl2.varBindListToString());
        }
        SnmpRequest req2 = this.createRequest();
        if (req1 == null) {
            req1 = this.createRequest();
        }
        this.addRequest(req1, req2);
        req1.start(vbl1, false, 0L);
        req2.start(vbl2, false, 0L);
        if (logger.finerOn()) {
            logger.finer("doSubRequests", "Root = " + this._rootRequest.getRequestId() + ", Request = " + this.subRequestToString());
        }
    }

    private synchronized void addRequest(SnmpRequest req1, SnmpRequest req2) {
        int idx = this._subRequestList.indexOf(req1);
        if (idx < 0) {
            this._subRequestList.addElement(req1);
            this._subRequestList.addElement(req2);
        } else {
            this._subRequestList.insertElementAt(req2, ++idx);
        }
    }

    private synchronized SnmpRequest createRequest() throws SnmpStatusException {
        SnmpRequest req = null;
        req = new SnmpRequest(this.getSnmpSession(), this.getPeer(), this, this.getCommand());
        int options = this._rootRequest.getOptions();
        req.setOptions(options & 0xFFFFFFFB);
        req.setInternalRequest();
        if (logger.finerOn()) {
            logger.finer("createRequest", "Root = " + this._rootRequest.getRequestId() + ", Created a new sub-request for toobig handling");
        }
        return req;
    }

    public final synchronized String toString() {
        StringBuffer sb = new StringBuffer(500);
        boolean vbcount = false;
        return sb.toString();
    }

    public synchronized void processSnmpPollData(SnmpRequest req, int errStatus, int errIndex, SnmpVarBindList vblst) {
        switch (errStatus) {
            case 0: {
                this.handleSuccess(req, vblst);
                break;
            }
            case 1: 
            case 228: 
            case 231: {
                if (vblst.size() > 2) {
                    if (logger.finerOn()) {
                        logger.finer("processSnmpPollData", "Root = " + this._rootRequest.getRequestId() + ", Too-big error within too-big handler");
                    }
                    try {
                        this.doSubRequests(vblst, req);
                    }
                    catch (Exception e) {
                        if (logger.finestOn()) {
                            logger.finest("processSnmpPollData", e);
                        }
                        this.processSnmpInternalError(req, "Creating sub-requests to handle too-big error");
                    }
                    break;
                }
                if (logger.finerOn()) {
                    logger.finer("processSnmpPollData", "Root = " + this._rootRequest.getRequestId() + ", Too-big error within too-big handler : varBindList size = 1");
                }
                this.handleError(req, 232, 0);
                break;
            }
            default: {
                this.handleError(req, errStatus, errIndex);
            }
        }
    }

    public synchronized void processSnmpPollTimeout(SnmpRequest req) {
        this.cancel();
        this.operationComplete(224, 0, req.getPollTimestamp());
    }

    public synchronized void processSnmpInternalError(SnmpRequest req, String msg) {
        this.cancel();
        this.operationComplete(240, 0, req.getPollTimestamp());
    }

    synchronized void handleError(SnmpRequest req, int errStatus, int errIndex) {
        int realIndex = 0;
        this.cancel();
        if (errIndex >= 0) {
            realIndex = this.determineRealIndex(req) + errIndex;
        }
        if (logger.finestOn()) {
            logger.finest("handleError", "Root = " + this._rootRequest.getRequestId() + ", Error occured while handling too-big error");
        }
        this.operationComplete(errStatus, realIndex, req.getPollTimestamp());
    }

    synchronized void handleSuccess(SnmpRequest req, SnmpVarBindList vblst) {
        if (this.checkRemainingRequests(req)) {
            Timestamp timestamp = vblst.getTimestamp();
            this._rootRequest.getVarBindList().setTimestamp(timestamp);
            this.operationComplete(0, 0, req.getPollTimestamp());
            return;
        }
    }

    synchronized boolean checkRemainingRequests(SnmpRequest excludeReq) {
        Enumeration toobige = this._subRequestList.elements();
        while (toobige.hasMoreElements()) {
            SnmpRequest req = (SnmpRequest)toobige.nextElement();
            if (req == excludeReq || !req.inProgress()) continue;
            return false;
        }
        return true;
    }

    synchronized int determineRealIndex(SnmpRequest inreq) {
        SnmpRequest req;
        int idx = 0;
        Enumeration toobige = this._subRequestList.elements();
        while (toobige.hasMoreElements() && (req = (SnmpRequest)toobige.nextElement()) != inreq) {
            idx += req.getVarBindList().size();
        }
        return idx;
    }

    synchronized String subRequestToString() {
        StringBuffer sb = new StringBuffer(100);
        Enumeration toobige = this._subRequestList.elements();
        while (toobige.hasMoreElements()) {
            SnmpRequest req = (SnmpRequest)toobige.nextElement();
            sb.append("/" + req.getRequestId());
        }
        return sb.toString();
    }

    private void operationComplete(int status, int index, long time) {
        this._rootRequest.setErrorStatusAndIndex(status, index);
        this._rootRequest.setPreviousPollTimestamp(time);
        this._rootRequest.invokeOnResponse(null);
    }
}

