/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tigase.db.AuthRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.util.SchemaLoader;
import tigase.util.myFormatter;
import tigase.xmpp.BareJID;

class DBSchemaLoader
extends SchemaLoader {
    private boolean connection_ok = false;
    private boolean db_ok = false;
    private boolean schema_ok = false;
    private boolean schema_exists = false;
    private Map<String, String> replacementMap = new HashMap<String, String>();
    private static final Logger log = Logger.getLogger(DBSchemaLoader.class.getCanonicalName());
    public static final String PGSQL_DRIVER = "org.postgresql.Driver";
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String SQLSERVER_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    public static final String JDBC_CHECKUSERTABLE_QUERY = "select count(*) from tig_users";
    public static final String JDBC_GETSCHEMAVER_QUERY = "select TigGetDBProperty('schema-version')";
    public static final String DERBY_GETSCHEMAVER_QUERY = "values TigGetDBProperty('schema-version')";
    public static final String SQLSERVER_GETSCHEMAVER_QUERY = "select dbo.TigGetDBProperty('schema-version')";
    private String schema_ver_query = "select TigGetDBProperty('schema-version')";
    public static final String DATABASE_TYPE_KEY = "dbType";
    public static final String SCHEMA_VERSION_KEY = "schemaVersion";
    public static final String DATABASE_NAME_KEY = "dbName";
    public static final String DATABASE_HOSTNAME_KEY = "dbHostname";
    public static final String TIGASE_USERNAME_KEY = "dbUser";
    public static final String TIGASE_PASSWORD_KEY = "dbPass";
    public static final String ROOT_USERNAME_KEY = "rootUser";
    public static final String ROOT_PASSWORD_KEY = "rootPass";
    public static final String QUERY_KEY = "query";
    public static final String FILE_KEY = "file";
    public static final String ADMIN_JID_KEY = "adminJID";
    public static final String ADMIN_JID_PASS_KEY = "adminJIDpass";
    public static final String LOG_LEVEL_KEY = "logLevel";
    public static final String DASH = "-";
    public static final String DATABASE_TYPE_DEF = "mysql";
    public static final String SCHEMA_VERSION_DEF = "7-1";
    public static final String DATABASE_NAME_DEF = "tigasedb";
    public static final String DATABASE_HOSTNAME_DEF = "localhost";
    public static final String TIGASE_USERNAME_DEF = "tigase_user";
    public static final String TIGASE_PASSWORD_DEF = "tigase_pass";
    public static final String ROOT_USERNAME_DEF = "root";
    public static final String ROOT_PASSWORD_DEF = "root";
    public static final String LOG_LEVEL_DEF = "CONFIG";

    public DBSchemaLoader(Properties props) {
        if (props.get(DATABASE_TYPE_KEY) == null) {
            props.setProperty(DATABASE_TYPE_KEY, DATABASE_TYPE_DEF);
        }
        if (props.get(SCHEMA_VERSION_KEY) == null) {
            props.setProperty(SCHEMA_VERSION_KEY, SCHEMA_VERSION_DEF);
        }
        if (props.get(DATABASE_NAME_KEY) == null) {
            props.setProperty(DATABASE_NAME_KEY, DATABASE_NAME_DEF);
        }
        if (props.get(DATABASE_HOSTNAME_KEY) == null) {
            props.setProperty(DATABASE_HOSTNAME_KEY, DATABASE_HOSTNAME_DEF);
        }
        if (props.get(TIGASE_USERNAME_KEY) == null) {
            props.setProperty(TIGASE_USERNAME_KEY, TIGASE_USERNAME_DEF);
        }
        if (props.get(TIGASE_PASSWORD_KEY) == null) {
            props.setProperty(TIGASE_PASSWORD_KEY, TIGASE_PASSWORD_DEF);
        }
        if (props.get(ROOT_USERNAME_KEY) == null) {
            props.setProperty(ROOT_USERNAME_KEY, "root");
        }
        if (props.get(ROOT_PASSWORD_KEY) == null) {
            props.setProperty(ROOT_PASSWORD_KEY, "root");
        }
        if (props.get(LOG_LEVEL_KEY) == null) {
            props.setProperty(LOG_LEVEL_KEY, LOG_LEVEL_DEF);
        }
        for (String key : props.stringPropertyNames()) {
            this.replacementMap.put("${" + key + "}", props.get(key).toString());
        }
        Level lvl = Level.parse(String.valueOf(props.get(LOG_LEVEL_KEY)));
        System.out.println("LogLevel: " + lvl);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(lvl);
        handler.setFormatter(new myFormatter());
        log.setUseParentHandlers(false);
        log.addHandler(handler);
        log.setLevel(lvl);
        log.log(Level.CONFIG, String.format("Properties: %1$s", Arrays.asList(props)));
    }

    public static void main(String[] args) {
        Properties otherArgs = DBSchemaLoader.parseArgs(args);
        DBSchemaLoader dbHelper = new DBSchemaLoader(otherArgs);
        DBSchemaLoader.execute(dbHelper, otherArgs);
    }

    private static void execute(DBSchemaLoader helper, Properties props) {
        TigaseDBTask[] tasks = props.getProperty(QUERY_KEY) != null ? Tasks.getQueryTasks() : (props.getProperty(FILE_KEY) != null ? Tasks.getSchemaTasks() : Tasks.getTasksInOrder());
        for (TigaseDBTask task : tasks) {
            task.execute(helper, props);
        }
    }

    private static Properties parseArgs(String[] args) {
        Properties props = new Properties();
        if (args == null || args.length == 0) {
            System.out.println(DBSchemaLoader.help());
            System.exit(0);
        } else {
            block30: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "-dbType": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(DATABASE_TYPE_KEY, args[++i]);
                        continue block30;
                    }
                    case "-schemaVersion": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(SCHEMA_VERSION_KEY, args[++i]);
                        continue block30;
                    }
                    case "-dbName": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(DATABASE_NAME_KEY, args[++i]);
                        continue block30;
                    }
                    case "-dbHostname": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(DATABASE_HOSTNAME_KEY, args[++i]);
                        continue block30;
                    }
                    case "-dbUser": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(TIGASE_USERNAME_KEY, args[++i]);
                        continue block30;
                    }
                    case "-dbPass": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(TIGASE_PASSWORD_KEY, args[++i]);
                        continue block30;
                    }
                    case "-rootUser": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(ROOT_USERNAME_KEY, args[++i]);
                        continue block30;
                    }
                    case "-rootPass": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(ROOT_PASSWORD_KEY, args[++i]);
                        continue block30;
                    }
                    case "-file": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(FILE_KEY, args[++i]);
                        continue block30;
                    }
                    case "-query": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(QUERY_KEY, args[++i]);
                        continue block30;
                    }
                    case "-adminJID": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(ADMIN_JID_KEY, args[++i]);
                        continue block30;
                    }
                    case "-adminJIDpass": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(ADMIN_JID_PASS_KEY, args[++i]);
                        continue block30;
                    }
                    case "-logLevel": {
                        if (args.length <= i + 1) continue block30;
                        props.setProperty(LOG_LEVEL_KEY, args[++i].toUpperCase());
                    }
                }
            }
        }
        return props;
    }

    private static String help() {
        String help = "Usage:$ java -cp \"jars/*.jar\" tigase.util.DBSchemaLoader\n\t -dbType database_type {derby, mysql, postgresql, sqlserver} \n\t[-schemaVersion schema_version {4, 5, 5-1, 7-1} ]\n\t[-dbName database_name]\n\t[-dbHostname database hostname]\n\t[-dbUser tigase_username]\n\t[-dbPass tigase_userpass]\n\t[-rootUser database_root_username]\n\t[-rootPass database_root_password]\n\t[-file path_to_sql_schema_file]\n\t[-query sql_query_to_execute]\n\t[-logLevel java logger Level]\n\t[-adminJID comma separated list of admin JIDs]\n\t[-adminJIDpass password (one for all entered JIDs]\n\targuments take following precedent: query, file, whole schema\n\t(i.e. file superseeds schema execution, query superseeds file execution).";
        return help;
    }

    private ArrayList<String> loadSQLQueries(String resource, String res_prefix, Properties variables) throws IOException {
        String line;
        log.log(Level.FINER, String.format("Loading queries, resource: %1$s, res_prefix: %2$s ", resource, res_prefix));
        ArrayList<String> results = new ArrayList<String>();
        boolean path = res_prefix == null;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getResource(resource, path)));
        String sql_query = "";
        SQL_LOAD_STATE state = SQL_LOAD_STATE.INIT;
        block4: while ((line = br.readLine()) != null) {
            switch (state) {
                case INIT: {
                    Matcher matcher;
                    if (line.startsWith("-- QUERY START:")) {
                        sql_query = "";
                        state = SQL_LOAD_STATE.IN_SQL;
                    }
                    if (line.startsWith("-- LOAD SCHEMA:")) {
                        results.addAll(this.loadSchemaQueries(variables));
                    }
                    if (!line.startsWith("-- LOAD FILE:") || !line.trim().contains("sql") || !(matcher = Pattern.compile("-- LOAD FILE:\\s*(.*\\.sql)").matcher(line)).find()) continue block4;
                    log.log(Level.FINE, String.format("\n\n *** trying to load schema: %1$s \n", matcher.group(1)));
                    results.addAll(this.loadSQLQueries(matcher.group(1), null, variables));
                    continue block4;
                }
                case IN_SQL: {
                    if (line.startsWith("-- QUERY END:")) {
                        state = SQL_LOAD_STATE.INIT;
                        if ((sql_query = sql_query.trim()).endsWith(";")) {
                            sql_query = sql_query.substring(0, sql_query.length() - 1);
                        }
                        if (sql_query.endsWith("//")) {
                            sql_query = sql_query.substring(0, sql_query.length() - 2);
                        }
                        String substitute = variableSubstitutor.substitute(sql_query, this.replacementMap);
                        results.add(substitute);
                    }
                    if (line.isEmpty() || line.trim().startsWith("--")) continue block4;
                    sql_query = sql_query + " " + line.trim();
                    continue block4;
                }
            }
        }
        br.close();
        return results;
    }

    private ArrayList<String> loadSchemaQueries(Properties variables) throws IOException {
        String res_prefix = variables.get(DATABASE_TYPE_KEY).toString();
        String version = variables.get(SCHEMA_VERSION_KEY).toString();
        ArrayList<String> queries = new ArrayList<String>();
        queries.addAll(this.loadSQLQueries(res_prefix + "-schema-" + version + "-schema", res_prefix, variables));
        queries.addAll(this.loadSQLQueries(res_prefix + "-schema-" + version + "-sp", res_prefix, variables));
        queries.addAll(this.loadSQLQueries(res_prefix + "-schema-" + version + "-props", res_prefix, variables));
        log.log(Level.FINE, String.format("Loading schema queries: %1$s // %2$s", Arrays.asList(queries), queries.toArray()));
        return queries;
    }

    protected InputStream getResource(String resource, boolean path) {
        File f = path ? new File(resource) : new File("database/" + resource + ".sql");
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DBSchemaLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        log.log(Level.FINEST, String.format("Getting resource: %1$s @ filename: %2$s", resource, f.getAbsolutePath()));
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaLoader.Result validateDBConnection(Properties variables) {
        this.connection_ok = false;
        String db_conn = DBSchemaLoader.getDBUri(variables, false, true);
        log.log(Level.INFO, "Validating DBConnection, URI: " + db_conn);
        if (db_conn == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
            return SchemaLoader.Result.ok;
        }
        try (Connection conn = DriverManager.getConnection(db_conn);){
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            ArrayList<String> availableDrivers = new ArrayList<String>();
            while (drivers.hasMoreElements()) {
                availableDrivers.add(drivers.nextElement().toString());
            }
            log.log(Level.CONFIG, "DriverManager (available drivers): " + Arrays.asList(availableDrivers));
            conn.close();
            this.connection_ok = true;
            log.log(Level.INFO, "Connection OK");
            SchemaLoader.Result result = SchemaLoader.Result.ok;
            return result;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    @Override
    public SchemaLoader.Result shutdown(Properties variables) {
        return this.shutdownDerby(variables);
    }

    public SchemaLoader.Result shutdownDerby(Properties variables) {
        String db_conn = DBSchemaLoader.getDBUri(variables, false, true);
        String database = variables.getProperty(DATABASE_TYPE_KEY);
        if ("derby".equals(database)) {
            log.log(Level.INFO, "Validating DBConnection, URI: " + db_conn);
            if (db_conn == null) {
                log.log(Level.WARNING, "Missing DB connection URL");
            } else {
                db_conn = db_conn + ";shutdown=true";
                try (Connection conn = DriverManager.getConnection(db_conn);){
                    Enumeration<Driver> drivers = DriverManager.getDrivers();
                    ArrayList<String> availableDrivers = new ArrayList<String>();
                    while (drivers.hasMoreElements()) {
                        availableDrivers.add(drivers.nextElement().toString());
                    }
                    log.log(Level.CONFIG, "DriverManager (available drivers): " + Arrays.asList(availableDrivers));
                    conn.close();
                    this.connection_ok = true;
                    log.log(Level.INFO, "Connection OK");
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.getMessage());
                }
            }
        }
        return SchemaLoader.Result.ok;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaLoader.Result validateDBExists(Properties variables) {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        String res_prefix = variables.get(DATABASE_TYPE_KEY).toString();
        this.db_ok = false;
        String db_conn = DBSchemaLoader.getDBUri(variables, true, false);
        log.log(Level.INFO, "Validating whether DB Exists, URI: " + db_conn);
        if (db_conn == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
            return SchemaLoader.Result.error;
        }
        try (Connection conn = DriverManager.getConnection(db_conn);){
            conn.close();
            this.db_ok = true;
            log.log(Level.INFO, "Exists OK");
            SchemaLoader.Result throwable3 = SchemaLoader.Result.ok;
            return throwable3;
        }
        catch (SQLException e) {
            log.log(Level.INFO, "Doesn't exist, creating...");
            db_conn = DBSchemaLoader.getDBUri(variables, false, true);
            try (Connection conn2 = DriverManager.getConnection(db_conn);){
                SchemaLoader.Result result2 = SchemaLoader.Result.ok;
                ArrayList<String> queries = this.loadSQLQueries(res_prefix + "-installer-create-db", res_prefix, variables);
                for (String query : queries) {
                    log.log(Level.FINE, "Executing query: " + query);
                    if (query.isEmpty()) continue;
                    try {
                        Statement stmt = conn2.createStatement();
                        Throwable throwable = null;
                        try {
                            stmt.execute(query);
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        result2 = SchemaLoader.Result.warning;
                        log.log(Level.WARNING, "Query failed: " + ex.getMessage());
                    }
                }
                conn2.close();
                log.log(Level.INFO, " OK");
                this.db_ok = true;
                Object object = result2;
                return object;
            }
            catch (IOException | SQLException ex) {
                log.log(Level.WARNING, ex.getMessage());
                return SchemaLoader.Result.error;
            }
        }
    }

    @Override
    public SchemaLoader.Result validateDBSchema(Properties variables) {
        Throwable throwable;
        Statement stmt2;
        Throwable throwable2;
        Connection conn;
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        this.schema_exists = false;
        this.schema_ok = false;
        String db_conn = DBSchemaLoader.getDBUri(variables, true, false);
        log.log(Level.INFO, "Validating DBSchema, URI: " + db_conn);
        long users = 0L;
        try {
            conn = DriverManager.getConnection(db_conn);
            throwable2 = null;
            try {
                stmt2 = conn.createStatement();
                throwable = null;
                try {
                    String schema_version;
                    String query = JDBC_CHECKUSERTABLE_QUERY;
                    ResultSet rs = stmt2.executeQuery(query);
                    if (rs.next()) {
                        users = rs.getLong(1);
                        this.schema_exists = true;
                        log.log(Level.INFO, "Schema exists, users: " + users);
                    }
                    this.schema_ver_query = JDBC_GETSCHEMAVER_QUERY;
                    if (db_conn.startsWith("jdbc:sqlserver") || db_conn.startsWith("jdbc:jtds:sqlserver")) {
                        this.schema_ver_query = SQLSERVER_GETSCHEMAVER_QUERY;
                        if (db_conn.startsWith("jdbc:derby")) {
                            this.schema_ver_query = DERBY_GETSCHEMAVER_QUERY;
                        }
                    }
                    query = this.schema_ver_query;
                    String loadedSchemaVersion = variables.get(SCHEMA_VERSION_KEY).toString().replace(DASH, ".");
                    rs = stmt2.executeQuery(query);
                    if (rs.next() && loadedSchemaVersion.equals(schema_version = rs.getString(1))) {
                        this.schema_ok = true;
                    }
                }
                catch (Throwable query) {
                    throwable = query;
                    throw query;
                }
                finally {
                    if (stmt2 != null) {
                        if (throwable != null) {
                            try {
                                stmt2.close();
                            }
                            catch (Throwable query) {
                                throwable.addSuppressed(query);
                            }
                        } else {
                            stmt2.close();
                        }
                    }
                }
            }
            catch (Throwable stmt2) {
                throwable2 = stmt2;
                throw stmt2;
            }
            finally {
                if (conn != null) {
                    if (throwable2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable stmt2) {
                            throwable2.addSuppressed(stmt2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Exception, posibly schema hasn't been loaded yet.");
        }
        if (this.schema_ok) {
            log.log(Level.INFO, "Schema OK, accounts number: " + users);
            return SchemaLoader.Result.ok;
        }
        if (!this.schema_exists) {
            db_conn = DBSchemaLoader.getDBUri(variables, true, true);
            log.log(Level.INFO, "DB schema doesn't exists, creating one..., URI: " + db_conn);
            try {
                conn = DriverManager.getConnection(db_conn);
                throwable2 = null;
                try {
                    stmt2 = conn.createStatement();
                    throwable = null;
                    try {
                        ArrayList<String> queries = this.loadSchemaQueries(variables);
                        for (String query : queries) {
                            if (query.isEmpty()) continue;
                            log.log(Level.FINEST, "Executing query: " + query);
                            stmt2.execute(query);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (stmt2 != null) {
                            if (throwable != null) {
                                try {
                                    stmt2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                stmt2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (conn != null) {
                        if (throwable2 != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
                this.schema_ok = true;
                log.log(Level.INFO, "New schema loaded OK");
                return SchemaLoader.Result.ok;
            }
            catch (IOException | SQLException ex) {
                log.log(Level.WARNING, "Can't load schema: " + ex.getMessage());
                return SchemaLoader.Result.error;
            }
        }
        log.log(Level.INFO, "Old schema, accounts number: " + users);
        return SchemaLoader.Result.warning;
    }

    @Override
    public SchemaLoader.Result postInstallation(Properties variables) {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.schema_ok) {
            log.log(Level.WARNING, "Database schema is invalid");
            return SchemaLoader.Result.error;
        }
        String db_conn = DBSchemaLoader.getDBUri(variables, true, true);
        String res_prefix = variables.get(DATABASE_TYPE_KEY).toString();
        log.log(Level.INFO, "Post Installation, URI: " + db_conn);
        try {
            log.log(Level.INFO, "Finalizing...");
            try (Connection conn = DriverManager.getConnection(db_conn);
                 Statement stmt = conn.createStatement();){
                ArrayList<String> queries = this.loadSQLQueries(res_prefix + "-installer-post", res_prefix, variables);
                for (String query : queries) {
                    if (query.isEmpty()) continue;
                    log.log(Level.FINEST, "Executing query: " + query);
                    stmt.execute(query);
                }
            }
            this.schema_ok = true;
            log.log(Level.INFO, " completed OK");
            return SchemaLoader.Result.ok;
        }
        catch (IOException | SQLException ex) {
            log.log(Level.WARNING, "Can't finalize: " + ex.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    @Override
    public SchemaLoader.Result printInfo(Properties variables) {
        String database;
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.schema_ok) {
            log.log(Level.WARNING, "Database schema is invalid");
            return SchemaLoader.Result.error;
        }
        String db_conn = DBSchemaLoader.getDBUri(variables, true, false);
        switch (database = variables.getProperty(DATABASE_TYPE_KEY)) {
            case "mysql": {
                db_conn = db_conn + "&useUnicode=true&characterEncoding=UTF-8";
            }
        }
        log.log(Level.INFO, "\n\nDatabase init.properties configuration:\n\n--user-db=" + database + "\n" + "--user-db-uri=" + db_conn);
        return SchemaLoader.Result.ok;
    }

    @Override
    public SchemaLoader.Result addXmppAdminAccount(Properties variables) {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.schema_ok) {
            log.log(Level.WARNING, "Database schema is invalid");
            return SchemaLoader.Result.error;
        }
        Object admins = variables.get(ADMIN_JID_KEY);
        LinkedHashSet<BareJID> jids = new LinkedHashSet<BareJID>();
        if (admins != null) {
            String[] adminsStr;
            for (String adminStr : adminsStr = admins.toString().split(",")) {
                String jid = adminStr.trim();
                if (jid == null || jid.equals("")) continue;
                jids.add(BareJID.bareJIDInstanceNS(jid));
            }
        }
        if (jids.size() < 1) {
            log.log(Level.WARNING, "Error: No admin users entered");
            return SchemaLoader.Result.warning;
        }
        Object pwdObj = variables.get(ADMIN_JID_PASS_KEY);
        if (pwdObj == null) {
            log.log(Level.WARNING, "Error: No admin password enetered");
            return SchemaLoader.Result.warning;
        }
        String pwd = pwdObj.toString();
        String dbUri = DBSchemaLoader.getDBUri(variables, true, true);
        log.log(Level.INFO, "Adding XMPP Admin Account, URI: " + dbUri);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("data-repo-pool-size", String.valueOf(1));
            log.log(Level.CONFIG, "RepositoryFactory.getAuthRepository(" + null + ", " + dbUri + "," + Arrays.asList(params) + ")");
            AuthRepository repo = RepositoryFactory.getAuthRepository(null, dbUri, params);
            for (BareJID jid : jids) {
                repo.addUser(jid, pwd);
            }
            log.log(Level.INFO, "All users added");
            return SchemaLoader.Result.ok;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | TigaseDBException e) {
            log.log(Level.WARNING, "Error initializing DB" + e);
            return SchemaLoader.Result.error;
        }
    }

    @Override
    public SchemaLoader.Result loadSchemaFile(Properties variables) {
        if (!this.connection_ok) {
            log.log(Level.INFO, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.INFO, "Database not validated");
            return SchemaLoader.Result.error;
        }
        Object fileNameObj = variables.get(FILE_KEY);
        if (fileNameObj == null) {
            log.log(Level.WARNING, "Error: empty query");
            return SchemaLoader.Result.error;
        }
        String fileName = fileNameObj.toString();
        String db_conn = DBSchemaLoader.getDBUri(variables, true, true);
        log.log(Level.INFO, String.format("Loading schema from file: %1$s, URI: %2$s", fileName, db_conn));
        try {
            try (Connection conn = DriverManager.getConnection(db_conn);
                 Statement stmt = conn.createStatement();){
                ArrayList<String> queries = this.loadSQLQueries(fileName, null, variables);
                for (String query : queries) {
                    if (query.isEmpty()) continue;
                    log.log(Level.FINEST, "Executing query: " + query);
                    stmt.execute(query);
                }
            }
            this.schema_ok = true;
            log.log(Level.INFO, " completed OK");
            return SchemaLoader.Result.ok;
        }
        catch (IOException | NullPointerException | SQLException ex) {
            log.log(Level.WARNING, "Can't finalize: " + ex.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    protected void executeSingleQuery(Properties variables) {
        if (!this.connection_ok) {
            log.log(Level.INFO, "Connection not validated");
            return;
        }
        if (!this.db_ok) {
            log.log(Level.INFO, "Database not validated");
            return;
        }
        Object queryObj = variables.get(QUERY_KEY);
        if (queryObj == null) {
            log.log(Level.WARNING, "Error: empty query");
            return;
        }
        String simpleQuery = queryObj.toString();
        String db_conn = DBSchemaLoader.getDBUri(variables, true, false);
        log.log(Level.INFO, "Executing Simple Query, URI: " + db_conn);
        if (db_conn == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
        } else {
            db_conn = DBSchemaLoader.getDBUri(variables, false, true);
            try {
                try (Connection conn = DriverManager.getConnection(db_conn);
                     Statement stmt = conn.createStatement();){
                    ArrayList<String> queries = new ArrayList<String>();
                    queries.add(simpleQuery);
                    for (String query : queries) {
                        log.log(Level.FINEST, "Executing query: " + query);
                        if (query.isEmpty()) continue;
                        try {
                            stmt.execute(query);
                            stmt.close();
                        }
                        catch (SQLException ex) {
                            log.log(Level.WARNING, "Query failed: " + query + ", " + ex.getMessage());
                        }
                    }
                }
                log.log(Level.INFO, " OK");
                this.db_ok = true;
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage());
            }
        }
    }

    private static String getDBUri(Properties props, boolean includeDbName, boolean useRootCredentials) {
        String PASSWORD;
        String USERNAME;
        String db_uri = "jdbc:";
        String database = props.getProperty(DATABASE_TYPE_KEY);
        if (useRootCredentials) {
            USERNAME = ROOT_USERNAME_KEY;
            PASSWORD = ROOT_PASSWORD_KEY;
        } else {
            USERNAME = TIGASE_USERNAME_KEY;
            PASSWORD = TIGASE_PASSWORD_KEY;
        }
        switch (database) {
            case "sqlserver": {
                db_uri = db_uri + "jtds:sqlserver:";
                break;
            }
            default: {
                db_uri = db_uri + database + ":";
            }
        }
        switch (database) {
            case "derby": {
                db_uri = db_uri + props.getProperty(DATABASE_NAME_KEY) + ";create=true";
                break;
            }
            case "sqlserver": {
                db_uri = db_uri + "//" + props.getProperty(DATABASE_HOSTNAME_KEY);
                if (includeDbName) {
                    db_uri = db_uri + ";databaseName=" + props.getProperty(DATABASE_NAME_KEY);
                }
                db_uri = db_uri + ";user=" + props.getProperty(USERNAME);
                if (props.getProperty(PASSWORD) != null && !props.getProperty(PASSWORD).isEmpty()) {
                    db_uri = db_uri + ";password=" + props.getProperty(PASSWORD);
                }
                db_uri = db_uri + ";schema=dbo";
                db_uri = db_uri + ";lastUpdateCount=false";
                db_uri = db_uri + ";cacheMetaData=false";
                break;
            }
            default: {
                db_uri = db_uri + "//" + props.getProperty(DATABASE_HOSTNAME_KEY) + "/";
                if (includeDbName) {
                    db_uri = db_uri + props.getProperty(DATABASE_NAME_KEY);
                } else if (database.equals("postgresql")) {
                    db_uri = db_uri + "postgres";
                }
                db_uri = db_uri + "?user=" + props.getProperty(USERNAME);
                if (props.getProperty(PASSWORD) == null || props.getProperty(PASSWORD).isEmpty()) break;
                db_uri = db_uri + "&password=" + props.getProperty(PASSWORD);
            }
        }
        return db_uri;
    }

    static class variableSubstitutor {
        variableSubstitutor() {
        }

        static String substitute(String str, Map<String, String> replacementMap) {
            String replaced = str;
            for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
                replaced = replaced.replace(entry.getKey(), entry.getValue());
            }
            return replaced;
        }
    }

    static interface TigaseDBTask {
        public String getDescription();

        public void execute(DBSchemaLoader var1, Properties var2);
    }

    static enum Tasks implements TigaseDBTask
    {
        VALIDATE_CONNECTION("Checking connection to the database"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.validateDBConnection(variables);
            }
        }
        ,
        VALIDATE_DB_EXISTS("Checking if the database exists"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.validateDBExists(variables);
            }
        }
        ,
        VALIDATE_DB_SCHEMA("Checking the database schema"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.validateDBSchema(variables);
            }
        }
        ,
        ADD_ADMIN_XMPP_ACCOUNT("Adding XMPP admin accounts"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.addXmppAdminAccount(variables);
            }
        }
        ,
        EXECUTE_SIMPLE_QUERY("Executing simple single query"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.executeSingleQuery(variables);
            }
        }
        ,
        LOAD_SCHEMA_FILE("Loading schema file from provided file"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.loadSchemaFile(variables);
            }
        }
        ,
        POST_INSTALLATION("Post installation actions"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.postInstallation(variables);
            }
        }
        ,
        SHUTDOWN_DATABASE("Shutting Down Database"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.shutdownDerby(variables);
            }
        }
        ,
        PRINT_INFO_TASK("Database Configuration Details"){

            @Override
            public void execute(DBSchemaLoader helper, Properties variables) {
                helper.printInfo(variables);
            }
        };

        private final String description;

        private Tasks(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static TigaseDBTask[] getTasksInOrder() {
            return new TigaseDBTask[]{VALIDATE_CONNECTION, VALIDATE_DB_EXISTS, VALIDATE_DB_SCHEMA, ADD_ADMIN_XMPP_ACCOUNT, POST_INSTALLATION, SHUTDOWN_DATABASE, PRINT_INFO_TASK};
        }

        public static TigaseDBTask[] getSchemaTasks() {
            return new TigaseDBTask[]{VALIDATE_CONNECTION, VALIDATE_DB_EXISTS, LOAD_SCHEMA_FILE, SHUTDOWN_DATABASE, PRINT_INFO_TASK};
        }

        public static TigaseDBTask[] getQueryTasks() {
            return new TigaseDBTask[]{VALIDATE_CONNECTION, VALIDATE_DB_EXISTS, EXECUTE_SIMPLE_QUERY, SHUTDOWN_DATABASE, PRINT_INFO_TASK};
        }
    }

    static enum SQL_LOAD_STATE {
        INIT,
        IN_SQL;

    }
}

