/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.monitor;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import tigase.sys.CPULoadListener;
import tigase.sys.MemoryChangeListener;
import tigase.sys.OnlineJidsReporter;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class MonitorRuntime
extends TigaseRuntime {
    private static final Logger log = Logger.getLogger(MonitorRuntime.class.getName());
    private static MonitorRuntime runtime = null;
    private final LinkedHashSet<ShutdownHook> shutdownHooks = new LinkedHashSet();
    private final LinkedList<OnlineJidsReporter> onlineJidsReporters = new LinkedList();

    private MonitorRuntime() {
        Runtime.getRuntime().addShutdownHook(new MainShutdownThread());
    }

    public static MonitorRuntime getMonitorRuntime() {
        if (runtime == null) {
            runtime = new MonitorRuntime();
        }
        return runtime;
    }

    @Override
    public synchronized void addShutdownHook(ShutdownHook hook) {
        this.shutdownHooks.add(hook);
    }

    @Override
    public synchronized void addMemoryChangeListener(MemoryChangeListener memListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void addCPULoadListener(CPULoadListener cpuListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void addOnlineJidsReporter(OnlineJidsReporter onlineReporter) {
        this.onlineJidsReporters.add(onlineReporter);
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        if (this.onlineJidsReporters.size() == 1) {
            return this.onlineJidsReporters.getFirst().hasCompleteJidsInfo();
        }
        for (OnlineJidsReporter onlineJidsReporter : this.onlineJidsReporters) {
            if (onlineJidsReporter.hasCompleteJidsInfo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isJidOnline(JID jid) {
        if (this.onlineJidsReporters.size() == 1) {
            return this.onlineJidsReporters.getFirst().containsJid(jid.getBareJID());
        }
        for (OnlineJidsReporter onlineJidsReporter : this.onlineJidsReporters) {
            if (!onlineJidsReporter.containsJid(jid.getBareJID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJidOnlineLocally(BareJID jid) {
        if (this.onlineJidsReporters.size() == 1) {
            return this.onlineJidsReporters.getFirst().containsJidLocally(jid);
        }
        for (OnlineJidsReporter onlineJidsReporter : this.onlineJidsReporters) {
            if (!onlineJidsReporter.containsJidLocally(jid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJidOnlineLocally(JID jid) {
        if (this.onlineJidsReporters.size() == 1) {
            return this.onlineJidsReporters.getFirst().containsJidLocally(jid);
        }
        for (OnlineJidsReporter onlineJidsReporter : this.onlineJidsReporters) {
            if (!onlineJidsReporter.containsJidLocally(jid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JID[] getConnectionIdsForJid(JID jid) {
        if (this.onlineJidsReporters.size() == 1) {
            return this.onlineJidsReporters.getFirst().getConnectionIdsForJid(jid.getBareJID());
        }
        for (OnlineJidsReporter onlineJidsReporter : this.onlineJidsReporters) {
            JID[] connIds = onlineJidsReporter.getConnectionIdsForJid(jid.getBareJID());
            if (connIds == null) continue;
            return connIds;
        }
        return null;
    }

    private class MainShutdownThread
    extends Thread {
        public MainShutdownThread() {
            this.setName("MainShutdownThread");
        }

        @Override
        public void run() {
            String SHUTDOWN_THREAD_DUMP;
            System.out.println("ShutdownThread started...");
            log.warning("ShutdownThread started...");
            LinkedList<ShutdownHandlerThread> thlist = new LinkedList<ShutdownHandlerThread>();
            ThreadGroup threads = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Tigase Shutdown");
            for (ShutdownHook shutdownHook : MonitorRuntime.this.shutdownHooks) {
                ShutdownHandlerThread thr = new ShutdownHandlerThread(threads, shutdownHook);
                thr.start();
                thlist.add(thr);
            }
            long shutdownStart = System.currentTimeMillis();
            while (threads.activeCount() > 0 && System.currentTimeMillis() - shutdownStart < 10000L) {
                try {
                    MainShutdownThread.sleep(100L);
                }
                catch (Exception e) {}
            }
            StringBuilder sb = new StringBuilder();
            for (ShutdownHandlerThread shutdownHandlerThread : thlist) {
                if (shutdownHandlerThread.getResultMessage() == null) continue;
                sb.append(shutdownHandlerThread.getResultMessage());
            }
            ThreadMXBean thBean = ManagementFactory.getThreadMXBean();
            sb.append("\nTotal number of threads: " + thBean.getThreadCount()).append('\n');
            long[] tids = thBean.findDeadlockedThreads();
            if (tids != null && tids.length > 0) {
                ThreadInfo[] lockedThreads;
                sb.append("Locked threads:\n");
                for (ThreadInfo threadInfo : lockedThreads = thBean.getThreadInfo(tids)) {
                    Object[] ste;
                    sb.append("Locked thread ").append(threadInfo.getThreadName()).append(" on ").append(threadInfo.getLockInfo().toString()).append(", locked synchronizes: ").append(Arrays.toString(threadInfo.getLockedSynchronizers())).append(", locked monitors: ").append(Arrays.toString(threadInfo.getLockedMonitors())).append(" by [").append(threadInfo.getLockOwnerId()).append("] ").append(threadInfo.getLockOwnerName()).append('\n');
                    Object[] objectArray = ste = threadInfo.getStackTrace();
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object stackTraceElement = objectArray[i];
                        sb.append(((StackTraceElement)stackTraceElement).toString()).append('\n');
                    }
                }
            } else {
                sb.append("No locked threads.\n");
            }
            if (sb.length() > 0) {
                System.out.println(sb.toString());
                log.warning(sb.toString());
            }
            if (System.getProperty(SHUTDOWN_THREAD_DUMP = "shutdown-thread-dump") == null || Boolean.TRUE.equals(Boolean.valueOf(System.getProperty(SHUTDOWN_THREAD_DUMP)))) {
                try {
                    Logger THREAD_DUMP_LOGGER = Logger.getLogger("ThreadDumpLogger");
                    String threadDumpPath = "logs/thread-dump.log";
                    FileHandler fileHandler = new FileHandler(threadDumpPath, 10000000, 5, true);
                    fileHandler.setLevel(Level.ALL);
                    fileHandler.setFormatter(new Formatter(){

                        @Override
                        public String format(LogRecord record) {
                            return new Date(record.getMillis()) + ": " + record.getMessage();
                        }
                    });
                    THREAD_DUMP_LOGGER.addHandler(fileHandler);
                    THREAD_DUMP_LOGGER.setLevel(Level.ALL);
                    THREAD_DUMP_LOGGER.setUseParentHandlers(false);
                    StringBuilder threadDumpBuilder = new StringBuilder("All threads information:\n");
                    for (ThreadInfo threadInfo : ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                        threadDumpBuilder.append(threadInfo);
                    }
                    threadDumpBuilder.append("\n===========\n\n");
                    THREAD_DUMP_LOGGER.log(Level.INFO, threadDumpBuilder.toString());
                    String msg = "Save thread-dump to file: " + threadDumpPath + ", size: " + threadDumpBuilder.length();
                    System.out.println(msg);
                    log.warning(msg);
                }
                catch (IOException e) {
                    System.out.println("exception while initialization");
                    e.printStackTrace();
                    log.log(Level.WARNING, "Failed creating thread dumper logger");
                }
            }
            System.out.println("ShutdownThread finished...");
            log.warning("ShutdownThread finished...");
        }
    }

    private class ShutdownHandlerThread
    extends Thread {
        private ShutdownHook hook;
        private String result;

        public ShutdownHandlerThread(ThreadGroup group, ShutdownHook hook) {
            super(group, hook.getName());
            this.hook = null;
            this.result = null;
            this.hook = hook;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.result = this.hook.shutdown();
        }

        public String getResultMessage() {
            return this.result;
        }
    }
}

