/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecatedComponent;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.ComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.util.DNSResolverFactory;

public class MessageRouterConfig {
    public static final String DISCO_NAME_PROP_KEY = "disco-name";
    public static final String DISCO_SHOW_VERSION_PROP_KEY = "disco-show-version";
    public static final String LOCAL_ADDRESSES_PROP_KEY = "hostnames";
    public static final String MSG_RECEIVERS_PROP_KEY = "components/msg-receivers/";
    public static final String REGISTRATOR_PROP_KEY = "components/registrators/";
    public static final String UPDATES_CHECKING_INTERVAL_PROP_KEY = "updates-checking-interval";
    public static final long UPDATES_CHECKING_INTERVAL_PROP_VAL = 7L;
    public static final String UPDATES_CHECKING_PROP_KEY = "updates-checking";
    private static String[] LOCAL_ADDRESSES_PROP_VALUE = new String[]{"localhost", "hostname"};
    private static final Logger log = Logger.getLogger("tigase.server.MessageRouterConfig");
    private static final String[] DEF_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "sess-man", "bosh", "monitor", "amp", "ws2s", "eventbus"};
    private static final String[] ALL_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "sess-man", "ssend", "srecv", "bosh", "monitor", "ws2s", "eventbus"};
    public static final String MSG_RECEIVERS_NAMES_PROP_KEY = "components/msg-receivers/id-names";
    private static final String[] SM_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"ext-comp", "sess-man", "monitor", "amp", "eventbus"};
    private static final String[] DEF_REGISTRATOR_NAMES_PROP_VAL = new String[]{"vhost-man", "stats"};
    private static final String[] CS_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "ext-comp", "bosh", "monitor", "amp", "ws2s", "eventbus"};
    private static final Map<String, String> COMPONENT_CLASSES = new LinkedHashMap<String, String>();
    private static final String[] COMP_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"ext", "monitor", "amp"};
    private static final Map<String, String> COMP_CLUS_MAP = new LinkedHashMap<String, String>();
    private static final String[] CLUSTER_REGISTRATOR_NAMES_PROP_VAL = new String[]{"vhost-man", "stats", "cluster-contr"};
    public static final Boolean UPDATES_CHECKING_PROP_VAL = true;
    public static final String REGISTRATOR_NAMES_PROP_KEY = "components/registrators/id-names";
    public static final boolean DISCO_SHOW_VERSION_PROP_VAL = true;
    public static final String DISCO_NAME_PROP_VAL = "Tigase";
    private Map<String, Object> props = null;

    public MessageRouterConfig(Map<String, Object> props) {
        this.props = props;
    }

    public boolean componentClassEquals(String cls_name, Class<? extends ServerComponent> currCls) {
        Class<ServerComponent> cls = null;
        try {
            cls = ModulesManagerImpl.getInstance().getServerComponentClass(cls_name);
            if (cls == null && (!XMPPServer.isOSGi() || COMPONENT_CLASSES.containsValue(cls_name) || COMP_CLUS_MAP.containsValue(cls_name)) || "tigase.server.xmppcomponent.ComponentConnectionManager".equals(cls_name) || "tigase.cluster.VirtualComponent".equals(cls_name)) {
                cls = this.getClass().getClassLoader().loadClass(cls_name);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return cls != null && currCls.equals(cls);
    }

    public static void getDefaults(Map<String, Object> defs, Map<String, Object> params, String comp_name) {
        boolean cluster_mode = MessageRouterConfig.isTrue((String)params.get("--cluster-mode"));
        log.log(Level.CONFIG, "Cluster mode: {0}", params.get("--cluster-mode"));
        if (cluster_mode) {
            log.config("Cluster mode is on, replacing known components with cluster versions:");
            for (Map.Entry<String, String> entry : COMPONENT_CLASSES.entrySet()) {
                String cls = COMP_CLUS_MAP.get(entry.getValue());
                if (cls == null) continue;
                log.log(Level.CONFIG, "Replacing {0} with {1}", new Object[]{entry.getValue(), cls});
                entry.setValue(cls);
            }
        } else {
            log.config("Cluster mode is off.");
        }
        String config_type = (String)params.get("config-type");
        Object[] rcv_names = DEF_MSG_RECEIVERS_NAMES_PROP_VAL;
        Object par_names = params.get(comp_name + "/" + MSG_RECEIVERS_NAMES_PROP_KEY);
        if (par_names != null) {
            rcv_names = (String[])par_names;
        } else {
            if (config_type.equals("--gen-config-all")) {
                rcv_names = ALL_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-sm")) {
                rcv_names = SM_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-cs")) {
                rcv_names = CS_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-comp")) {
                rcv_names = COMP_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
        }
        Arrays.sort(rcv_names);
        log.log(Level.CONFIG, "Configured type: {0}, loading components: {1}", new Object[]{config_type, Arrays.asList(rcv_names)});
        for (String key : params.keySet()) {
            String new_comp_name;
            if (key.startsWith("--ext-comp") && Arrays.binarySearch(rcv_names, new_comp_name = "ext-comp" + key.substring("--ext-comp".length())) < 0) {
                rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
                rcv_names[rcv_names.length - 1] = new_comp_name;
                Arrays.sort(rcv_names);
            }
            if (!key.startsWith("--comp-name")) continue;
            String comp_name_suffix = key.substring("--comp-name".length());
            String c_name = (String)params.get("--comp-name" + comp_name_suffix);
            c_name = c_name.toLowerCase();
            String c_class = (String)params.get("--comp-class" + comp_name_suffix);
            if (Arrays.binarySearch(rcv_names, c_name) >= 0) continue;
            defs.put(MSG_RECEIVERS_PROP_KEY + c_name + ".class", c_class);
            defs.put(MSG_RECEIVERS_PROP_KEY + c_name + ".active", true);
            rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
            rcv_names[rcv_names.length - 1] = c_name;
            Arrays.sort(rcv_names);
        }
        if (cluster_mode) {
            log.config("In cluster mode I am setting up 1 listening xep-0114 component:");
            if (Arrays.binarySearch(rcv_names, "cl-comp") < 0) {
                defs.put("components/msg-receivers/cl-comp.class", "tigase.cluster.ClusterConnectionManager");
                defs.put("components/msg-receivers/cl-comp.active", true);
                rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
                rcv_names[rcv_names.length - 1] = "cl-comp";
                Arrays.sort(rcv_names);
            }
        }
        defs.put(MSG_RECEIVERS_NAMES_PROP_KEY, rcv_names);
        for (Object name : rcv_names) {
            if (defs.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".class") != null) continue;
            String def_class = COMPONENT_CLASSES.get(name);
            if (def_class == null) {
                def_class = "tigase.server.xmppcomponent.ComponentConnectionManager";
            }
            defs.put(MSG_RECEIVERS_PROP_KEY + (String)name + ".class", def_class);
            defs.put(MSG_RECEIVERS_PROP_KEY + (String)name + ".active", true);
        }
        String[] registr = DEF_REGISTRATOR_NAMES_PROP_VAL;
        if (cluster_mode) {
            registr = CLUSTER_REGISTRATOR_NAMES_PROP_VAL;
        }
        defs.put(REGISTRATOR_NAMES_PROP_KEY, registr);
        for (String reg : registr) {
            defs.put(REGISTRATOR_PROP_KEY + reg + ".class", COMPONENT_CLASSES.get(reg));
            defs.put(REGISTRATOR_PROP_KEY + reg + ".active", true);
        }
        LOCAL_ADDRESSES_PROP_VALUE = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolverFactory.getInstance().getDefaultHosts();
        defs.put(LOCAL_ADDRESSES_PROP_KEY, LOCAL_ADDRESSES_PROP_VALUE);
        defs.put(DISCO_NAME_PROP_KEY, DISCO_NAME_PROP_VAL);
        defs.put(DISCO_SHOW_VERSION_PROP_KEY, true);
        defs.put(UPDATES_CHECKING_PROP_KEY, UPDATES_CHECKING_PROP_VAL);
        defs.put(UPDATES_CHECKING_INTERVAL_PROP_KEY, 7L);
    }

    public String[] getMsgRcvActiveNames() {
        Object[] names = (String[])this.props.get(MSG_RECEIVERS_NAMES_PROP_KEY);
        ArrayList<String> availableNames = new ArrayList<String>();
        for (String string : names) {
            if (!this.hasClassForServerComponent(string) || this.props.get(MSG_RECEIVERS_PROP_KEY + string + ".active") == null || !((Boolean)this.props.get(MSG_RECEIVERS_PROP_KEY + string + ".active")).booleanValue()) continue;
            availableNames.add(string);
        }
        names = availableNames.toArray(new String[availableNames.size()]);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "active message receivers = {0}", Arrays.toString(names));
        }
        return names;
    }

    public String[] getMsgRcvInactiveNames() {
        Object[] names = (String[])this.props.get(MSG_RECEIVERS_NAMES_PROP_KEY);
        ArrayList<String> al = new ArrayList<String>();
        for (String string : names) {
            if (this.props.get(MSG_RECEIVERS_PROP_KEY + string + ".active") == null || !((Boolean)this.props.get(MSG_RECEIVERS_PROP_KEY + string + ".active")).booleanValue()) {
                al.add(string);
            }
            if (!this.hasClassForServerComponent(string)) continue;
            al.add(string);
        }
        names = al.toArray(new String[al.size()]);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "inactive message receivers = {0}", Arrays.toString(names));
        }
        return names;
    }

    public ServerComponent getMsgRcvInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cls_name = (String)this.props.get(MSG_RECEIVERS_PROP_KEY + name + ".class");
        ServerComponent cls = null;
        cls = ModulesManagerImpl.getInstance().getServerComponent(cls_name);
        if (cls == null && (!XMPPServer.isOSGi() || COMPONENT_CLASSES.containsValue(cls_name) || COMP_CLUS_MAP.containsValue(cls_name)) || "tigase.server.xmppcomponent.ComponentConnectionManager".equals(cls_name) || "tigase.cluster.VirtualComponent".equals(cls_name)) {
            cls = (ServerComponent)this.getClass().getClassLoader().loadClass(cls_name).newInstance();
        }
        if (cls != null && cls.getClass().isAnnotationPresent(TigaseDeprecatedComponent.class)) {
            TigaseDeprecatedComponent annotation = cls.getClass().getAnnotation(TigaseDeprecatedComponent.class);
            log.log(Level.WARNING, "Deprecated Component: " + cls.getClass().getCanonicalName() + ", INFO: " + annotation.note() + "\n");
        }
        return cls;
    }

    public ComponentRegistrator getRegistrInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cls_name = (String)this.props.get(REGISTRATOR_PROP_KEY + name + ".class");
        if (cls_name.equals("tigase.server.XMPPServiceCollector") || cls_name.equals("tigase.disco.XMPPServiceCollector")) {
            log.warning("This class is not used anymore. Correct your configuration please. Remove all references to class: XMPPServiceCollector.");
            return null;
        }
        return (ComponentRegistrator)this.getClass().getClassLoader().loadClass(cls_name).newInstance();
    }

    public String[] getRegistrNames() {
        Object[] names = (String[])this.props.get(REGISTRATOR_NAMES_PROP_KEY);
        log.config(Arrays.toString(names));
        ArrayList<Object> al = new ArrayList<Object>();
        for (Object name : names) {
            if (!((Boolean)this.props.get(REGISTRATOR_PROP_KEY + (String)name + ".active")).booleanValue()) continue;
            al.add(name);
        }
        return al.toArray(new String[al.size()]);
    }

    private boolean hasClassForServerComponent(String name) {
        try {
            String cls_name = (String)this.props.get(MSG_RECEIVERS_PROP_KEY + name + ".class");
            if (cls_name == null) {
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "Can't load component " + name + ": Class is not defined in config.");
                }
                return false;
            }
            if (ModulesManagerImpl.getInstance().hasClassForServerComponent(cls_name)) {
                return true;
            }
            if (!(!XMPPServer.isOSGi() || COMPONENT_CLASSES.containsValue(cls_name) || COMP_CLUS_MAP.containsValue(cls_name) || "tigase.server.xmppcomponent.ComponentConnectionManager".equals(cls_name) || "tigase.cluster.VirtualComponent".equals(cls_name))) {
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "Can't load component " + name + ": " + cls_name + " is external class.");
                }
                return false;
            }
            this.getClass().getClassLoader().loadClass(cls_name);
            return true;
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Can't load component " + name + ": " + ex.getMessage());
            }
            return false;
        }
    }

    private static boolean isTrue(String val) {
        if (val == null) {
            return false;
        }
        String value = val.toLowerCase();
        return value.equals("true") || value.equals("yes") || value.equals("on") || value.equals("1");
    }

    static {
        COMPONENT_CLASSES.put("c2s", "tigase.server.xmppclient.ClientConnectionManager");
        COMPONENT_CLASSES.put("s2s", "tigase.server.xmppserver.S2SConnectionManager");
        COMPONENT_CLASSES.put("ext-comp", "tigase.server.xmppcomponent.ComponentConnectionManager");
        COMPONENT_CLASSES.put("ext", "tigase.server.ext.ComponentProtocol");
        COMPONENT_CLASSES.put("cl-comp", "tigase.cluster.ClusterConnectionManager");
        COMPONENT_CLASSES.put("sess-man", "tigase.server.xmppsession.SessionManager");
        COMPONENT_CLASSES.put("ssend", "tigase.server.ssender.StanzaSender");
        COMPONENT_CLASSES.put("srecv", "tigase.server.sreceiver.StanzaReceiver");
        COMPONENT_CLASSES.put("bosh", "tigase.server.bosh.BoshConnectionManager");
        COMPONENT_CLASSES.put("stats", "tigase.stats.StatisticsCollector");
        COMPONENT_CLASSES.put("cluster-contr", "tigase.cluster.ClusterController");
        COMPONENT_CLASSES.put("vhost-man", "tigase.vhosts.VHostManager");
        COMPONENT_CLASSES.put("monitor", "tigase.monitor.MonitorComponent");
        COMPONENT_CLASSES.put("amp", "tigase.server.amp.AmpComponent");
        COMPONENT_CLASSES.put("ws2s", "tigase.server.websocket.WebSocketClientConnectionManager");
        COMPONENT_CLASSES.put("eventbus", "tigase.disteventbus.component.EventBusComponent");
        COMP_CLUS_MAP.put("tigase.server.xmppsession.SessionManager", "tigase.cluster.SessionManagerClustered");
        COMP_CLUS_MAP.put("tigase.server.xmppclient.ClientConnectionManager", "tigase.cluster.ClientConnectionClustered");
        COMP_CLUS_MAP.put("tigase.server.bosh.BoshConnectionManager", "tigase.cluster.BoshConnectionClustered");
        COMP_CLUS_MAP.put("tigase.server.websocket.WebSocketClientConnectionManager", "tigase.cluster.WebSocketClientConnectionClustered");
        COMP_CLUS_MAP.put("tigase.server.amp.AmpComponent", "tigase.cluster.AmpComponentClustered");
    }
}

