/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.script.ScriptEngineManager;
import tigase.component.AbstractComponent;
import tigase.component.AbstractContext;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.modules.Module;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.conf.ConfigurationException;
import tigase.db.comp.ComponentRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.core.Kernel;
import tigase.monitor.BeanConfigurator;
import tigase.monitor.MonitorContext;
import tigase.monitor.MonitorExtension;
import tigase.monitor.MonitorTask;
import tigase.monitor.TaskConfigItemJDBCRepository;
import tigase.monitor.TasksScriptRegistrar;
import tigase.monitor.TimerTaskService;
import tigase.monitor.modules.AdHocCommandMonitorModule;
import tigase.monitor.modules.AddScriptTaskCommand;
import tigase.monitor.modules.AddTimerScriptTaskCommand;
import tigase.monitor.modules.DeleteScriptTaskCommand;
import tigase.monitor.modules.DiscoveryMonitorModule;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.ClassUtil;
import tigase.util.TimerTask;

public class MonitorComponent
extends AbstractComponent<MonitorContext> {
    public static final String EVENTS_XMLNS = "tigase:monitor:event";
    private Kernel kernel = new Kernel();
    private final TimerTaskService timerTaskService = new TimerTaskService(){

        @Override
        public void addTimerTask(TimerTask task, long delay) {
            MonitorComponent.this.addTimerTask(task, delay);
        }

        @Override
        public void addTimerTask(TimerTask task, long initialDelay, long period) {
            MonitorComponent.this.addTimerTask(task, initialDelay, period);
        }
    };

    @Override
    protected MonitorContext createContext() {
        return new MonitorContextImpl(this);
    }

    @Override
    public String getComponentVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    @Override
    protected Map<String, Class<? extends Module>> getDefaultModulesList() {
        HashMap<String, Class<? extends Module>> result = new HashMap<String, Class<? extends Module>>();
        result.put("urn:xmpp:ping", XmppPingModule.class);
        result.put("jabber:iq:version", JabberVersionModule.class);
        result.put("commands", AdHocCommandMonitorModule.class);
        result.put("disco", DiscoveryMonitorModule.class);
        return result;
    }

    @Override
    public String getDiscoCategory() {
        return "component";
    }

    @Override
    public String getDiscoCategoryType() {
        return "monitor";
    }

    @Override
    public String getDiscoDescription() {
        return "Monitor Component";
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return true;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        Object mailerExt;
        Set<Class> classes;
        if (props.size() <= 1) {
            return;
        }
        super.setProperties(props);
        this.kernel.registerBean("eventBus").asInstance(((MonitorContext)this.context).getEventBus()).exec();
        this.kernel.registerBean(BeanConfigurator.class).exec();
        this.kernel.registerBean("TasksScriptRegistrar").asClass(TasksScriptRegistrar.class).exec();
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.kernel.registerBean("scriptEngineManager").asInstance(scriptEngineManager).exec();
        this.kernel.registerBean("bindings").asInstance(scriptEngineManager.getBindings()).exec();
        this.kernel.registerBean("context").asInstance(this.getContext()).exec();
        this.kernel.registerBean("monitorComponent").asInstance(this).exec();
        this.kernel.registerBean("timerTaskService").asInstance(this.timerTaskService).exec();
        this.kernel.registerBean("runtime").asInstance(MonitorRuntime.getMonitorRuntime()).exec();
        this.kernel.registerBean("kernel").asInstance(this.kernel).exec();
        String repoClass = TaskConfigItemJDBCRepository.class.getName();
        try {
            ComponentRepository repo_tmp = (ComponentRepository)Class.forName(repoClass).newInstance();
            repo_tmp.setProperties(props);
            this.log.log(Level.WARNING, "Monitoring Tasks: {0} with items: {1}", new Object[]{repo_tmp, repo_tmp.toString()});
            repo_tmp.reload();
            this.kernel.registerBean("tasksRepo").asInstance(repo_tmp).exec();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can not create T repository instance for class: " + repoClass, e);
        }
        AdHocCommand ahc = new AddScriptTaskCommand((MonitorContext)this.context);
        ((AdHocCommandMonitorModule)this.getModuleProvider().getModule("commands")).register(ahc);
        this.kernel.registerBean(ahc.getName()).asInstance(ahc).exec();
        ahc = new AddTimerScriptTaskCommand((MonitorContext)this.context);
        ((AdHocCommandMonitorModule)this.getModuleProvider().getModule("commands")).register(ahc);
        this.kernel.registerBean(ahc.getName()).asInstance(ahc).exec();
        ahc = new DeleteScriptTaskCommand((MonitorContext)this.context);
        ((AdHocCommandMonitorModule)this.getModuleProvider().getModule("commands")).register(ahc);
        this.kernel.registerBean(ahc.getName()).asInstance(ahc).exec();
        try {
            classes = ClassUtil.getClassesImplementing(MonitorTask.class);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Found monitor tasks classes: " + classes.toString());
            }
            for (Class class1 : classes) {
                if (class1.getAnnotation(Bean.class) == null) continue;
                this.kernel.registerBean(class1).exec();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            classes = ClassUtil.getClassesImplementing(MonitorExtension.class);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Found monitor ext classes: " + classes.toString());
            }
            for (Class class1 : classes) {
                if (class1.getAnnotation(Bean.class) == null) continue;
                this.kernel.registerBean(class1).exec();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.kernel.isBeanClassRegistered("monitor-mailer") && (mailerExt = this.kernel.getInstance("monitor-mailer")) instanceof MonitorExtension) {
            ((MonitorExtension)mailerExt).setProperties(props);
        }
        ((TasksScriptRegistrar)this.kernel.getInstance("TasksScriptRegistrar")).load();
        ((BeanConfigurator)this.kernel.getInstance("bean-configurator")).configureBeans(props);
    }

    private class MonitorContextImpl
    extends AbstractContext
    implements MonitorContext {
        public MonitorContextImpl(AbstractComponent<?> component) {
            super(component);
        }

        @Override
        public Kernel getKernel() {
            return MonitorComponent.this.kernel;
        }
    }
}

