/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import tigase.io.BufferUnderflowException;
import tigase.io.IOInterface;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;
import tigase.stats.StatisticsList;

public class TLSIO
implements IOInterface {
    public static final String TLS_CAPS = "tls-caps";
    private static final Logger log = Logger.getLogger(TLSIO.class.getName());
    private IOInterface io = null;
    private ByteBuffer tlsInput = null;
    private TLSWrapper tlsWrapper = null;

    public TLSIO(IOInterface ioi, TLSWrapper wrapper, ByteOrder order) throws IOException {
        this.io = ioi;
        this.tlsWrapper = wrapper;
        this.tlsWrapper.setDebugId(this.toString());
        this.tlsInput = ByteBuffer.allocate(this.tlsWrapper.getAppBuffSize());
        this.tlsInput.order(order);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "TLS Socket created: {0}", this.io.toString());
        }
        if (this.tlsWrapper.isClientMode()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("TLS - client mode, starting handshaking now...");
            }
            this.write(ByteBuffer.allocate(0));
        }
    }

    @Override
    public int bytesRead() {
        return this.io.bytesRead();
    }

    @Override
    public long getBytesSent(boolean reset) {
        return this.io.getBytesSent(reset);
    }

    @Override
    public long getTotalBytesSent() {
        return this.io.getTotalBytesSent();
    }

    @Override
    public long getBytesReceived(boolean reset) {
        return this.io.getBytesReceived(reset);
    }

    @Override
    public long getTotalBytesReceived() {
        return this.io.getTotalBytesReceived();
    }

    @Override
    public long getBuffOverflow(boolean reset) {
        return this.io.getBuffOverflow(reset);
    }

    @Override
    public long getTotalBuffOverflow() {
        return this.io.getTotalBuffOverflow();
    }

    @Override
    public boolean checkCapabilities(String caps) {
        return caps.contains(TLS_CAPS) || this.io.checkCapabilities(caps);
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.tlsWrapper.getPacketBuffSize();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.io.getSocketChannel();
    }

    @Override
    public void getStatistics(StatisticsList list, boolean reset) {
        if (this.io != null) {
            this.io.getStatistics(list, reset);
        }
    }

    @Override
    public boolean isConnected() {
        return this.io.isConnected();
    }

    @Override
    public boolean isRemoteAddress(String addr) {
        return this.io.isRemoteAddress(addr);
    }

    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        ByteBuffer tmpBuffer = this.io.read(buff);
        if (this.io.bytesRead() > 0) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Read bytes: {0}, {1}", new Object[]{this.io.bytesRead(), this.toString()});
            }
            return this.decodeData(tmpBuffer);
        }
        return null;
    }

    @Override
    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called..." + this.toString());
        }
        this.io.stop();
        this.tlsWrapper.close();
    }

    public String toString() {
        return "TLS: " + this.io.toString();
    }

    @Override
    public boolean waitingToSend() {
        return this.io.waitingToSend();
    }

    @Override
    public int waitingToSendSize() {
        return this.io.waitingToSendSize();
    }

    @Override
    public int write(ByteBuffer buff) throws IOException {
        TLSStatus stat = this.tlsWrapper.getStatus();
        int loop_cnt = 0;
        int max_loop_runs = 100000;
        boolean breakNow = true;
        while ((stat == TLSStatus.NEED_WRITE || stat == TLSStatus.NEED_READ) && ++loop_cnt < max_loop_runs) {
            switch (stat) {
                case NEED_WRITE: {
                    this.writeBuff(ByteBuffer.allocate(0));
                    break;
                }
                case NEED_READ: {
                    if (this.io.waitingToSend()) {
                        this.io.write(null);
                        if (!(this.tlsWrapper.getTlsEngine().getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || buff != null && buff.hasRemaining())) {
                            breakNow = true;
                        }
                    }
                    ByteBuffer rbuff = this.read(ByteBuffer.allocate(this.tlsWrapper.getNetBuffSize()));
                    break;
                }
            }
            stat = this.tlsWrapper.getStatus();
            if (!breakNow) continue;
        }
        if (loop_cnt > max_loop_runs / 2) {
            log.log(Level.WARNING, "Infinite loop detected in write(buff) TLS code, tlsWrapper.getStatus(): {0}, io: {1}", new Object[]{this.tlsWrapper.getStatus(), this.toString()});
            throw new EOFException("Socket has been closed due to TLS problems.");
        }
        if (this.tlsWrapper.getStatus() == TLSStatus.CLOSED) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("TLS Socket closed...");
            }
            throw new EOFException("Socket has been closed.");
        }
        int result = -1;
        if (buff == null) {
            result = this.io.write(null);
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "TLS - Writing data, remaining: {0}, {1}", new Object[]{buff.remaining(), this.toString()});
            }
            result = this.writeBuff(buff);
        }
        return result;
    }

    private ByteBuffer decodeData(ByteBuffer input) throws IOException {
        TLSStatus stat = null;
        boolean continueLoop = true;
        do {
            this.tlsInput = this.tlsWrapper.unwrap(input, this.tlsInput);
            switch (this.tlsWrapper.getStatus()) {
                case NEED_WRITE: {
                    this.writeBuff(ByteBuffer.allocate(0));
                    break;
                }
                case UNDERFLOW: {
                    if (this.tlsInput.capacity() == this.tlsInput.remaining()) {
                        throw new BufferUnderflowException();
                    }
                    input.compact();
                    continueLoop = false;
                    break;
                }
                case CLOSED: {
                    if (!log.isLoggable(Level.FINER)) break;
                    log.finer("TLS Socket closed..." + this.toString());
                }
            }
            stat = this.tlsWrapper.getStatus();
        } while (continueLoop && (stat == TLSStatus.NEED_READ || stat == TLSStatus.OK) && input.hasRemaining());
        if (continueLoop) {
            if (input.hasRemaining()) {
                input.rewind();
            } else {
                input.clear();
            }
        }
        this.tlsInput.flip();
        return this.tlsInput;
    }

    private int writeBuff(ByteBuffer buff) throws IOException {
        int result = 0;
        int wr = 0;
        int loop_cnt = 0;
        int max_loop_runs = 100000;
        do {
            if (this.tlsWrapper.getStatus() == TLSStatus.NEED_READ) {
                ByteBuffer rbuff = this.read(ByteBuffer.allocate(this.tlsWrapper.getNetBuffSize()));
            }
            ByteBuffer tlsOutput = ByteBuffer.allocate(this.tlsWrapper.getNetBuffSize());
            tlsOutput.clear();
            this.tlsWrapper.wrap(buff, tlsOutput);
            if (this.tlsWrapper.getStatus() == TLSStatus.CLOSED) {
                throw new EOFException("Socket has been closed.");
            }
            tlsOutput.flip();
            wr = this.io.write(tlsOutput);
            result += wr;
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINER, "TLS - Writing data, remaining: {0}, {1}", new Object[]{buff.remaining(), this.toString()});
        } while (buff.hasRemaining() && ++loop_cnt < max_loop_runs);
        if (loop_cnt > max_loop_runs / 2) {
            log.warning("Infinite loop detected in writeBuff(buff) TLS code, tlsWrapper.getStatus(): " + (Object)((Object)this.tlsWrapper.getStatus()) + ", buff.remaining(): " + buff.remaining() + " io: " + this.toString());
            throw new EOFException("Socket has been closed due to TLS problems.");
        }
        if (this.tlsWrapper.getStatus() == TLSStatus.NEED_WRITE) {
            this.writeBuff(ByteBuffer.allocate(0));
        }
        return result;
    }

    @Override
    public void setLogId(String logId) {
        this.io.setLogId(logId);
    }
}

