/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.BareJID;

public class NodeSubscriptions
extends tigase.pubsub.repository.NodeSubscriptions {
    protected final ThreadLocal<Map<BareJID, UsersSubscription>> changedSubs = new ThreadLocal();

    public NodeSubscriptions() {
    }

    public NodeSubscriptions(tigase.pubsub.repository.NodeSubscriptions nodeSubscriptions) {
        this.subs.putAll(nodeSubscriptions.getSubscriptionsMap());
    }

    @Override
    public String addSubscriberJid(BareJID bareJid, Subscription subscription) {
        String subid = Utils.createUID(bareJid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        this.changedSubs().put(bareJid, s);
        return subid;
    }

    @Override
    public void changeSubscription(BareJID bareJid, Subscription subscription) {
        UsersSubscription s = (UsersSubscription)this.subs.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            this.changedSubs().put(s.getJid(), s);
        }
    }

    @Override
    protected UsersSubscription get(BareJID bareJid) {
        UsersSubscription us = null;
        us = this.changedSubs().get(bareJid);
        if (us == null && (us = (UsersSubscription)this.subs.get(bareJid)) != null) {
            try {
                return us.clone();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return us;
    }

    @Override
    public UsersSubscription[] getSubscriptions() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.subs.values());
        result.addAll(this.changedSubs().values());
        return result.toArray(new UsersSubscription[0]);
    }

    @Override
    public boolean isChanged() {
        return this.changedSubs().size() > 0;
    }

    public void merge() {
        Map<BareJID, UsersSubscription> changedSubs = this.changedSubs();
        for (Map.Entry<BareJID, UsersSubscription> entry : changedSubs.entrySet()) {
            if (entry.getValue().getSubscription() == Subscription.none) {
                this.subs.remove(entry.getKey());
                continue;
            }
            this.subs.put(entry.getKey(), entry.getValue());
        }
        changedSubs.clear();
    }

    public Map<BareJID, UsersSubscription> getChanged() {
        return this.changedSubs();
    }

    @Override
    public void resetChangedFlag() {
        this.changedSubs().clear();
    }

    private Map<BareJID, UsersSubscription> changedSubs() {
        Map<BareJID, UsersSubscription> changedSubs = this.changedSubs.get();
        if (changedSubs == null) {
            changedSubs = new HashMap<BareJID, UsersSubscription>();
            this.changedSubs.set(changedSubs);
        }
        return changedSubs;
    }
}

