/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component2.exceptions.ComponentException;
import tigase.component2.modules.Module;
import tigase.conf.ConfigurationException;
import tigase.licence.LicenceChecker;
import tigase.osgi.ModulesManagerImpl;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.cluster.PartitionedStrategy;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.modules.PresenceCollectorModuleClustered;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.CapsModule;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.Priority;
import tigase.server.XMPPServer;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class PubSubComponentClustered
extends PubSubComponent
implements ClusteredComponentIfc,
PubSubComponentClusteredIfc {
    private static final Logger a = Logger.getLogger(PubSubComponentClustered.class.getCanonicalName());
    private static final String b = "packet-forward-pubsub-cmd";
    private static final String c = "perm";
    private static final String d = PartitionedStrategy.class.getCanonicalName();
    private static final String e = "pubsub-strategy-class";
    private a f = new a();
    private ClusterControllerIfc g;
    private StrategyIfc h;
    private ComponentInfo i = null;
    private LicenceChecker j = LicenceChecker.getLicenceChecker((String)"acs");
    private long k = 0L;
    private long l = 0L;
    private long m = 0L;
    private long n = 0L;
    private long o = 0L;
    private long p = 0L;
    private long q = 0L;
    private long r = 0L;
    private long s = 0L;
    private long t = 0L;
    private long u = 0L;
    private long v = 0L;
    private long w = 0L;
    private long x = 0L;

    public PubSubComponentClustered() {
        String string;
        String string2 = System.getProperty("cluster-mode");
        if (string2 == null || !Boolean.parseBoolean(string2)) {
            a.severe("You've tried using Clustered version of the component but cluster-mode is disabled");
            a.severe("Shutting down system!");
            System.exit(1);
        }
        if ((string = System.getProperty("sm-cluster-strategy-class")) == null || !"tigase.server.cluster.strategy.OnlineUsersCachingStrategy".equals(string)) {
            a.severe("You've tried using Clustered version of the component but ACS is disabled");
            a.severe("Shutting down system!");
            System.exit(1);
        }
    }

    protected boolean addOutPacket(Packet packet) {
        if (!this.h.filterOutPacket(packet)) {
            return super.addOutPacket(packet);
        }
        return false;
    }

    public synchronized void everyHour() {
        super.everyHour();
        this.u = this.x - this.r;
        this.r = this.x;
        this.n = this.q - this.k;
        this.k = this.q;
    }

    public synchronized void everyMinute() {
        super.everyMinute();
        this.v = this.x - this.s;
        this.s = this.x;
        this.o = this.q - this.l;
        this.l = this.q;
    }

    public synchronized void everySecond() {
        super.everySecond();
        this.w = this.x - this.t;
        this.t = this.x;
        this.p = this.q - this.m;
        this.m = this.q;
    }

    @Override
    public PublishItemModule getPublishItemModule() {
        return this.publishNodeModule;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Locally processed packets last hour", this.u, Level.FINE);
        list.add(this.getName(), "Locally processed packets last minute", this.v, Level.FINE);
        list.add(this.getName(), "Locally processed packets last second", this.w, Level.FINE);
        list.add(this.getName(), "Forwarded packets last hour", this.n, Level.FINE);
        list.add(this.getName(), "Forwarded packets last minute", this.o, Level.FINE);
        list.add(this.getName(), "Forwarded packets last second", this.p, Level.FINE);
    }

    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        this.h.nodeConnected(jid);
    }

    protected void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        this.h.nodeDisconnected(jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPacket(Packet packet) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Received packet: {0}", packet);
        }
        try {
            Serializable serializable;
            List<JID> list = this.h.getNodesForPacket(packet);
            boolean bl = list.contains(this.h.getLocalNodeJid());
            if (a.isLoggable(Level.FINEST)) {
                serializable = new StringBuilder();
                for (JID jID : list) {
                    if (((StringBuilder)serializable).length() > 0) {
                        ((StringBuilder)serializable).append(", ");
                    }
                    ((StringBuilder)serializable).append(jID.toString());
                }
                a.log(Level.FINEST, "packet, processLocally: {0}, will be processed by nodes: [{1}]", new Object[]{bl, ((StringBuilder)serializable).toString()});
            }
            if (bl) {
                if (list.size() == 1) {
                    list = null;
                } else {
                    list = new ArrayList<JID>(list);
                    list.remove(this.h.getLocalNodeJid());
                }
            }
            if (list != null) {
                serializable = new HashMap();
                if (packet.getPermissions() != null) {
                    serializable.put(c, packet.getPermissions().name());
                }
                this.g.sendToNodes(b, (Map)((Object)serializable), packet.getElement(), bl ? this.h.getLocalNodeJid() : packet.getPacketFrom(), null, list.toArray(new JID[list.size()]));
                ++this.q;
            }
            if (bl) {
                super.processPacket(packet);
                this.getPubSubRepository().clearRemoteNodes();
                this.h.packetProcessed();
                ++this.x;
            }
        }
        catch (PubSubException pubSubException) {
            this.sendException(packet, (ComponentException)pubSubException);
        }
        finally {
            this.h.packetProcessed();
        }
    }

    public ComponentInfo getComponentInfo() {
        this.i = super.getComponentInfo();
        this.i.getComponentData().put("PubSubClusteringStrategy", this.h != null ? this.h.getClass() : null);
        return this.i;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map map = super.getDefaults(params);
        map.put(e, d);
        return map;
    }

    public String getDiscoDescription() {
        return super.getDiscoDescription() + " acs-clustered";
    }

    @Override
    public CachedPubSubRepositoryClustered getPubSubRepository() {
        return (CachedPubSubRepositoryClustered)this.pubsubRepository;
    }

    protected void init() {
        if (!this.isRegistered(CapsModule.class)) {
            this.capsModule = (CapsModule)this.registerModule((Module)new CapsModule((PubSubConfig)this.componentConfig, this.getWriter()));
        }
        if (!this.isRegistered(PresenceCollectorModule.class)) {
            this.presenceCollectorModule = (PresenceCollectorModule)this.modulesManager.register(PresenceCollectorModule.class, (Module)new PresenceCollectorModuleClustered((PubSubConfig)this.componentConfig, this.getWriter(), this.capsModule), false);
        }
        ((PresenceCollectorModuleClustered)this.presenceCollectorModule).setStrategy(this.h);
        super.init();
    }

    protected void sendException(Packet packet, ComponentException e) {
        if (this.h.sendException(packet, e)) {
            super.sendException(packet, e);
        }
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        if (this.g != null) {
            this.g.removeCommandListener((CommandListener)this.f);
        }
        this.g = cl_controller;
        this.g.setCommandListener((CommandListener)this.f);
        this.h.setClusterController(cl_controller);
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (props.size() > 1) {
            String string = (String)props.get(e);
            try {
                this.h = (StrategyIfc)ModulesManagerImpl.getInstance().forName(string).newInstance();
                this.h.setProperties(props);
                this.h.setConfig((PubSubConfig)this.componentConfig);
                this.h.setPubSubComponentClustered(this);
                if (this.g != null) {
                    this.h.setClusterController(this.g);
                }
            }
            catch (Exception exception) {
                if (!XMPPServer.isOSGi()) {
                    a.log(Level.SEVERE, "Cannot instance clustering strategy class: " + string, exception);
                }
                throw new ConfigurationException("Cannot instance clustering strategy class: " + string);
            }
        }
        if (this.h != null) {
            super.setProperties(props);
        }
    }

    protected CachedPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        return new CachedPubSubRepositoryClustered(directRepository, this.maxRepositoryCacheSize, this.h);
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(PubSubComponentClustered.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            for (Element element : packets) {
                try {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "processing forwarded packet = {0}", element.toString());
                    }
                    Packet packet = Packet.packetInstance((Element)element);
                    packet.setPacketFrom(fromNode);
                    if (data != null && data.get(PubSubComponentClustered.c) != null) {
                        Permissions permissions = Permissions.valueOf((String)data.get(PubSubComponentClustered.c));
                        packet.setPermissions(permissions);
                    }
                    if (PubSubComponentClustered.super.addPacketNB(packet)) {
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "forwarded packet added to processing queue of component = {0}", element.toString());
                        continue;
                    }
                    a.log(Level.FINE, "forwarded packet dropped due to component queue overflow = {0}", element.toString());
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    a.log(Level.FINEST, "Addressing problem, stringprep failed for packet: {0}", element);
                }
                catch (Throwable throwable) {
                    a.log(Level.SEVERE, "Exception processing forwarded packet = " + element.toString(), throwable);
                }
            }
        }
    }
}

