/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.commands.NodesChangedCommand;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PartitionedStrategy
extends AbstractStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(PartitionedStrategy.class.getCanonicalName());
    private NodesChangedCommand b = new NodesChangedCommand(){

        @Override
        protected CachedPubSubRepositoryClustered getPubSubRepositoryClustered() {
            return PartitionedStrategy.this.pubSubComponent.getPubSubRepository();
        }
    };

    @Override
    public boolean filterOutPacket(Packet packet) {
        return false;
    }

    public JID getNodeForServiceNode(JID serviceJid, String node) {
        int n = Math.abs((391 + serviceJid.hashCode()) * 23 + node.hashCode());
        return this.getNodeForHashCode(n);
    }

    @Override
    public List<JID> getNodesForPacket(Packet packet) {
        if (packet.getElemName() == "presence") {
            if (this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                return Collections.singletonList(this.getLocalNodeJid());
            }
            return this.getNodesConnectedWithLocal();
        }
        if (packet.getElemName() == "message") {
            return Collections.singletonList(this.getLocalNodeJid());
        }
        if (packet.getElemName() == "iq") {
            Element element;
            JID jID = packet.getStanzaTo();
            List list = packet.getElemChildrenStaticStr(PUBSUB_PATH);
            Element element2 = element = list != null && !list.isEmpty() ? (Element)list.get(0) : null;
            if (element == null) {
                Element element3;
                if (packet.getType() == StanzaType.result && (element3 = packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info")) != null && element3.getAttributeStaticStr("node") != null) {
                    if (this.pubSubComponent != null && packet.getPacketFrom() != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                        if (a.isLoggable(Level.FINEST)) {
                            a.log(Level.FINEST, "IQ packet, forwarded disco#info for CAPS, returning local node, packet: {0}", new Object[]{packet});
                        }
                        return Collections.singletonList(this.getLocalNodeJid());
                    }
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "IQ packet, disco#info for CAPS, returning all nodes, packet: {0}", new Object[]{packet});
                    }
                    return this.getNodesConnectedWithLocal();
                }
                return Collections.singletonList(this.getLocalNodeJid());
            }
            String string = element.getAttributeStaticStr("node");
            if (string == null || this.isNodeConfigure(element)) {
                JID jID2 = this.getNodeForServiceJid(jID);
                return Collections.singletonList(jID2);
            }
            JID jID3 = this.getNodeForServiceNode(jID, string);
            return Collections.singletonList(jID3);
        }
        a.log(Level.SEVERE, "received unknown packet = {0}", packet);
        return null;
    }

    @Override
    public boolean isLocalNode(BareJID serviceJid, String node) {
        return this.getLocalNodeJid().equals((Object)this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), node));
    }

    @Override
    public boolean isOnlineLocally(JID jid) {
        return true;
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.b);
        }
        super.setClusterController(cl_controller);
        this.cl_controller.setCommandListener((CommandListener)this.b);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
    }

    @Override
    public void nodeAddedToRootCollection(BareJID serviceJid, String nodeName) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("root-node-added", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeRemovedFromRootCollection(BareJID serviceJid, String nodeName) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("root-node-removed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeConfigurationChanged(BareJID serviceJid, String nodeName) {
        JID jID;
        JID jID2 = jID = nodeName == null ? this.getNodeForServiceJid(JID.jidInstance((BareJID)serviceJid)) : this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("node-config-changed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    public void notifyNodeConfigurationChanges() {
        List<JID> list = this.getNodesConnected();
        Queue queue = (Queue)this.nodesModifications.get();
        this.nodesModifications.remove();
        Map<String, String> map = this.prepareCommandData(null, null);
        this.cl_controller.sendToNodes("nodes-changed-cmd", map, queue, this.getLocalNodeJid(), null, list.toArray(new JID[list.size()]));
    }

    @Override
    public void packetProcessed() {
        if (!((ArrayDeque)this.nodesModifications.get()).isEmpty()) {
            this.notifyNodeConfigurationChanges();
        }
        super.packetProcessed();
    }
}

