/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.AbstractCriteria;
import tigase.archive.RetentionType;
import tigase.archive.TagsHelper;
import tigase.archive.TimestampHelper;
import tigase.archive.VHostItemHelper;
import tigase.archive.db.MessageArchiveRepository;
import tigase.conf.ConfigurationException;
import tigase.db.DBInitException;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.util.TimerTask;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.RSM;
import tigase.xmpp.XMPPException;

public class MessageArchiveComponent
extends AbstractMessageReceiver {
    private static final Logger log = Logger.getLogger(MessageArchiveComponent.class.getCanonicalName());
    private static final String MSG_ARCHIVE_REPO_CLASS_PROP_KEY = "archive-repo-class";
    private static final String MSG_ARCHIVE_REPO_URI_PROP_KEY = "archive-repo-uri";
    private static final boolean DEF_TAGS_SUPPORT_PROP_VAL = false;
    private static final String TAGS_SUPPORT_PROP_KEY = "tags-support";
    private static final String REMOVE_EXPIRED_MESSAGES_KEY = "remove-expired-messages";
    private static final String REMOVE_EXPIRED_MESSAGES_DELAY_KEY = "remove-expired-messages-delay";
    private static final String REMOVE_EXPIRED_MESSAGES_PERIOD_KEY = "remove-expired-messages-period";
    protected MessageArchiveRepository msg_repo = null;
    private boolean tagsSupport = false;
    private float expiredMessagesRemovalTimeAvg = -1.0f;
    private RemoveExpiredTask expiredMessagesRemovalTask = null;

    public MessageArchiveComponent() {
        this.setName("message-archive");
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getElemName() == "message" && packet.getPacketFrom() != null && !this.getComponentId().equals((Object)packet.getPacketFrom())) {
            return packet.getPacketFrom().hashCode();
        }
        if (packet.getStanzaFrom() != null && !this.getComponentId().equals((Object)packet.getStanzaFrom())) {
            return packet.getStanzaFrom().getBareJID().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        return 1;
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public void processPacket(Packet packet) {
        block6: {
            if (packet.getStanzaTo() != null && !this.getComponentId().equals((Object)packet.getStanzaTo()) && "message" == packet.getElemName()) {
                this.storeMessage(packet);
                return;
            }
            try {
                try {
                    this.processActionPacket(packet);
                }
                catch (XMPPException ex) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "internal server while processing packet = " + packet.toString(), ex);
                    }
                    this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, (String)null, true));
                }
            }
            catch (PacketErrorTypeException ex) {
                if (!log.isLoggable(Level.FINEST)) break block6;
                log.log(Level.FINEST, "error with packet in error state - ignoring packet = {0}", packet);
            }
        }
    }

    public void release() {
        super.release();
        if (this.msg_repo != null) {
            this.msg_repo.destroy();
            this.msg_repo = null;
        }
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map defs = super.getDefaults(params);
        String db_uri = (String)params.get("user-repo-url");
        defs.put(TAGS_SUPPORT_PROP_KEY, false);
        if (db_uri == null) {
            db_uri = (String)params.get("--user-db-uri");
        }
        if (db_uri != null) {
            defs.put(MSG_ARCHIVE_REPO_URI_PROP_KEY, db_uri);
        }
        defs.put(REMOVE_EXPIRED_MESSAGES_DELAY_KEY, "PT1H");
        defs.put(REMOVE_EXPIRED_MESSAGES_PERIOD_KEY, "P1D");
        defs.put(REMOVE_EXPIRED_MESSAGES_KEY, false);
        return defs;
    }

    public String getDiscoDescription() {
        return "Message Archiving (XEP-0136) Support";
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Removal time of expired messages (avg)", this.expiredMessagesRemovalTimeAvg, Level.FINE);
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        Boolean enabled;
        block16: {
            try {
                VHostItemHelper.register();
                super.setProperties(props);
                if (props.containsKey(TAGS_SUPPORT_PROP_KEY)) {
                    this.tagsSupport = (Boolean)props.get(TAGS_SUPPORT_PROP_KEY);
                }
                if (props.size() == 1) {
                    return;
                }
                HashMap<String, String> repoProps = new HashMap<String, String>(4);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    repoProps.put(entry.getKey(), entry.getValue().toString());
                }
                String repoClsName = (String)props.get(MSG_ARCHIVE_REPO_CLASS_PROP_KEY);
                String uri = (String)props.get(MSG_ARCHIVE_REPO_URI_PROP_KEY);
                if (uri != null) {
                    Class repoCls = null;
                    if (repoClsName == null) {
                        repoCls = RepositoryFactory.getRepoClass(MessageArchiveRepository.class, (String)uri);
                    } else {
                        try {
                            repoCls = ModulesManagerImpl.getInstance().forName(repoClsName);
                        }
                        catch (ClassNotFoundException ex) {
                            log.log(Level.SEVERE, "Could not find class " + repoClsName + " an implementation of MessageArchive repository", ex);
                            throw new ConfigurationException("Could not find class " + repoClsName + " an implementation of MessageArchive repository", (Exception)ex);
                        }
                    }
                    if (repoCls == null && repoClsName == null) {
                        throw new ConfigurationException("Not found implementation of MessageArchive repository for URI = " + uri);
                    }
                    MessageArchiveRepository old_msg_repo = this.msg_repo;
                    this.msg_repo = (MessageArchiveRepository)repoCls.newInstance();
                    this.msg_repo.initRepository(uri, repoProps);
                    if (old_msg_repo != null) {
                        old_msg_repo.destroy();
                    }
                    break block16;
                }
                log.log(Level.SEVERE, "repository uri is NULL!");
            }
            catch (DBInitException ex) {
                throw new ConfigurationException("Could not initialize MessageArchive repository", (Exception)((Object)ex));
            }
            catch (InstantiationException ex) {
                log.log(Level.SEVERE, "Could not initialize MessageArchive repository", ex);
                throw new ConfigurationException("Could not initialize MessageArchive repository", (Exception)ex);
            }
            catch (IllegalAccessException ex) {
                log.log(Level.SEVERE, "Could not initialize MessageArchive repository", ex);
                throw new ConfigurationException("Could not initialize MessageArchive repository", (Exception)ex);
            }
        }
        if (this.expiredMessagesRemovalTask != null) {
            this.expiredMessagesRemovalTask.cancel();
            this.expiredMessagesRemovalTask = null;
        }
        if ((enabled = (Boolean)props.get(REMOVE_EXPIRED_MESSAGES_KEY)) != null && enabled.booleanValue()) {
            String initialDelayStr = (String)props.get(REMOVE_EXPIRED_MESSAGES_DELAY_KEY);
            String periodStr = (String)props.get(REMOVE_EXPIRED_MESSAGES_PERIOD_KEY);
            long initialDelay = Duration.parse(initialDelayStr).toMillis();
            long period = Duration.parse(periodStr).toMillis();
            log.log(Level.FINE, "scheduling removal of expired messages to once every {0}ms after initial delay of {1}ms", new Object[]{period, initialDelay});
            this.expiredMessagesRemovalTask = new RemoveExpiredTask();
            this.addTimerTask(this.expiredMessagesRemovalTask, initialDelay, period);
        }
    }

    protected void processActionPacket(Packet packet) throws PacketErrorTypeException, XMPPException {
        block15: for (Element child : packet.getElement().getChildren()) {
            if (child.getName() == "list") {
                switch (packet.getType()) {
                    case get: {
                        this.listCollections(packet, child);
                        continue block15;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() == "retrieve") {
                switch (packet.getType()) {
                    case get: {
                        this.getMessages(packet, child);
                        continue block15;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() == "remove") {
                switch (packet.getType()) {
                    case set: {
                        this.removeMessages(packet, child);
                        continue block15;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() == "save") {
                switch (packet.getType()) {
                    case set: {
                        this.saveMessages(packet, child);
                        continue block15;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() != "tags") continue;
            switch (packet.getType()) {
                case set: {
                    this.queryTags(packet, child);
                    continue block15;
                }
            }
            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
        }
    }

    private void listCollections(Packet packet, Element list) throws XMPPException {
        try {
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.fromElement(list, this.tagsSupport);
            List<Element> chats = this.msg_repo.getCollections(packet.getStanzaFrom().getBareJID(), criteria);
            Element retList = new Element("list");
            retList.setXMLNS("urn:xmpp:archive");
            if (chats != null && !chats.isEmpty()) {
                retList.addChildren(chats);
            }
            criteria.prepareResult(retList);
            this.addOutPacket(packet.okResult(retList, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error listing collections", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void removeMessages(Packet packet, Element remove) throws XMPPException {
        if (remove.getAttributeStaticStr("with") == null || remove.getAttributeStaticStr("start") == null || remove.getAttributeStaticStr("end") == null) {
            this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Parameters with, start, end cannot be null", true));
            return;
        }
        try {
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.fromElement(remove, this.tagsSupport);
            this.msg_repo.removeItems(packet.getStanzaFrom().getBareJID(), criteria.getWith(), (Date)criteria.getStart(), (Date)criteria.getEnd());
            this.addOutPacket(packet.okResult((Element)null, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error removing messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void storeMessage(Packet packet) {
        String ownerStr = packet.getAttributeStaticStr("owner");
        if (ownerStr != null) {
            BareJID owner;
            MessageArchiveRepository.Direction direction;
            packet.getElement().removeAttribute("owner");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "for user {0} storing message: {1}", new Object[]{ownerStr, packet.toString()});
            }
            JID buddy = (direction = MessageArchiveRepository.Direction.getDirection(owner = BareJID.bareJIDInstanceNS((String)ownerStr), packet.getStanzaFrom().getBareJID())) == MessageArchiveRepository.Direction.outgoing ? packet.getStanzaTo() : packet.getStanzaFrom();
            Element msg = packet.getElement();
            Date timestamp = null;
            Element delay = msg.findChildStaticStr(Message.MESSAGE_DELAY_PATH);
            if (delay != null) {
                try {
                    String stamp = delay.getAttributeStaticStr("stamp");
                    timestamp = TimestampHelper.parseTimestamp(stamp);
                }
                catch (ParseException e1) {
                    timestamp = new Date();
                }
            } else {
                timestamp = new Date();
            }
            Set<String> tags = null;
            if (this.tagsSupport) {
                tags = TagsHelper.extractTags(msg);
            }
            this.msg_repo.archiveMessage(owner, buddy, direction, timestamp, msg, tags);
        } else {
            log.log(Level.INFO, "Owner attribute missing from packet: {0}", packet);
        }
    }

    private void getMessages(Packet packet, Element retrieve) throws XMPPException {
        try {
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.fromElement(retrieve, this.tagsSupport);
            List<Element> items = this.msg_repo.getItems(packet.getStanzaFrom().getBareJID(), criteria);
            Element retList = new Element("chat");
            if (criteria.getWith() != null) {
                retList.setAttribute("with", criteria.getWith());
            }
            if (criteria.getStart() != null) {
                retList.setAttribute("start", TimestampHelper.format(criteria.getStart()));
            }
            retList.setXMLNS("urn:xmpp:archive");
            if (!items.isEmpty()) {
                retList.addChildren(items);
            }
            criteria.prepareResult(retList);
            this.addOutPacket(packet.okResult(retList, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error retrieving messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void queryTags(Packet packet, Element tagsEl) throws XMPPException {
        try {
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.getRSM().fromElement(tagsEl);
            String startsWith = tagsEl.getAttributeStaticStr("like");
            if (startsWith == null) {
                startsWith = "";
            }
            List<String> tags = this.msg_repo.getTags(packet.getStanzaFrom().getBareJID(), startsWith, criteria);
            tagsEl = new Element("tags", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/archive#query"});
            for (String tag : tags) {
                tagsEl.addChild((XMLNodeIfc)new Element("tag", tag));
            }
            RSM rsm = criteria.getRSM();
            if (rsm.getCount() == null || rsm.getCount() != 0) {
                tagsEl.addChild((XMLNodeIfc)rsm.toElement());
            }
            this.addOutPacket(packet.okResult(tagsEl, 0));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error retrieving messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void saveMessages(Packet packet, Element save) throws XMPPException {
        try {
            List chats = save.getChildren();
            Element saveResult = new Element("save");
            saveResult.setAttributes(save.getAttributes());
            if (chats != null) {
                for (Element chat : chats) {
                    if ("chat" != chat.getName()) continue;
                    Date start = TimestampHelper.parseTimestamp(chat.getAttributeStaticStr("start"));
                    BareJID owner = packet.getStanzaFrom().getBareJID();
                    String with = chat.getAttributeStaticStr("with");
                    if (with == null) {
                        this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'with' attribute", true));
                        return;
                    }
                    JID buddy = JID.jidInstance((String)with);
                    List children = chat.getChildren();
                    if (children != null) {
                        for (Element child : children) {
                            MessageArchiveRepository.Direction direction = MessageArchiveRepository.Direction.getDirection(child.getName());
                            if (direction == null) continue;
                            Date timestamp = null;
                            String secsAttr = child.getAttributeStaticStr("secs");
                            String utcAttr = child.getAttributeStaticStr("utc");
                            if (secsAttr != null) {
                                long secs = Long.parseLong(secsAttr);
                                timestamp = new Date(start.getTime() + secs * 1000L);
                            } else if (utcAttr != null) {
                                timestamp = TimestampHelper.parseTimestamp(utcAttr);
                            }
                            if (timestamp == null) {
                                timestamp = start;
                            }
                            Element msg = child.clone();
                            msg.setName("message");
                            msg.removeAttribute("secs");
                            msg.removeAttribute("utc");
                            switch (direction) {
                                case incoming: {
                                    msg.setAttribute("from", buddy.toString());
                                    msg.setAttribute("to", owner.toString());
                                    break;
                                }
                                case outgoing: {
                                    msg.setAttribute("from", owner.toString());
                                    msg.setAttribute("to", buddy.toString());
                                }
                            }
                            Set<String> tags = null;
                            if (this.tagsSupport) {
                                tags = TagsHelper.extractTags(msg);
                            }
                            this.msg_repo.archiveMessage(owner, buddy, direction, timestamp, msg, tags);
                        }
                    }
                    Element chatResult = new Element("chat");
                    chatResult.setAttributes(chat.getAttributes());
                    saveResult.addChild((XMLNodeIfc)chatResult);
                }
            }
            if (!"true".equals(save.getAttributeStaticStr("auto"))) {
                Packet result = packet.okResult(saveResult, 0);
                this.addOutPacket(result);
            }
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, "Error parsing timestamp", e);
            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Invalid format of timestamp", true));
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.SEVERE, "Error parsing with attribute as jid", ex);
            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Invalid JID as with attribute", true));
        }
    }

    private class RemoveExpiredTask
    extends TimerTask {
        private RemoveExpiredTask() {
        }

        public void run() {
            float time = 0.0f;
            float count = 0.0f;
            for (JID vhost : MessageArchiveComponent.this.vHostManager.getAllVHosts()) {
                try {
                    VHostItem item = MessageArchiveComponent.this.vHostManager.getVHostItem(vhost.getDomain());
                    RetentionType retentionType = VHostItemHelper.getRetentionType(item);
                    switch (retentionType) {
                        case numberOfDays: {
                            Integer days = VHostItemHelper.getRetentionDays(item);
                            if (days == null) break;
                            long start = System.currentTimeMillis();
                            LocalDateTime timestamp = LocalDateTime.now(ZoneId.of("Z")).minusDays(days.intValue());
                            MessageArchiveComponent.this.msg_repo.deleteExpiredMessages(vhost.getBareJID(), timestamp);
                            long stop = System.currentTimeMillis();
                            long executedIn = stop - start;
                            time += (float)executedIn;
                            log.log(Level.FINEST, "removed messsages older than {0} for domain {1} in {2}ms", new Object[]{timestamp.toString(), vhost.getDomain(), executedIn});
                            count += 1.0f;
                            break;
                        }
                        case userDefined: 
                        case unlimited: {
                            log.log(Level.FINEST, "skipping removal of expired messages for domain {0} as removal for retention type {1} is not supported", new Object[]{vhost.getDomain(), retentionType});
                        }
                    }
                }
                catch (Exception ex) {
                    log.log(Level.FINE, "exception removing expired messages", ex);
                }
            }
            MessageArchiveComponent.this.expiredMessagesRemovalTimeAvg = count > 0.0f ? time / count : -1.0f;
        }
    }
}

