/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.pubsub;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.NodeMeta;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class PubSubDAOMongo
extends PubSubDAO<ObjectId> {
    private static final String JID_HASH_ALG = "SHA-256";
    private static final String PUBSUB_AFFILIATIONS = "tig_pubsub_affiliations";
    private static final String PUBSUB_ITEMS = "tig_pubsub_items";
    private static final String PUBSUB_NODES = "tig_pubsub_nodes";
    private static final String PUBSUB_SERVICE_JIDS = "tig_pubsub_service_jids";
    private static final String PUBSUB_SUBSCRIPTIONS = "tig_pubsub_subscriptions";
    private MongoClient mongo;
    private DB db;
    private String resourceUri;

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        this.resourceUri = resource_uri;
        try {
            MongoClientURI uri = new MongoClientURI(this.resourceUri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
            DBCollection serviceJids = null;
            serviceJids = !this.db.collectionExists(PUBSUB_SERVICE_JIDS) ? this.db.createCollection(PUBSUB_SERVICE_JIDS, (DBObject)new BasicDBObject()) : this.db.getCollection(PUBSUB_SERVICE_JIDS);
            serviceJids.createIndex((DBObject)new BasicDBObject("service_jid", (Object)1));
            DBCollection nodes = null;
            nodes = !this.db.collectionExists(PUBSUB_NODES) ? this.db.createCollection(PUBSUB_NODES, (DBObject)new BasicDBObject()) : this.db.getCollection(PUBSUB_NODES);
            nodes.createIndex((DBObject)new BasicDBObject("service_jid_id", (Object)1).append("node_name_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            nodes.createIndex((DBObject)new BasicDBObject("service_jid_id", (Object)1).append("node_name_id", (Object)1).append("collection", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            nodes.createIndex((DBObject)new BasicDBObject("collection", (Object)1));
            DBCollection affiliations = null;
            affiliations = !this.db.collectionExists(PUBSUB_AFFILIATIONS) ? this.db.createCollection(PUBSUB_AFFILIATIONS, (DBObject)new BasicDBObject()) : this.db.getCollection(PUBSUB_AFFILIATIONS);
            affiliations.createIndex((DBObject)new BasicDBObject("node_id", (Object)1), (DBObject)new BasicDBObject());
            affiliations.createIndex((DBObject)new BasicDBObject("node_id", (Object)1).append("jid_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            DBCollection subscriptions = null;
            subscriptions = !this.db.collectionExists(PUBSUB_SUBSCRIPTIONS) ? this.db.createCollection(PUBSUB_SUBSCRIPTIONS, (DBObject)new BasicDBObject()) : this.db.getCollection(PUBSUB_SUBSCRIPTIONS);
            subscriptions.createIndex((DBObject)new BasicDBObject("node_id", (Object)1), (DBObject)new BasicDBObject());
            subscriptions.createIndex((DBObject)new BasicDBObject("node_id", (Object)1).append("jid_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            DBCollection items = null;
            items = !this.db.collectionExists(PUBSUB_ITEMS) ? this.db.createCollection(PUBSUB_ITEMS, (DBObject)new BasicDBObject()) : this.db.getCollection(PUBSUB_ITEMS);
            items.createIndex((DBObject)new BasicDBObject("node_id", (Object)1));
            items.createIndex((DBObject)new BasicDBObject("node_id", (Object)1).append("item_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            items.createIndex((DBObject)new BasicDBObject("node_id", (Object)1).append("creation_date", (Object)1));
        }
        catch (UnknownHostException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + this.resourceUri, (Throwable)ex);
        }
    }

    private byte[] generateId(BareJID user) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RepositoryException("Should not happen!!", (Throwable)ex);
        }
    }

    private byte[] generateId(String in) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(in.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RepositoryException("Should not happen!!", (Throwable)ex);
        }
    }

    private void ensureServiceJid(BareJID serviceJid) throws RepositoryException {
        byte[] id = this.generateId(serviceJid);
        try {
            BasicDBObject crit = new BasicDBObject("_id", (Object)id).append("service_jid", (Object)serviceJid.toString());
            this.db.getCollection(PUBSUB_SERVICE_JIDS).update((DBObject)crit, (DBObject)crit, true, false);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not create entry for service jid " + serviceJid, (Throwable)ex);
        }
    }

    private BasicDBObject createCrit(BareJID serviceJid, String nodeName) throws RepositoryException {
        byte[] serviceJidId = this.generateId(serviceJid);
        BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
        if (nodeName != null) {
            byte[] nodeNameId = this.generateId(nodeName);
            crit.append("node_name_id", (Object)nodeNameId).append("node_name", (Object)nodeName);
        } else {
            crit.append("node_name", (Object)new BasicDBObject("$exists", (Object)false));
        }
        return crit;
    }

    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
    }

    public ObjectId createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, ObjectId collectionId) throws RepositoryException {
        this.ensureServiceJid(serviceJid);
        try {
            String serializedNodeConfig = null;
            if (nodeConfig != null) {
                nodeConfig.setNodeType(nodeType);
                serializedNodeConfig = nodeConfig.getFormElement().toString();
            }
            BasicDBObject dto = this.createCrit(serviceJid, nodeName);
            dto.append("owner", (Object)ownerJid.toString()).append("type", (Object)nodeType.name()).append("configuration", (Object)serializedNodeConfig).append("creation_time", (Object)new Date());
            if (collectionId != null) {
                dto.append("collection", (Object)collectionId);
            }
            ObjectId id = new ObjectId();
            dto.append("_id", (Object)id);
            WriteResult result = this.db.getCollection(PUBSUB_NODES).insert(new DBObject[]{dto});
            return id;
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while adding node to repository", (Throwable)ex);
        }
    }

    public void deleteItem(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("item_id", (Object)id);
            this.db.getCollection(PUBSUB_ITEMS).remove((DBObject)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while deleting node from repository", (Throwable)ex);
        }
    }

    public void deleteNode(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId);
            this.db.getCollection(PUBSUB_ITEMS).remove((DBObject)crit);
            this.db.getCollection(PUBSUB_AFFILIATIONS).remove((DBObject)crit);
            this.db.getCollection(PUBSUB_SUBSCRIPTIONS).remove((DBObject)crit);
            this.db.getCollection(PUBSUB_NODES).remove((DBObject)new BasicDBObject("_id", (Object)nodeId));
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node id", (Throwable)ex);
        }
    }

    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
            List<String> result = this.readAllValuesForField(PUBSUB_NODES, "node_name", (DBObject)crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve list of all nodes", (Throwable)ex);
        }
    }

    public Element getItem(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("item_id", (Object)id);
            DBObject dto = this.db.getCollection(PUBSUB_ITEMS).findOne((DBObject)crit);
            if (dto == null) {
                return null;
            }
            return this.itemDataToElement(((String)dto.get("item")).toCharArray());
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item from repository", (Throwable)ex);
        }
    }

    public Date getItemCreationDate(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("item_id", (Object)id);
            DBObject dto = this.db.getCollection(PUBSUB_ITEMS).findOne((DBObject)crit, (DBObject)new BasicDBObject("creation_date", (Object)1));
            if (dto == null) {
                return null;
            }
            return (Date)dto.get("creation_date");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item creation date from repository", (Throwable)ex);
        }
    }

    public String[] getItemsIds(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId);
            List<String> ids = this.readAllValuesForField(PUBSUB_ITEMS, "item_id", (DBObject)crit);
            return ids.toArray(new String[ids.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item ids from repository", (Throwable)ex);
        }
    }

    public String[] getItemsIdsSince(BareJID serviceJid, ObjectId nodeId, Date since) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("$gte", (Object)new BasicDBObject("creation_date", (Object)since));
            List<String> ids = this.readAllValuesForField(PUBSUB_ITEMS, "item_id", (DBObject)crit);
            return ids.toArray(new String[ids.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item ids since timestamp from repository", (Throwable)ex);
        }
    }

    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, ObjectId nodeId, String nodeName) throws RepositoryException {
        try (DBCursor cursor = null;){
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId);
            cursor = this.db.getCollection(PUBSUB_ITEMS).find((DBObject)crit, (DBObject)new BasicDBObject("item_id", (Object)1).append("creation_date", (Object)1));
            ArrayList<IItems.ItemMeta> results = new ArrayList<IItems.ItemMeta>();
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                results.add(new IItems.ItemMeta(nodeName, (String)it.get("item_id"), (Date)it.get("creation_date")));
            }
            ArrayList<IItems.ItemMeta> arrayList = results;
            return arrayList;
        }
    }

    public Date getItemUpdateDate(BareJID serviceJid, ObjectId nodeId, String id) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("item_id", (Object)id);
            DBObject dto = this.db.getCollection(PUBSUB_ITEMS).findOne((DBObject)crit, (DBObject)new BasicDBObject("update_date", (Object)1));
            if (dto == null) {
                return null;
            }
            return (Date)dto.get("update_date");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while retrieving item update date from repository", (Throwable)ex);
        }
    }

    public NodeAffiliations getNodeAffiliations(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try (DBCursor cursor = null;){
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId);
            cursor = this.db.getCollection(PUBSUB_AFFILIATIONS).find((DBObject)crit, (DBObject)new BasicDBObject("jid", (Object)1).append("affiliation", (Object)1));
            ArrayDeque<UsersAffiliation> data = new ArrayDeque<UsersAffiliation>();
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                BareJID jid = BareJID.bareJIDInstanceNS((String)((String)it.get("jid")));
                Affiliation affil = Affiliation.valueOf((String)((String)it.get("affiliation")));
                data.offer(new UsersAffiliation(jid, affil));
            }
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = NodeAffiliations.create(data);
            return nodeAffiliations;
        }
    }

    public String getNodeConfig(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("_id", (Object)nodeId);
            DBObject result = this.db.getCollection(PUBSUB_NODES).findOne((DBObject)crit, (DBObject)new BasicDBObject());
            return result == null ? null : (String)result.get("configuration");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node configuration", (Throwable)ex);
        }
    }

    public ObjectId getNodeId(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            BasicDBObject crit = this.createCrit(serviceJid, nodeName);
            DBObject result = this.db.getCollection(PUBSUB_NODES).findOne((DBObject)crit, (DBObject)new BasicDBObject());
            return result == null ? null : (ObjectId)result.get("_id");
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve node id", (Throwable)ex);
        }
    }

    public INodeMeta<ObjectId> getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            BasicDBObject crit = this.createCrit(serviceJid, nodeName);
            DBObject result = this.db.getCollection(PUBSUB_NODES).findOne((DBObject)crit, (DBObject)new BasicDBObject());
            if (result == null) {
                return null;
            }
            AbstractNodeConfig nodeConfig = this.parseConfig(nodeName, (String)result.get("configuration"));
            return new NodeMeta((Object)((ObjectId)result.get("_id")), nodeConfig, result.get("owner") != null ? BareJID.bareJIDInstance((String)((String)result.get("owner"))) : null, (Date)result.get("creation_time"));
        }
        catch (MongoException | TigaseStringprepException ex) {
            throw new RepositoryException("Could not retrieve node metadata", ex);
        }
    }

    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        ObjectId collectionId;
        ObjectId objectId = collectionId = nodeName == null ? null : this.getNodeId(serviceJid, nodeName);
        if (collectionId == null && nodeName != null) {
            return new String[0];
        }
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
            if (collectionId != null) {
                crit.append("collection", (Object)collectionId);
            } else {
                crit.append("collection", (Object)new BasicDBObject("$exists", (Object)false));
            }
            List<String> result = this.readAllValuesForField(PUBSUB_NODES, "node_name", (DBObject)crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not retrieve list of all nodes", (Throwable)ex);
        }
    }

    public NodeSubscriptions getNodeSubscriptions(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
        try (DBCursor cursor = null;){
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId);
            cursor = this.db.getCollection(PUBSUB_SUBSCRIPTIONS).find((DBObject)crit, (DBObject)new BasicDBObject("jid", (Object)1).append("subscription", (Object)1).append("subscription_id", (Object)1));
            ArrayDeque<UsersSubscription> data = new ArrayDeque<UsersSubscription>();
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                BareJID jid = BareJID.bareJIDInstanceNS((String)((String)it.get("jid")));
                Subscription subscr = Subscription.valueOf((String)((String)it.get("subscription")));
                String subscr_id = (String)it.get("subscription_id");
                data.offer(new UsersSubscription(jid, subscr_id, subscr));
            }
            tigase.pubsub.repository.cached.NodeSubscriptions result = NodeSubscriptions.create();
            result.init(data);
            tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = result;
            return nodeSubscriptions;
        }
    }

    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNodesList(serviceJid, nodeName);
    }

    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        try (DBCursor cursor = null;){
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(jid);
            BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)jidId).append("jid", (Object)jid.toString());
            cursor = this.db.getCollection(PUBSUB_AFFILIATIONS).find((DBObject)crit, (DBObject)new BasicDBObject("node_name", (Object)1).append("affiliation", (Object)1));
            HashMap<String, UsersAffiliation> result = new HashMap<String, UsersAffiliation>();
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                String node = (String)it.get("node_name");
                Affiliation affil = Affiliation.valueOf((String)((String)it.get("affiliation")));
                result.put(node, new UsersAffiliation(jid, affil));
            }
            HashMap<String, UsersAffiliation> hashMap = result;
            return hashMap;
        }
    }

    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        try (DBCursor cursor = null;){
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(jid);
            BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)jidId).append("jid", (Object)jid.toString());
            cursor = this.db.getCollection(PUBSUB_SUBSCRIPTIONS).find((DBObject)crit, (DBObject)new BasicDBObject("node_name", (Object)1).append("subscription", (Object)1).append("subscription_id", (Object)1));
            HashMap<String, UsersSubscription> result = new HashMap<String, UsersSubscription>();
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                String node = (String)it.get("node_name");
                Subscription subscr = Subscription.valueOf((String)((String)it.get("subscription")));
                String subscr_id = (String)it.get("subscription_id");
                result.put(node, new UsersSubscription(jid, subscr_id, subscr));
            }
            HashMap<String, UsersSubscription> hashMap = result;
            return hashMap;
        }
    }

    public void removeAllFromRootCollection(BareJID serviceJid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
            this.db.getCollection(PUBSUB_ITEMS).remove((DBObject)crit);
            this.db.getCollection(PUBSUB_AFFILIATIONS).remove((DBObject)crit);
            this.db.getCollection(PUBSUB_SUBSCRIPTIONS).remove((DBObject)crit);
            crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
            this.db.getCollection(PUBSUB_NODES).remove((DBObject)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not remove all nodes from root collection", (Throwable)ex);
        }
    }

    public void removeFromRootCollection(BareJID serviceJid, ObjectId nodeId) throws RepositoryException {
    }

    public void removeNodeSubscription(BareJID serviceJid, ObjectId nodeId, BareJID jid) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(jid);
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)jidId).append("jid", (Object)jid.toString());
            this.db.getCollection(PUBSUB_SUBSCRIPTIONS).remove((DBObject)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not remove user subscriptions", (Throwable)ex);
        }
    }

    public void removeService(BareJID serviceJid) throws RepositoryException {
        try {
            this.removeAllFromRootCollection(serviceJid);
            byte[] jidId = this.generateId(serviceJid);
            BasicDBObject crit = new BasicDBObject("jid_id", (Object)jidId).append("jid", (Object)serviceJid.toString());
            this.db.getCollection(PUBSUB_AFFILIATIONS).remove((DBObject)crit);
            this.db.getCollection(PUBSUB_SUBSCRIPTIONS).remove((DBObject)crit);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not remove service with jid = " + serviceJid, (Throwable)ex);
        }
    }

    public void updateNodeConfig(BareJID serviceJid, ObjectId nodeId, String serializedNodeConfig, ObjectId collectionId) throws RepositoryException {
        try {
            BasicDBObject crit = new BasicDBObject("_id", (Object)nodeId);
            BasicDBObject set = new BasicDBObject("configuration", (Object)serializedNodeConfig);
            BasicDBObject dto = new BasicDBObject("$set", (Object)set);
            if (collectionId != null) {
                set.append("collection", (Object)collectionId);
            } else {
                dto.append("$unset", (Object)new BasicDBObject("collection", (Object)""));
            }
            this.db.getCollection(PUBSUB_NODES).update((DBObject)crit, (DBObject)dto);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Error while updating node configuration in repository", (Throwable)ex);
        }
    }

    public void updateNodeAffiliation(BareJID serviceJid, ObjectId nodeId, String nodeName, UsersAffiliation userAffiliation) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(userAffiliation.getJid());
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)jidId).append("jid", (Object)userAffiliation.getJid().toString());
            if (userAffiliation.getAffiliation() == Affiliation.none) {
                this.db.getCollection(PUBSUB_AFFILIATIONS).remove((DBObject)crit);
            } else {
                this.db.getCollection(PUBSUB_AFFILIATIONS).update((DBObject)crit, (DBObject)new BasicDBObject("$setOnInsert", (Object)new BasicDBObject("node_name", (Object)nodeName)).append("$set", (Object)new BasicDBObject("affiliation", (Object)userAffiliation.getAffiliation().name())), true, false);
            }
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not update user affiliations", (Throwable)ex);
        }
    }

    public void updateNodeSubscription(BareJID serviceJid, ObjectId nodeId, String nodeName, UsersSubscription userSubscription) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            byte[] jidId = this.generateId(userSubscription.getJid());
            BasicDBObject crit = new BasicDBObject("node_id", (Object)nodeId).append("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString()).append("jid_id", (Object)jidId).append("jid", (Object)userSubscription.getJid().toString());
            if (userSubscription.getSubscription() == Subscription.none) {
                this.db.getCollection(PUBSUB_SUBSCRIPTIONS).remove((DBObject)crit);
            } else {
                this.db.getCollection(PUBSUB_SUBSCRIPTIONS).update((DBObject)crit, (DBObject)new BasicDBObject("$setOnInsert", (Object)new BasicDBObject("node_name", (Object)nodeName)).append("$set", (Object)new BasicDBObject("subscription", (Object)userSubscription.getSubscription().name()).append("subscription_id", (Object)userSubscription.getSubid())), true, false);
            }
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not update user subscriptions", (Throwable)ex);
        }
    }

    public void writeItem(BareJID serviceJid, ObjectId nodeId, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        try {
            byte[] serviceJidId = this.generateId(serviceJid);
            BasicDBObject crit = new BasicDBObject("service_jid_id", (Object)serviceJidId).append("service_jid", (Object)serviceJid.toString());
            crit.append("node_id", (Object)nodeId).append("item_id", (Object)id);
            BasicDBObject dto = new BasicDBObject("$set", (Object)new BasicDBObject("update_date", (Object)new Date()).append("publisher", (Object)publisher).append("item", (Object)item.toString()));
            dto.append("$setOnInsert", (Object)new BasicDBObject("creation_date", (Object)new Date()));
            this.db.getCollection(PUBSUB_ITEMS).update((DBObject)crit, (DBObject)dto, true, false);
        }
        catch (MongoException ex) {
            throw new RepositoryException("Could not write item to repository", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> readAllValuesForField(String collection, String field, DBObject crit) throws MongoException {
        try (DBCursor cursor = null;){
            cursor = this.db.getCollection(collection).find(crit, (DBObject)new BasicDBObject(field, (Object)1));
            ArrayList<Object> result = new ArrayList<Object>();
            while (cursor.hasNext()) {
                DBObject item = cursor.next();
                Object val = item.get(field);
                result.add(val);
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
    }
}

