/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.types.ObjectId;
import tigase.db.DBInitException;
import tigase.db.NonAuthUserRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.MsgRepository;
import tigase.util.DateTimeFormatter;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPResourceConnection;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class MongoMsgRepository
extends MsgRepository<ObjectId> {
    private static final Logger log = Logger.getLogger(MongoMsgRepository.class.getCanonicalName());
    private static final String JID_HASH_ALG = "SHA-256";
    private static final String MSG_HISTORY_COLLECTION = "msg_history";
    private static final String MSG_BROADCAST_COLLECTION = "msg_broadcast";
    private static final String MSG_BROADCAST_RECP_COLLECTION = "msg_broadcast_recp";
    private static final DateTimeFormatter dt = new DateTimeFormatter();
    private static final Comparator<DBObject> MSG_COMPARATOR = new Comparator<DBObject>(){

        @Override
        public int compare(DBObject o1, DBObject o2) {
            return ((Date)o1.get("ts")).compareTo((Date)o2.get("ts"));
        }
    };
    private String resourceUri;
    private MongoClient mongo;
    private DB db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteMessagesToJID(List<String> db_ids, XMPPResourceConnection session) throws UserNotFoundException {
        int count = 0;
        BareJID to = null;
        try (DBCursor cursor = null;){
            to = session.getBareJID();
            byte[] toHash = this.generateId(to);
            BasicDBObject crit = new BasicDBObject("to_hash", (Object)toHash).append("to", (Object)to.toString());
            if (db_ids == null || db_ids.size() == 0) {
                this.db.getCollection(MSG_HISTORY_COLLECTION).remove((DBObject)crit, WriteConcern.UNACKNOWLEDGED);
            } else {
                cursor = this.db.getCollection(MSG_HISTORY_COLLECTION).find((DBObject)crit);
                while (cursor.hasNext()) {
                    String msgId;
                    DBObject it = cursor.next();
                    if (!it.containsField("ts") || !db_ids.contains(msgId = dt.formatDateTime((Date)it.get("ts")))) continue;
                    this.db.getCollection(MSG_HISTORY_COLLECTION).remove(it);
                    ++count;
                }
            }
        }
        return count;
    }

    public Element getMessageExpired(long time, boolean delete) {
        MsgRepository.MsgDBItem item;
        if (this.expiredQueue.size() == 0) {
            this.loadExpiredQueue(1000);
        } else {
            item = (MsgRepository.MsgDBItem)this.expiredQueue.peek();
            if (item != null && this.earliestOffline < item.expired.getTime()) {
                this.loadExpiredQueue(item.expired);
            }
        }
        item = null;
        while (item == null) {
            try {
                item = (MsgRepository.MsgDBItem)this.expiredQueue.take();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (delete) {
            this.deleteMessage((ObjectId)item.db_id);
        }
        return item.msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException {
        HashMap<Enum, Long> result = new HashMap<Enum, Long>(MsgRepository.MSG_TYPES.values().length);
        try (Object cursor = null;){
            byte[] toHash = this.generateId(to.getBareJID());
            BasicDBObject crit = new BasicDBObject("to_hash", (Object)toHash).append("to", (Object)to.getBareJID().toString());
            for (MsgRepository.MSG_TYPES type : MsgRepository.MSG_TYPES.values()) {
                long count = this.db.getCollection(MSG_HISTORY_COLLECTION).find((DBObject)crit.append("msg_type", (Object)type.toString())).count();
                if (count <= 0L) continue;
                result.put((Enum)type, count);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> getMessagesList(JID to) throws UserNotFoundException {
        LinkedList<Element> result = new LinkedList<Element>();
        try (DBCursor cursor = null;){
            byte[] toHash = this.generateId(to.getBareJID());
            BasicDBObject crit = new BasicDBObject("to_hash", (Object)toHash).append("to", (Object)to.getBareJID().toString());
            cursor = this.db.getCollection(MSG_HISTORY_COLLECTION).find((DBObject)crit);
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                String msgId = null;
                if (it.containsField("ts")) {
                    msgId = dt.formatDateTime((Date)it.get("ts"));
                }
                String sender = null;
                if (it.containsField("to")) {
                    sender = (String)it.get("to");
                }
                MsgRepository.MSG_TYPES messageType = MsgRepository.MSG_TYPES.none;
                if (it.containsField("msg_type")) {
                    messageType = MsgRepository.MSG_TYPES.valueOf((String)((String)it.get("msg_type")));
                }
                if (msgId == null || messageType == null || messageType == MsgRepository.MSG_TYPES.none || sender == null) continue;
                Element item = new Element("item", new String[]{"jid", "node", "type", "name"}, new String[]{to.getBareJID().toString(), msgId, messageType.name(), sender});
                result.add(item);
            }
        }
        return result;
    }

    public void initRepository(String resource_uri, Map<String, String> map) throws DBInitException {
        try {
            this.resourceUri = resource_uri;
            MongoClientURI uri = new MongoClientURI(resource_uri);
            if (this.mongo == null) {
                this.mongo = new MongoClient(uri);
                this.db = this.mongo.getDB(uri.getDatabase());
                DBCollection msgHistoryCollection = null;
                msgHistoryCollection = !this.db.collectionExists(MSG_HISTORY_COLLECTION) ? this.db.createCollection(MSG_HISTORY_COLLECTION, (DBObject)new BasicDBObject()) : this.db.getCollection(MSG_HISTORY_COLLECTION);
                msgHistoryCollection.createIndex((DBObject)new BasicDBObject("ts", (Object)1));
                msgHistoryCollection.createIndex((DBObject)new BasicDBObject("to_hash", (Object)1));
                DBCollection broadcastMsgCollection = !this.db.collectionExists(MSG_BROADCAST_COLLECTION) ? this.db.createCollection(MSG_BROADCAST_COLLECTION, (DBObject)new BasicDBObject()) : this.db.getCollection(MSG_BROADCAST_COLLECTION);
                broadcastMsgCollection.createIndex((DBObject)new BasicDBObject("id", (Object)1).append("expire", (Object)1));
                DBCollection broadcastMsgRecpCollection = !this.db.collectionExists(MSG_BROADCAST_RECP_COLLECTION) ? this.db.createCollection(MSG_BROADCAST_RECP_COLLECTION, (DBObject)new BasicDBObject()) : this.db.getCollection(MSG_BROADCAST_RECP_COLLECTION);
                broadcastMsgRecpCollection.createIndex((DBObject)new BasicDBObject("msg_id", (Object)1));
                broadcastMsgRecpCollection.createIndex((DBObject)new BasicDBObject("msg_id", (Object)1).append("recipient_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            }
            super.initRepository(this.resourceUri, map);
        }
        catch (UnknownHostException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
        return this.loadMessagesToJID(session, delete, null);
    }

    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        return this.loadMessagesToJID(null, session, delete, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Element> loadMessagesToJID(List<String> db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        DBCursor cursor = null;
        Queue<Element> result = null;
        BareJID to = null;
        try {
            to = session.getBareJID();
            byte[] toHash = this.generateId(to);
            BasicDBObject crit = new BasicDBObject("to_hash", (Object)toHash).append("to", (Object)to.toString());
            cursor = this.db.getCollection(MSG_HISTORY_COLLECTION).find((DBObject)crit);
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            while (cursor.hasNext()) {
                DBObject it = cursor.next();
                if (it.containsField("expired-at") && ((Date)it.get("expired-at")).getTime() < System.currentTimeMillis()) continue;
                if (db_ids != null && db_ids.size() >= 0) {
                    String msgId;
                    if (!it.containsField("ts") || !db_ids.contains(msgId = dt.formatDateTime((Date)it.get("ts")))) continue;
                    list.add(it);
                    continue;
                }
                list.add(it);
            }
            Collections.sort(list, MSG_COMPARATOR);
            result = this.parseLoadedMessages(proc, list);
            if (delete) {
                this.db.getCollection(MSG_HISTORY_COLLECTION).remove((DBObject)crit, WriteConcern.UNACKNOWLEDGED);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
        try {
            MsgRepository.MSG_TYPES valueOf;
            byte[] fromHash = this.generateId(from.getBareJID());
            byte[] toHash = this.generateId(to.getBareJID());
            BasicDBObject crit = new BasicDBObject("from_hash", (Object)fromHash).append("to_hash", (Object)toHash).append("from", (Object)from.getBareJID().toString()).append("to", (Object)to.getBareJID().toString());
            long count = this.db.getCollection(MSG_HISTORY_COLLECTION).count((DBObject)crit);
            long msgs_store_limit = this.getMsgsStoreLimit(to.getBareJID(), userRepo);
            if (msgs_store_limit <= count) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Message store limit ({0}) exceeded for message: {1}", new Object[]{msgs_store_limit, Packet.elemToString((Element)msg)});
                }
                return false;
            }
            BasicDBObject dto = crit;
            if (expired != null) {
                dto = new BasicDBObject((Map)crit);
                dto.append("expire-at", (Object)expired);
                crit.append("expired-at", (Object)new BasicDBObject("$lt", (Object)new Date()));
            }
            dto.append("ts", (Object)new Date());
            try {
                String name = msg.getName();
                valueOf = MsgRepository.MSG_TYPES.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                valueOf = MsgRepository.MSG_TYPES.none;
            }
            dto.append("msg_type", (Object)valueOf.toString());
            dto.append("message", (Object)msg.toString());
            this.db.getCollection(MSG_HISTORY_COLLECTION).insert((DBObject)dto, WriteConcern.UNACKNOWLEDGED);
            if (expired != null) {
                if (expired.getTime() < this.earliestOffline) {
                    this.earliestOffline = expired.getTime();
                }
                if (this.expiredQueue.size() == 0) {
                    this.loadExpiredQueue(1);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", ex);
        }
        return true;
    }

    protected void deleteMessage(ObjectId dbId) {
        try {
            this.db.getCollection(MSG_HISTORY_COLLECTION).remove((DBObject)new BasicDBObject("_id", (Object)dbId));
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    protected void loadExpiredQueue(int max) {
        DBCursor cursor = null;
        try {
            cursor = this.db.getCollection(MSG_HISTORY_COLLECTION).find((DBObject)new BasicDBObject("ts", (Object)new BasicDBObject("$lt", (Object)new Date()))).sort((DBObject)new BasicDBObject("ts", (Object)1)).limit(max);
            DomBuilderHandler domHandler = new DomBuilderHandler();
            for (int counter = 0; cursor.hasNext() && counter < max; ++counter) {
                DBObject it = cursor.next();
                String msg_str = (String)it.get("message");
                this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
                Queue elems = domHandler.getParsedElements();
                Element msg = (Element)elems.poll();
                if (msg == null) {
                    log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                    continue;
                }
                Date ts = (Date)it.get("ts");
                MsgRepository.MsgDBItem item = new MsgRepository.MsgDBItem((MsgRepository)this, (Object)((ObjectId)it.get("_id")), msg, ts);
                this.expiredQueue.offer(item);
            }
        }
        catch (MongoException ex) {
            if (cursor != null) {
                cursor.close();
            }
            log.log(Level.WARNING, "Problem getting offline messages from db: ", ex);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    protected void loadExpiredQueue(Date expired) {
        DBCursor cursor = null;
        try {
            if (this.expiredQueue.size() > 100000) {
                this.expiredQueue.clear();
            }
            cursor = this.db.getCollection(MSG_HISTORY_COLLECTION).find((DBObject)new BasicDBObject("ts", (Object)new BasicDBObject("$lt", (Object)expired))).sort((DBObject)new BasicDBObject("ts", (Object)1));
            DomBuilderHandler domHandler = new DomBuilderHandler();
            int counter = 0;
            while (cursor.hasNext() && counter++ < 1000) {
                DBObject it = cursor.next();
                String msg_str = (String)it.get("message");
                this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
                Queue elems = domHandler.getParsedElements();
                Element msg = (Element)elems.poll();
                if (msg == null) {
                    log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                    continue;
                }
                Date ts = (Date)it.get("ts");
                MsgRepository.MsgDBItem item = new MsgRepository.MsgDBItem((MsgRepository)this, (Object)((ObjectId)it.get("_id")), msg, ts);
                this.expiredQueue.offer(item);
            }
        }
        catch (MongoException ex) {
            if (cursor != null) {
                cursor.close();
            }
            log.log(Level.WARNING, "Problem getting offline messages from db: ", ex);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    private byte[] generateId(BareJID user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.toString().getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    public void loadMessagesToBroadcast() {
        DBCursor cursor = null;
        try {
            HashSet oldMessages = new HashSet(this.broadcastMessages.keySet());
            cursor = this.db.getCollection(MSG_BROADCAST_COLLECTION).find((DBObject)new BasicDBObject("expire", (Object)new BasicDBObject("$gt", (Object)new Date())));
            DomBuilderHandler domHandler = new DomBuilderHandler();
            while (cursor.hasNext()) {
                DBObject dto = cursor.next();
                String id = (String)dto.get("_id");
                oldMessages.remove(id);
                if (this.broadcastMessages.containsKey(id)) continue;
                Date expire = (Date)dto.get("expire");
                char[] msgChars = ((String)dto.get("msg")).toCharArray();
                this.parser.parse((SimpleHandler)domHandler, msgChars, 0, msgChars.length);
                Queue elems = domHandler.getParsedElements();
                Element msg = (Element)elems.poll();
                if (msg == null) continue;
                this.broadcastMessages.put(id, new MsgRepository.BroadcastMsg((MsgRepository)this, null, msg, expire));
            }
            for (String key : oldMessages) {
                this.broadcastMessages.remove(key);
            }
        }
        catch (MongoException ex) {
            if (cursor != null) {
                cursor.close();
            }
            log.log(Level.WARNING, "Problem loading messages for broadcast from db: ", ex);
        }
    }

    protected void ensureBroadcastMessageRecipient(String id, BareJID recipient) {
        try {
            byte[] recipientId = this.generateId(recipient);
            BasicDBObject crit = new BasicDBObject("msg_id", (Object)id).append("recipient_id", (Object)recipientId).append("recipient", (Object)recipient.toString());
            this.db.getCollection(MSG_BROADCAST_RECP_COLLECTION).update((DBObject)crit, (DBObject)crit, true, false);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem inserting messages recipients for broadcast to db: ", ex);
        }
    }

    protected void insertBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
        try {
            this.db.getCollection(MSG_BROADCAST_COLLECTION).update((DBObject)new BasicDBObject("id", (Object)id), (DBObject)new BasicDBObject("$setOnInsert", (Object)new BasicDBObject("expire", (Object)expire).append("msg", (Object)msg.toString())), true, false);
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, "Problem inserting messages for broadcast to db: ", ex);
        }
    }

    private Queue<Element> parseLoadedMessages(MsgRepository.OfflineMessagesProcessor proc, List<DBObject> list) {
        StringBuilder sb = new StringBuilder(1000);
        Queue<Object> result = new LinkedList<Element>();
        if (proc != null) {
            for (DBObject it : list) {
                String msg = (String)it.get("message");
                String msgId = null;
                if (it.containsField("ts")) {
                    msgId = dt.formatDateTime((Date)it.get("ts"));
                }
                if (msg == null) continue;
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse((SimpleHandler)domHandler, msg.toCharArray(), 0, msg.length());
                Queue parsedElements = domHandler.getParsedElements();
                Element msgEl = (Element)parsedElements.poll();
                if (msgEl == null || msgId == null) continue;
                proc.stamp(msgEl, msgId);
                result.add(msgEl);
            }
        } else {
            result = new LinkedList();
            for (DBObject it : list) {
                sb.append(it.get("message"));
            }
            if (sb.length() > 0) {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse((SimpleHandler)domHandler, sb.toString().toCharArray(), 0, sb.length());
                result = domHandler.getParsedElements();
            }
        }
        return result;
    }
}

