/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import tigase.http.jetty.AbstractJettyHttpServer;
import tigase.io.TLSUtil;
import tigase.net.SocketType;

public class JettyStandaloneHttpServer
extends AbstractJettyHttpServer {
    private static final Logger log = Logger.getLogger(JettyStandaloneHttpServer.class.getCanonicalName());
    private Server server = null;
    private int[] ports = new int[]{8080};
    private final Map<String, Map<String, Object>> portsConfigs = new HashMap<String, Map<String, Object>>();
    private final ContextHandlerCollection contexts = new ContextHandlerCollection();

    @Override
    protected void deploy(ServletContextHandler ctx) {
        this.contexts.addHandler((Handler)ctx);
        try {
            ctx.start();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception deploying http context " + ctx.getContextPath(), ex);
        }
    }

    @Override
    protected void undeploy(ServletContextHandler ctx) {
        this.contexts.removeHandler((Handler)ctx);
        try {
            ctx.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception undeploying http context " + ctx.getContextPath(), ex);
        }
    }

    public void start() {
        if (this.server != null && (this.server.isStarted() || this.server.isStarting())) {
            this.stop();
        }
        if (this.server == null) {
            this.server = new Server();
            int[] nArray = this.ports;
            int n = this.ports.length;
            int n2 = 0;
            while (n2 < n) {
                int port = nArray[n2];
                Map<String, Object> config = this.portsConfigs.get(String.valueOf(port));
                if (config == null) {
                    config = new HashMap<String, Object>();
                }
                ServerConnector connector = null;
                if ((SocketType)config.getOrDefault("socket", SocketType.plain) == SocketType.plain) {
                    connector = new ServerConnector(this.server);
                } else {
                    String domain = (String)config.get("domain");
                    SSLContext context = TLSUtil.getSSLContext((String)"TLS", (String)domain);
                    SslContextFactory contextFactory = new SslContextFactory();
                    contextFactory.setSslContext(context);
                    connector = new ServerConnector(this.server, contextFactory);
                }
                connector.setPort(port);
                this.server.addConnector((Connector)connector);
                ++n2;
            }
        }
        this.server.setHandler((Handler)this.contexts);
        try {
            this.server.start();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception starting internal HTTP server", ex);
        }
    }

    public void stop() {
        if (this.server == null || !this.server.isStarted() && !this.server.isStarting()) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception stopping internal HTTP server", ex);
        }
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("port")) {
            this.ports = new int[]{(Integer)props.get("port")};
        }
        if (props.containsKey("ports")) {
            this.ports = (int[])props.get("ports");
        }
        this.portsConfigs.clear();
        int[] nArray = this.ports;
        int n = this.ports.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            HashMap<String, Object> config = new HashMap<String, Object>();
            String socket = (String)props.get(String.valueOf(String.valueOf(port)) + "/" + "socket");
            config.put("socket", socket != null ? SocketType.valueOf((String)socket) : SocketType.plain);
            String domain = (String)props.get(String.valueOf(String.valueOf(port)) + "/" + "domain");
            config.put("domain", domain);
            this.portsConfigs.put(String.valueOf(port), config);
            ++n2;
        }
    }
}

