/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.db.JDBCUnifiedArchiveRepository;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.JDBCMsgRepository;
import tigase.server.amp.MsgRepository;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class JDBCFlexibleOfflineMessageRetrievalRepository
extends JDBCMsgRepository {
    private static final Logger a = Logger.getLogger(JDBCFlexibleOfflineMessageRetrievalRepository.class.getCanonicalName());
    private static final String b = "select item_type, count(msg_id) from tig_ma_msgs m inner join tig_ma_jids j on j.jid_id = m.owner_id where m.offline = 1 and j.jid = ?  group by item_type";
    private static final String c = "select s.jid, m.buddy_res, m.msg_id, m.item_type from tig_ma_msgs m inner join tig_ma_jids j on j.jid_id = m.owner_id inner join tig_ma_jids s on s.jid_id = m.buddy_id where m.offline = 1 and j.jid = ? ";
    private static final String d = "select msg as message, msg_id as msg_id from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id where o.jid = ? and m.offline = 1";
    private static final String e = "delete from tig_ma_msgs  where owner_id = (select j.jid_id from tig_ma_jids j where j.jid = ? ) and offline = 1";
    private static final String f = "update tig_ma_msgs set offline = 0 where owner_id = (select j.jid_id from tig_ma_jids j where j.jid = ? ) and offline = 1";
    private final SimpleDateFormat g;
    private JDBCUnifiedArchiveRepository h = new JDBCUnifiedArchiveRepository();
    private int i = 3;

    public JDBCFlexibleOfflineMessageRetrievalRepository() {
        this.g = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.g.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void initRepository(String conn_str, Map<String, String> map) throws DBInitException {
        super.initRepository(conn_str, map);
        map.put("offline-store", "true");
        map.put("ignoreStatementInitialization", "true");
        this.h.initRepository(conn_str, map);
        DataRepository dataRepository = this.h.getDataRepository();
        try {
            this.initRepository(dataRepository);
        }
        catch (SQLException sQLException) {
            throw new DBInitException("could not initialize repository", (Throwable)sQLException);
        }
    }

    protected void initRepository(DataRepository data_repo) throws SQLException {
        int n;
        StringBuilder stringBuilder;
        int n2;
        data_repo.initPreparedStatement(b, b);
        data_repo.initPreparedStatement(c, c);
        data_repo.initPreparedStatement(d, d);
        for (n2 = 1; n2 <= this.i; ++n2) {
            stringBuilder = new StringBuilder(d);
            stringBuilder.append(" and m.").append("msg_id").append(" in (");
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
            data_repo.initPreparedStatement(d + n2, stringBuilder.toString());
        }
        data_repo.initPreparedStatement(e, e);
        for (n2 = 1; n2 <= this.i; ++n2) {
            stringBuilder = new StringBuilder(e);
            stringBuilder.append(" and ").append("msg_id").append(" in (");
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
            data_repo.initPreparedStatement(e + n2, stringBuilder.toString());
        }
        data_repo.initPreparedStatement(f, f);
        for (n2 = 1; n2 <= this.i; ++n2) {
            stringBuilder = new StringBuilder(f);
            stringBuilder.append(" and ").append("msg_id").append(" in (");
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
            data_repo.initPreparedStatement(f + n2, stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Enum, Long> getMessagesCount(JID to) {
        DataRepository dataRepository = this.h.getDataRepository();
        try {
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = dataRepository.getPreparedStatement(to.getBareJID(), b);
            HashMap<Enum, Long> hashMap = new HashMap<Enum, Long>();
            PreparedStatement preparedStatement2 = preparedStatement;
            synchronized (preparedStatement2) {
                try {
                    preparedStatement.setString(1, to.getBareJID().toString().toLowerCase());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        Long l = resultSet.getLong(2);
                        hashMap.put(MSG_TYPES.getFromString(string), l);
                    }
                }
                catch (Throwable throwable) {
                    dataRepository.release(null, resultSet);
                    throw throwable;
                }
                dataRepository.release(null, resultSet);
            }
            return hashMap;
        }
        catch (SQLException sQLException) {
            a.log(Level.SEVERE, "could not retrieve count of messages for user " + to, sQLException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> getMessagesList(JID to) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        DataRepository dataRepository = this.h.getDataRepository();
        try {
            PreparedStatement preparedStatement;
            ResultSet resultSet = null;
            PreparedStatement preparedStatement2 = preparedStatement = dataRepository.getPreparedStatement(to.getBareJID(), c);
            synchronized (preparedStatement2) {
                try {
                    preparedStatement.setString(1, to.getBareJID().toString().toLowerCase());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        Long l = resultSet.getLong(3);
                        MSG_TYPES mSG_TYPES = MSG_TYPES.getFromString(resultSet.getString(4));
                        if (l == 0L || mSG_TYPES == MSG_TYPES.none || string == null) continue;
                        Element element = new Element("item", new String[]{"jid", "node", "type", "name"}, new String[]{to.getBareJID().toString(), String.valueOf(l), mSG_TYPES.name(), string2 != null ? string + "/" + string2 : string});
                        linkedList.add(element);
                    }
                }
                catch (Throwable throwable) {
                    dataRepository.release(null, resultSet);
                    throw throwable;
                }
                dataRepository.release(null, resultSet);
            }
        }
        catch (SQLException sQLException) {
            a.log(Level.SEVERE, "could not retrieve count of messages for user " + to, sQLException);
        }
        return linkedList;
    }

    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        return this.loadMessagesToJID(null, session, delete, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Element> loadMessagesToJID(List<String> db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        DataRepository dataRepository = this.h.getDataRepository();
        LinkedList linkedList = null;
        BareJID bareJID = null;
        try {
            boolean bl;
            ResultSet resultSet = null;
            bareJID = session.getBareJID();
            boolean bl2 = bl = db_ids == null || db_ids.size() == 0;
            if (db_ids == null) {
                db_ids = Collections.emptyList();
            }
            linkedList = new LinkedList();
            Iterator<String> iterator = db_ids.iterator();
            int n = db_ids.size() / this.i + 1;
            for (int i = 0; i < n; ++i) {
                PreparedStatement preparedStatement;
                int n2;
                int n3 = n2 = i == n - 1 ? db_ids.size() % this.i : this.i;
                if (n2 == 0 && !bl) continue;
                PreparedStatement preparedStatement2 = preparedStatement = dataRepository.getPreparedStatement(bareJID, n2 == 0 ? d : d + n2);
                synchronized (preparedStatement2) {
                    try {
                        preparedStatement.setString(1, bareJID.toString().toLowerCase());
                        for (int j = 0; j < n2; ++j) {
                            String string = iterator.next();
                            long l = Long.parseLong(string);
                            preparedStatement.setLong(j + 2, l);
                        }
                        resultSet = preparedStatement.executeQuery();
                        linkedList.addAll(this.parseLoadedMessages(proc, resultSet));
                        resultSet = null;
                    }
                    catch (Throwable throwable) {
                        dataRepository.release(null, resultSet);
                        throw throwable;
                    }
                    dataRepository.release(null, resultSet);
                    continue;
                }
            }
            if (delete) {
                this.deleteMessagesToJID(null, session);
            }
        }
        catch (SQLException sQLException) {
            a.log(Level.WARNING, "Problem getting offline messages for user: " + bareJID, sQLException);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.WARNING, "Session not authorized yet!", notAuthorizedException);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteMessagesToJID(List<String> db_ids, XMPPResourceConnection session) throws UserNotFoundException {
        DataRepository dataRepository = this.h.getDataRepository();
        int n = 0;
        BareJID bareJID = null;
        try {
            boolean bl;
            bareJID = session.getBareJID();
            boolean bl2 = this.a(session);
            String string = bl2 ? f : e;
            boolean bl3 = bl = db_ids == null || db_ids.size() == 0;
            if (db_ids == null) {
                db_ids = Collections.emptyList();
            }
            Iterator<String> iterator = db_ids.iterator();
            int n2 = db_ids.size() / this.i + 1;
            for (int i = 0; i < n2; ++i) {
                PreparedStatement preparedStatement;
                int n3;
                int n4 = n3 = i == n2 - 1 ? db_ids.size() % this.i : this.i;
                if (n3 == 0 && !bl) continue;
                PreparedStatement preparedStatement2 = preparedStatement = dataRepository.getPreparedStatement(bareJID, n3 == 0 ? string : string + n3);
                synchronized (preparedStatement2) {
                    preparedStatement.setString(1, bareJID.toString().toLowerCase());
                    for (int j = 0; j < n3; ++j) {
                        String string2 = iterator.next();
                        long l = Long.parseLong(string2);
                        preparedStatement.setLong(j + 2, l);
                    }
                    n += preparedStatement.executeUpdate();
                    continue;
                }
            }
        }
        catch (SQLException sQLException) {
            a.log(Level.WARNING, "Problem getting offline messages for user: " + bareJID, sQLException);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.WARNING, "Session not authorized yet!", notAuthorizedException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
        Object object;
        long l = this.getMsgsStoreLimit(to.getBareJID(), userRepo);
        if (l != 0L && (object = this.getMessagesCount(to)) != null && object.containsKey((Object)MSG_TYPES.message) && (Long)object.get((Object)MSG_TYPES.message) >= l) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Message store limit ({0}) exceeded for message: {1}", new Object[]{l, Packet.elemToString((Element)msg)});
            }
            return false;
        }
        msg.addAttribute("tigase-offline", "true");
        object = msg.getChildAttributeStaticStr("delay", "stamp");
        Date date = null;
        if (object != null) {
            SimpleDateFormat simpleDateFormat = this.g;
            synchronized (simpleDateFormat) {
                try {
                    date = this.g.parse((String)object);
                }
                catch (ParseException parseException) {
                    a.log(Level.FINEST, "Failed to parse delay stamp = " + (String)object);
                }
            }
        }
        if (date == null) {
            date = new Date();
        }
        this.h.archiveMessage(to.getBareJID(), from, MessageArchiveRepository.Direction.incoming, date, msg, null);
        return true;
    }

    private boolean a(XMPPResourceConnection xMPPResourceConnection) {
        try {
            return Settings.getAutoSave((XMPPResourceConnection)xMPPResourceConnection, (StoreMethod)StoreMethod.False);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            return false;
        }
    }

    public static enum MSG_TYPES {
        none(null),
        message("chat"),
        presence("presence"),
        jingle("jingle"),
        call("call"),
        login("login"),
        logout("logout");

        private final String a;

        private MSG_TYPES(String value) {
            this.a = value;
        }

        public String getValue() {
            return this.a;
        }

        public static MSG_TYPES getFromString(String type) {
            if (type == null) {
                return none;
            }
            switch (type) {
                case "chat": {
                    return message;
                }
                case "presence": {
                    return presence;
                }
                case "call": {
                    return call;
                }
                case "jingle": {
                    return jingle;
                }
            }
            return none;
        }
    }
}

