/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.muc.Room;
import tigase.muc.cluster.AbstractStrategy;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.StrategyIfc;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ShardingStrategy
extends AbstractStrategy
implements Room.RoomOccupantListener,
InMemoryMucRepositoryClustered.RoomListener,
StrategyIfc {
    private static final Logger a = Logger.getLogger(ShardingStrategy.class.getCanonicalName());
    private static final String b = "muc-node-shutdown-cmd";
    private static final String c = "muc-sync-response";
    private static final String d = "muc-room-created-cmd";
    private static final String e = "muc-room-destroyed-cmd";
    private static final String f = "muc-room-left-cmd";
    private static final int g = 1000;
    private final a h = new a();
    private final b i = new b();
    private final c j = new c();
    private final d k = new d();
    private final e l = new e();
    private final f m = new f();
    private final ConcurrentMap<BareJID, JID> n = new ConcurrentHashMap<BareJID, JID>();
    private final ConcurrentMap<BareJID, Set<JID>> o = new ConcurrentHashMap<BareJID, Set<JID>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDisconnected(JID nodeJid) {
        List<JID> list = this.getNodesConnectedWithLocal();
        int n = list.indexOf(this.localNodeJid);
        Iterator iterator = this.n.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!nodeJid.equals(entry.getValue())) continue;
            iterator.remove();
            BareJID bareJID = (BareJID)entry.getKey();
            Set set = (Set)this.o.remove(bareJID);
            if (bareJID.hashCode() % list.size() != n || set == null) continue;
            Set set2 = set;
            synchronized (set2) {
                for (JID jID : set) {
                    this.sendRemovalFromRoomOnNodeDisconnect(bareJID, jID);
                }
            }
        }
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.k);
            this.cl_controller.removeCommandListener((CommandListener)this.l);
            this.cl_controller.removeCommandListener((CommandListener)this.m);
            this.cl_controller.removeCommandListener((CommandListener)this.i);
            this.cl_controller.removeCommandListener((CommandListener)this.j);
            this.cl_controller.removeCommandListener((CommandListener)this.h);
        }
        super.setClusterController(cl_controller);
        this.cl_controller.setCommandListener((CommandListener)this.k);
        this.cl_controller.setCommandListener((CommandListener)this.l);
        this.cl_controller.setCommandListener((CommandListener)this.m);
        this.cl_controller.setCommandListener((CommandListener)this.i);
        this.cl_controller.setCommandListener((CommandListener)this.j);
        this.cl_controller.setCommandListener((CommandListener)this.h);
    }

    @Override
    public boolean processPacket(Packet packet) {
        BareJID bareJID = packet.getStanzaTo().getBareJID();
        JID jID = this.getNodeForRoom(bareJID);
        if (this.localNodeJid.equals((Object)jID)) {
            return false;
        }
        if (a.isLoggable(Level.FINER)) {
            a.log(Level.FINER, "room = {0}, forwarding packet to node = {1}", new Object[]{bareJID, jID});
        }
        this.forwardPacketToNode(jID, packet);
        return true;
    }

    protected JID getNodeForRoom(BareJID roomJid) {
        JID jID = (JID)this.n.get(roomJid);
        if (jID == null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, not created on any node", roomJid);
            }
            int n = roomJid.hashCode();
            List<JID> list = this.getNodesConnectedWithLocal();
            jID = list.get(Math.abs(n) % list.size());
            if (a.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (JID jID2 : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(jID2.toString());
                }
                a.log(Level.FINEST, "room = {0}, selected node = {1} to handle this room by hash = {2} from {3}", new Object[]{roomJid, jID, n, stringBuilder});
            }
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "room = {0}, selected node = {1} to handle this room", new Object[]{roomJid, jID});
        }
        return jID;
    }

    @Override
    public void setMucRepository(InMemoryMucRepositoryClustered mucRepository) {
        super.setMucRepository(mucRepository);
        mucRepository.setRoomListener(this);
        mucRepository.setRoomOccupantListener(this);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        List<JID> list = this.getNodesConnected();
        this.cl_controller.sendToNodes(b, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onLeaveRoom(Room room) {
        this.n.remove(room.getRoomJID());
        this.o.remove(room.getRoomJID());
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is left", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(f, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomCreated(Room room) {
        this.n.put(room.getRoomJID(), this.localNodeJid);
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is created", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(d, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomDestroyed(Room room, Element destroyElement) {
        this.n.remove(room.getRoomJID());
        Set set = (Set)this.o.remove(room.getRoomJID());
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is destroyed", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(e, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    public void onOccupantChangedPresence(Room room, JID occupantJid, String nickname, Element presence, boolean newOccupant) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addOccupant(BareJID node, BareJID roomJid, JID occupantJid, String nickname) {
        Set<Object> set;
        HashSet<JID> hashSet = (HashSet<JID>)this.o.get(roomJid);
        if (hashSet == null && (set = (Set)this.o.putIfAbsent(roomJid, hashSet = new HashSet<JID>())) != null) {
            hashSet = set;
        }
        set = hashSet;
        synchronized (set) {
            return hashSet.add(occupantJid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeOccupant(BareJID node, BareJID roomJid, JID occupantJid) {
        Set set = (Set)this.o.get(roomJid);
        if (set == null) {
            return false;
        }
        Set set2 = set;
        synchronized (set2) {
            return set.remove(occupantJid);
        }
    }

    private class c
    extends CommandListenerAbstract {
        public c() {
            super(ShardingStrategy.c, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                for (Element element : packets) {
                    List list;
                    if (element.getName() != "room") continue;
                    BareJID bareJID = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("jid"));
                    JID jID = ShardingStrategy.this.n.put(bareJID, fromNode);
                    if (jID != null && !fromNode.equals((Object)jID)) {
                        a.log(Level.SEVERE, "received info about a room {0} on {1} but we had info about this room on node {2}", new Object[]{bareJID, fromNode, jID});
                    }
                    if ((list = element.getChildren()) == null || list.isEmpty()) continue;
                    for (Element element2 : list) {
                        JID jID2 = JID.jidInstanceNS((String)element2.getCData());
                        String string = element2.getAttributeStaticStr("nickname");
                        ShardingStrategy.this.addOccupant(fromNode.getBareJID(), bareJID, jID2, string);
                    }
                }
            }
        }
    }

    private class b
    extends CommandListenerAbstract {
        public b() {
            super("muc-sync-request", Priority.HIGH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            LinkedList<Element> linkedList = new LinkedList<Element>();
            for (Map.Entry entry : ShardingStrategy.this.n.entrySet()) {
                Element element;
                block8: {
                    if (!ShardingStrategy.this.localNodeJid.equals(entry.getValue())) continue;
                    element = new Element("room", new String[]{"jid"}, new String[]{((BareJID)entry.getKey()).toString()});
                    try {
                        Room room = ShardingStrategy.this.mucRepository.getRoom((BareJID)entry.getKey());
                        Set set = (Set)ShardingStrategy.this.o.get(entry.getKey());
                        if (set == null || set.isEmpty()) break block8;
                        Set set2 = set;
                        synchronized (set2) {
                            for (JID jID : set) {
                                String string = room.getOccupantsNickname(jID);
                                if (string == null) continue;
                                Element element2 = new Element("occupant", jID.toString());
                                element2.addAttribute("nickname", string);
                                element.addChild((XMLNodeIfc)element2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "exception during cluster nodes synchronization", exception);
                    }
                }
                linkedList.add(element);
                if (linkedList.size() <= 1000) continue;
                ShardingStrategy.this.cl_controller.sendToNodes(ShardingStrategy.c, linkedList, ShardingStrategy.this.localNodeJid, null, new JID[]{fromNode});
                linkedList = new LinkedList();
            }
            if (!linkedList.isEmpty()) {
                ShardingStrategy.this.cl_controller.sendToNodes(ShardingStrategy.c, linkedList, ShardingStrategy.this.localNodeJid, null, new JID[]{fromNode});
            }
        }
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(ShardingStrategy.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            Iterator iterator = ShardingStrategy.this.n.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!fromNode.equals(entry.getValue())) continue;
                iterator.remove();
                ShardingStrategy.this.o.remove(entry.getKey());
            }
        }
    }

    private class f
    extends CommandListenerAbstract {
        public f() {
            super(ShardingStrategy.f, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            ShardingStrategy.this.n.remove(bareJID, fromNode);
            ShardingStrategy.this.o.remove(bareJID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was left at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    private class e
    extends CommandListenerAbstract {
        public e() {
            super(ShardingStrategy.e, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            ShardingStrategy.this.n.remove(bareJID, fromNode);
            ShardingStrategy.this.o.remove(bareJID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was destroyed at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    private class d
    extends CommandListenerAbstract {
        public d() {
            super(ShardingStrategy.d, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            ShardingStrategy.this.n.put(bareJID, fromNode);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was created at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }
}

