/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.MsgRepository;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.OfflineMessages;

public class MessageAmp
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPPostprocessorIfc,
XMPPPreprocessorIfc,
XMPPProcessorIfc {
    private static final String AMP_JID_PROP_KEY = "amp-jid";
    private static final String STATUS_ATTRIBUTE_NAME = "status";
    private static final String[][] ELEMENTS = new String[][]{{"message"}, {"presence"}};
    private static final String ID = "amp";
    private static final Logger log = Logger.getLogger(MessageAmp.class.getName());
    private static final String XMLNS = "http://jabber.org/protocol/amp";
    private static final String[] XMLNSS = new String[]{"jabber:client", "jabber:client"};
    private static Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp"}), new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private static final String defHost = DNSResolver.getDefaultHostname();
    private JID ampJID = null;
    private MsgRepositoryIfc msg_repo = null;
    private OfflineMessages offlineProcessor = new OfflineMessages();
    private Message messageProcessor = new Message();

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        String ampJIDstr = (String)settings.get(AMP_JID_PROP_KEY);
        this.ampJID = null != ampJIDstr ? JID.jidInstanceNS(ampJIDstr) : JID.jidInstanceNS("amp@" + defHost);
        log.log(Level.CONFIG, "Loaded AMP_JID option: {0} = {1}", new Object[]{AMP_JID_PROP_KEY, this.ampJID});
        String off_val = (String)settings.get("msg-offline");
        if (off_val == null) {
            off_val = System.getProperty("msg-offline");
        }
        if (off_val != null && !Boolean.parseBoolean(off_val)) {
            log.log(Level.CONFIG, "Offline messages storage: {0}", new Object[]{off_val});
            this.offlineProcessor = null;
            DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{XMLNS})};
        }
        String msg_repo_uri = (String)settings.get("amp-repo-uri");
        String msg_repo_cls = (String)settings.get("amp-repo-class");
        if (msg_repo_uri == null && (msg_repo_uri = System.getProperty("amp-repo-uri")) == null) {
            msg_repo_uri = System.getProperty("user-db-uri");
        }
        if (msg_repo_cls == null) {
            msg_repo_cls = System.getProperty("amp-repo-class");
        }
        if (msg_repo_uri != null) {
            HashMap<String, String> db_props = new HashMap<String, String>(4);
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                db_props.put(entry.getKey(), entry.getValue().toString());
            }
            try {
                this.msg_repo = MsgRepository.getInstance(msg_repo_cls, msg_repo_uri);
                this.msg_repo.initRepository(msg_repo_uri, db_props);
            }
            catch (TigaseDBException ex) {
                this.msg_repo = null;
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        C2SDeliveryErrorProcessor.filter(packet, session, repo, results, this.ampJID);
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        block5: {
            if (!(this.offlineProcessor == null || session != null && this.messageProcessor.hasConnectionForMessageDelivery(session))) {
                if (packet.getElemName() == "message" && packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
                    return;
                }
                Element amp = packet.getElement().getChild(ID);
                if (amp == null || amp.getXMLNS() != XMLNS || amp.getAttributeStaticStr(STATUS_ATTRIBUTE_NAME) != null) {
                    try {
                        this.offlineProcessor.savePacketForOffLineUser(packet, this.msg_repo);
                    }
                    catch (UserNotFoundException ex) {
                        if (!log.isLoggable(Level.FINEST)) break block5;
                        log.finest("UserNotFoundException at trying to save packet for off-line user." + packet);
                    }
                }
            }
        }
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        boolean processed = C2SDeliveryErrorProcessor.preProcess(packet, session, repo, results, settings);
        if (processed && packet.getPacketFrom() != null && packet.getPacketFrom().getLocalpart().equals(this.ampJID.getLocalpart())) {
            processed = false;
        }
        if (processed) {
            packet.processedBy(ID);
        } else if (packet.getElemName() == "message") {
            Element amp = packet.getElement().getChild(ID, XMLNS);
            if (amp == null || amp.getAttributeStaticStr(STATUS_ATTRIBUTE_NAME) != null || this.ampJID.equals(packet.getPacketFrom())) {
                return false;
            }
            try {
                if (session == null) {
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(this.ampJID);
                    results.offer(result);
                    result.getElement().addAttribute("offline", "1");
                    packet.processedBy(ID);
                    return true;
                }
                if (session.isUserId(packet.getStanzaTo().getBareJID()) && session.getjid() != null && session.getjid().equals(packet.getStanzaTo())) {
                    boolean offline;
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(this.ampJID);
                    if (packet.getStanzaTo().getResource() != null) {
                        result.getElement().addAttribute("to-res", session.getResource());
                    }
                    results.offer(result);
                    boolean bl = offline = !this.messageProcessor.hasConnectionForMessageDelivery(session);
                    if (offline) {
                        result.getElement().addAttribute("offline", "1");
                    }
                    packet.processedBy(ID);
                    return true;
                }
                return false;
            }
            catch (XMPPException ex) {
                log.log(Level.SEVERE, "this should not happen", ex);
            }
        }
        return processed;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (packet.getElemName() == "presence") {
            if (this.offlineProcessor != null && this.offlineProcessor.loadOfflineMessages(packet, session)) {
                try {
                    Queue<Packet> packets = this.offlineProcessor.restorePacketForOffLineUser(session, this.msg_repo);
                    if (packets != null) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Sending off-line messages: " + packets.size());
                        }
                        results.addAll(packets);
                    }
                }
                catch (UserNotFoundException e) {
                    log.info("Something wrong, DB problem, cannot load offline messages. " + e);
                }
                if (packet.getStanzaTo() == null) {
                    Packet notification = packet.copyElementOnly();
                    notification.initVars(session.getJID(), this.ampJID);
                    results.offer(notification);
                }
            }
        } else {
            Element amp = packet.getElement().getChild(ID, XMLNS);
            if (amp == null || amp.getAttributeStaticStr(STATUS_ATTRIBUTE_NAME) != null || packet.getPacketFrom() != null && this.ampJID.getLocalpart().equals(packet.getPacketFrom().getLocalpart())) {
                this.messageProcessor.process(packet, session, repo, results, settings);
            } else {
                JID connectionId = session.getConnectionId();
                Packet result = packet.copyElementOnly();
                if (connectionId.equals(packet.getPacketFrom())) {
                    result.getElement().addAttribute("from-conn-id", connectionId.toString());
                }
                result.setPacketTo(this.ampJID);
                results.offer(result);
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

