/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class SeeOtherHost
implements SeeOtherHostIfc {
    private static final Logger log = Logger.getLogger(SeeOtherHost.class.getName());
    protected List<BareJID> defaultHost = null;
    private ArrayList<SeeOtherHostIfc.Phase> active = new ArrayList();

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        if (this.defaultHost != null && !this.defaultHost.isEmpty()) {
            return this.defaultHost.get(0);
        }
        return host;
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("cm-see-other-host/active")) {
            String[] phase;
            String[] stringArray = phase = ((String)props.get("cm-see-other-host/active")).split(";");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String ph = stringArray[i];
                try {
                    this.active.add(SeeOtherHostIfc.Phase.valueOf(ph));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.log(Level.FINEST, "unsupported phase configuration item: " + ph + e);
                }
            }
        } else {
            this.active.add(SeeOtherHostIfc.Phase.OPEN);
        }
        log.log(Level.CONFIG, props.get("component-id") + " :: see-other-redirect active in: " + Arrays.asList(this.active));
        if (props.containsKey("cm-see-other-host/default-host") && !props.get("cm-see-other-host/default-host").toString().trim().isEmpty()) {
            this.defaultHost = new ArrayList<BareJID>();
            for (String host : ((String)props.get("cm-see-other-host/default-host")).split(",")) {
                try {
                    this.defaultHost.add(BareJID.bareJIDInstance(host));
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.CONFIG, "From JID violates RFC6122 (XMPP:Address Format): ", ex);
                }
            }
            Collections.sort(this.defaultHost);
        } else {
            this.defaultHost = null;
        }
    }

    @Override
    public void setNodes(List<BareJID> nodes) {
        log.log(Level.CONFIG, "Action invalid for current implementation.");
    }

    @Override
    public Element getStreamError(String xmlns, BareJID destination) {
        Element error = new Element("stream:error");
        Element seeOtherHost = new Element("see-other-host", destination.toString());
        seeOtherHost.setXMLNS(xmlns);
        error.addChild(seeOtherHost);
        return error;
    }

    @Override
    public boolean isEnabled(SeeOtherHostIfc.Phase ph) {
        return this.active.contains((Object)ph);
    }
}

