/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Collection;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.component.AbstractEventBusModule;
import tigase.disteventbus.component.EventBusContext;
import tigase.disteventbus.component.NodeNameUtil;
import tigase.disteventbus.component.stores.Subscription;
import tigase.disteventbus.impl.LocalEventBus;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class EventPublisherModule
extends AbstractEventBusModule {
    public static final String ID = "publisher";
    private final LocalEventBus.LocalEventBusListener eventBusListener = new LocalEventBus.LocalEventBusListener(){

        @Override
        public void onAddHandler(String name, String xmlns, EventHandler handler) {
        }

        @Override
        public void onFire(String name, String xmlns, Element event) {
            EventPublisherModule.this.publishEvent(name, xmlns, event);
        }

        @Override
        public void onRemoveHandler(String name, String xmlns, EventHandler handler) {
        }
    };

    @Override
    public void afterRegistration() {
        super.afterRegistration();
        ((EventBusContext)this.context).getEventBusInstance().addListener(this.eventBusListener);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return null;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
    }

    public void publishEvent(Element event) {
        this.publishEvent(event.getName(), event.getXMLNS(), event);
    }

    private void publishEvent(Element pubsubEventElem, String from, JID toJID) throws TigaseStringprepException {
        Packet message = Packet.packetInstance(new Element("message", new String[]{"to", "from", "id"}, new String[]{toJID.toString(), from, this.nextStanzaID()}));
        message.getElement().addChild(pubsubEventElem);
        message.setXMLNS("jabber:client");
        message.setPermissions(Permissions.ADMIN);
        this.write(message);
    }

    public void publishEvent(String name, String xmlns, Element event) {
        Collection<Subscription> subscribers = ((EventBusContext)this.context).getSubscriptionStore().getSubscribersJIDs(name, xmlns);
        this.publishEvent(name, xmlns, event, subscribers);
    }

    public void publishEvent(String name, String xmlns, Element event, Collection<Subscription> subscribers) {
        try {
            Element eventElem = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
            Element itemsElem = new Element("items", new String[]{"node"}, new String[]{NodeNameUtil.createNodeName(name, xmlns)});
            eventElem.addChild(itemsElem);
            Element itemElem = new Element("item");
            itemElem.addChild(event);
            itemsElem.addChild(itemElem);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Sending event (" + name + ", " + xmlns + ") to " + subscribers);
            }
            for (Subscription subscriber : subscribers) {
                String from = subscriber.getServiceJID() == null ? ((EventBusContext)this.context).getComponentID().toString() : subscriber.getServiceJID().toString();
                JID toJID = subscriber.getJid();
                this.publishEvent(eventElem, from, toJID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregisterModule() {
        ((EventBusContext)this.context).getEventBusInstance().removeListener(this.eventBusListener);
        super.unregisterModule();
    }
}

