/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.script.ScriptEngineManager;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.component.AbstractComponent;
import tigase.component.AbstractContext;
import tigase.component.modules.Module;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.DiscoveryModule;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.conf.ConfigurationException;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.component.AddListenerScriptCommand;
import tigase.disteventbus.component.EventBusContext;
import tigase.disteventbus.component.EventPublisherModule;
import tigase.disteventbus.component.EventReceiverModule;
import tigase.disteventbus.component.ListenerScript;
import tigase.disteventbus.component.ListenerScriptRegistrar;
import tigase.disteventbus.component.RemoveListenerScriptCommand;
import tigase.disteventbus.component.SubscribeModule;
import tigase.disteventbus.component.UnsubscribeModule;
import tigase.disteventbus.component.stores.AffiliationStore;
import tigase.disteventbus.component.stores.SubscriptionStore;
import tigase.disteventbus.impl.LocalEventBus;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xml.Element;

public class EventBusComponent
extends AbstractComponent<EventBusContext>
implements ClusteredComponentIfc {
    public static final String COMPONENT_EVENTS_XMLNS = "tigase:eventbus";
    private static long counter = 0L;
    private final AffiliationStore affiliationStore = new AffiliationStore();
    private final Set<String> connectedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, ListenerScript> listenersScripts = new ConcurrentHashMap<String, ListenerScript>();
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ListenerScriptRegistrar scriptsRegistrar;
    private final SubscriptionStore subscriptionStore = new SubscriptionStore();

    @Override
    protected EventBusContext createContext() {
        return new EventBusContextImpl(this);
    }

    @Override
    public synchronized void everySecond() {
        super.everySecond();
        Element event = new Element("CurrentTime", new String[]{"xmlns"}, new String[]{"tigase:events"});
        event.addChild(new Element("time", new Date().toString()));
        ((EventBusContext)this.context).getEventBus().fire(event);
    }

    @Override
    public String getComponentVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    @Override
    protected Map<String, Class<? extends Module>> getDefaultModulesList() {
        HashMap<String, Class<? extends Module>> result = new HashMap<String, Class<? extends Module>>();
        result.put("subscribe", SubscribeModule.class);
        result.put("unsubscribe", UnsubscribeModule.class);
        result.put("receiver", EventReceiverModule.class);
        result.put("publisher", EventPublisherModule.class);
        result.put("urn:xmpp:ping", XmppPingModule.class);
        result.put("jabber:iq:version", JabberVersionModule.class);
        result.put("commands", AdHocCommandModule.class);
        result.put("disco", DiscoveryModule.class);
        return result;
    }

    @Override
    public String getDiscoCategory() {
        return "component";
    }

    @Override
    public String getDiscoCategoryType() {
        return "generic";
    }

    @Override
    public String getDiscoDescription() {
        return "Distributed EventBus";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Known cluster nodes", this.connectedNodes.size(), Level.INFO);
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return false;
    }

    @Override
    public boolean isSubdomain() {
        return false;
    }

    @Override
    public void nodeConnected(String node) {
        Object module;
        this.connectedNodes.add(node);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Node added. Known nodes: " + this.connectedNodes);
        }
        if ((module = this.modulesManager.getModule("subscribe")) != null && module instanceof SubscribeModule) {
            ((SubscribeModule)module).clusterNodeConnected(node);
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        Object module;
        this.connectedNodes.remove(node);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Node removed. Known nodes: " + this.connectedNodes);
        }
        if ((module = this.modulesManager.getModule("subscribe")) != null && module instanceof SubscribeModule) {
            ((SubscribeModule)module).clusterNodeDisconnected(node);
        }
    }

    @Override
    public void processPacket(Packet packet) {
        super.processPacket(packet);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.scriptsRegistrar = new ListenerScriptRegistrar(this.listenersScripts, (EventBusContext)this.context, this.scriptEngineManager);
        AdHocCommandModule adHocCommandModule = (AdHocCommandModule)this.getModuleProvider().getModule("commands");
        adHocCommandModule.register(new AddListenerScriptCommand(this.scriptEngineManager, this.scriptsRegistrar));
        adHocCommandModule.register(new RemoveListenerScriptCommand(this.listenersScripts, this.scriptsRegistrar));
        this.scriptsRegistrar.load();
    }

    private class EventBusContextImpl
    extends AbstractContext
    implements EventBusContext {
        private final LocalEventBus eventBusInstance;

        public EventBusContextImpl(AbstractComponent<?> component) {
            super(component);
            this.eventBusInstance = (LocalEventBus)EventBusFactory.getInstance();
        }

        @Override
        public AffiliationStore getAffiliationStore() {
            return EventBusComponent.this.affiliationStore;
        }

        @Override
        public Collection<String> getConnectedNodes() {
            return Collections.unmodifiableCollection(EventBusComponent.this.connectedNodes);
        }

        @Override
        public LocalEventBus getEventBusInstance() {
            return this.eventBusInstance;
        }

        @Override
        public SubscriptionStore getSubscriptionStore() {
            return EventBusComponent.this.subscriptionStore;
        }
    }
}

