/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.ldap;

import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Base64;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"ldaps?:.*"})
public class LdapAuthProvider
implements AuthRepository {
    private static final Logger log = Logger.getLogger(LdapAuthProvider.class.getName());
    protected static final String[] non_sasl_mechs = new String[]{"password"};
    protected static final String[] sasl_mechs = new String[]{"PLAIN"};
    public static final String USER_DN_PATTERN_KEY = "user-dn-pattern";
    private String providerUrl;
    private String userDnPattern;

    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        throw new TigaseDBException("Not available");
    }

    @Override
    @Deprecated
    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        throw new AuthorizationException("Not supported.");
    }

    private boolean doBindAuthentication(BareJID userId, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.providerUrl);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Authenticating user '" + userId + "' with password ******");
            }
            String dn = String.format(this.userDnPattern, userId.getLocalpart(), userId.getDomain(), userId.toString());
            if (log.isLoggable(Level.FINER)) {
                log.finer("Using DN:" + dn);
            }
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", dn);
            env.put("java.naming.security.credentials", password);
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
            if (log.isLoggable(Level.FINE)) {
                log.fine("User " + userId + " authenticated.");
            }
            return true;
        }
        catch (AuthenticationException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Authentication error: " + e.getMessage());
            }
            return false;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Can't authenticate user", e);
            }
            return false;
        }
    }

    @Override
    public String getResourceUri() {
        return this.providerUrl;
    }

    @Override
    public long getUsersCount() {
        return -1L;
    }

    @Override
    public long getUsersCount(String domain) {
        return -1L;
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        this.userDnPattern = params.get(USER_DN_PATTERN_KEY);
        this.providerUrl = resource_uri;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("User DN Pattern: " + this.userDnPattern);
            log.config("LDAP URL: " + this.providerUrl);
        }
    }

    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            if (props.get("mechanism").equals("PLAIN")) {
                return this.saslAuth(props);
            }
        } else if (proto.equals("nonsasl")) {
            String password = (String)props.get("password");
            BareJID user_id = (BareJID)props.get("user-id");
            boolean auth = this.doBindAuthentication(user_id, password);
            if (auth) {
                props.put("user-id", user_id);
            }
            return auth;
        }
        throw new AuthorizationException("Protocol is not supported.");
    }

    @Override
    @Deprecated
    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        throw new AuthorizationException("Not supported.");
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Not available");
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            byte[] in_data;
            SaslPLAINLdap ss = new SaslPLAINLdap((String)props.get("server-name"));
            String data_str = (String)props.get("data");
            byte[] byArray = in_data = data_str != null ? Base64.decode(data_str) : new byte[]{};
            if (log.isLoggable(Level.FINEST)) {
                log.finest("response: " + new String(in_data));
            }
            byte[] challenge = ss.evaluateResponse(in_data);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("challenge: " + (challenge != null ? new String(challenge) : "null"));
            }
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode(challenge) : null;
            props.put("result", challenge_str);
            if (ss.isComplete()) {
                props.put("user-id", ss.getUser_id());
                return true;
            }
            return false;
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Not available");
    }

    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Not available");
    }

    private class SaslPLAINLdap
    implements SaslServer {
        private boolean authOk = false;
        private final String serverName;
        private BareJID userId;

        public SaslPLAINLdap(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public void dispose() throws SaslException {
        }

        @Override
        public byte[] evaluateResponse(byte[] byteArray) throws SaslException {
            int user_idx;
            int auth_idx;
            for (auth_idx = 0; byteArray[auth_idx] != 0 && auth_idx < byteArray.length; ++auth_idx) {
            }
            for (user_idx = ++auth_idx; byteArray[user_idx] != 0 && user_idx < byteArray.length; ++user_idx) {
            }
            String user_id = new String(byteArray, auth_idx, user_idx - auth_idx);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SASL userId: " + user_id);
            }
            String passwd = new String(byteArray, ++user_idx, byteArray.length - user_idx);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SASL password: " + passwd);
            }
            try {
                this.userId = BareJID.bareJIDInstance(user_id, this.serverName);
                this.authOk = LdapAuthProvider.this.doBindAuthentication(this.userId, passwd);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can't authenticate user", e);
                this.authOk = false;
            }
            return null;
        }

        @Override
        public String getAuthorizationID() {
            return null;
        }

        @Override
        public String getMechanismName() {
            return "PLAIN";
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            return null;
        }

        public BareJID getUser_id() {
            return this.userId;
        }

        @Override
        public boolean isComplete() {
            return this.authOk;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            return null;
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            return null;
        }
    }
}

