/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.repo;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.repo.ClConRepoDefaults;
import tigase.cluster.repo.ClusterRepoItem;
import tigase.db.DBInitException;
import tigase.db.comp.ConfigRepository;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.util.DNSResolver;

public class ClConConfigRepository
extends ConfigRepository<ClusterRepoItem>
implements ShutdownHook {
    private static final Logger log = Logger.getLogger(ClConConfigRepository.class.getName());
    public static final String AUTORELOAD_INTERVAL_PROP_KEY = "repo-autoreload-interval";
    public static final long AUTORELOAD_INTERVAL_PROP_VAL = 15L;
    protected long autoreload_interval = 15L;
    protected long lastReloadTime = 0L;
    protected long lastReloadTimeFactor = 10L;

    @Override
    public void destroy() {
    }

    @Override
    public String[] getDefaultPropetyItems() {
        return ClConRepoDefaults.getDefaultPropetyItems();
    }

    @Override
    public String getName() {
        return "Cluster repository clean-up";
    }

    @Override
    public String getPropertyKey() {
        return ClConRepoDefaults.getPropertyKey();
    }

    @Override
    public String getConfigKey() {
        return ClConRepoDefaults.getConfigKey();
    }

    @Override
    public ClusterRepoItem getItemInstance() {
        return ClConRepoDefaults.getItemInstance();
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void reload() {
        super.reload();
        String host = DNSResolver.getDefaultHostname();
        ClusterRepoItem item = (ClusterRepoItem)this.getItem(host);
        if (item == null) {
            item = this.getItemInstance();
            item.setHostname(host);
        }
        item.setLastUpdate(System.currentTimeMillis());
        item.setCpuUsage(TigaseRuntime.getTigaseRuntime().getCPUUsage());
        item.setMemUsage(TigaseRuntime.getTigaseRuntime().getHeapMemUsage());
        this.storeItem(item);
    }

    public void itemLoaded(ClusterRepoItem item) {
        if (System.currentTimeMillis() - item.getLastUpdate() <= 5000L * this.autoreload_interval && this.clusterRecordValid(item)) {
            this.addItem(item);
        } else {
            this.removeItem(item.getHostname());
        }
    }

    @Override
    public boolean itemChanged(ClusterRepoItem oldItem, ClusterRepoItem newItem) {
        return !oldItem.getPassword().equals(newItem.getPassword()) || oldItem.getPortNo() != newItem.getPortNo();
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        String[] items_arr;
        super.getDefaults(defs, params);
        defs.put(AUTORELOAD_INTERVAL_PROP_KEY, 15L);
        for (String it : items_arr = (String[])defs.get(this.getConfigKey())) {
            ClusterRepoItem item = this.getItemInstance();
            item.initFromPropertyString(it);
            this.addItem(item);
        }
        if (this.getItem(DNSResolver.getDefaultHostname()) == null) {
            ClusterRepoItem item = this.getItemInstance();
            item.initFromPropertyString(DNSResolver.getDefaultHostname());
            this.addItem(item);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.autoreload_interval = (Long)props.get(AUTORELOAD_INTERVAL_PROP_KEY);
        this.setAutoloadTimer(this.autoreload_interval);
        TigaseRuntime.getTigaseRuntime().addShutdownHook(this);
    }

    @Override
    public String shutdown() {
        String host = DNSResolver.getDefaultHostname();
        this.removeItem(host);
        return "== Removing cluster_nodes item: " + host + "\n";
    }

    public void storeItem(ClusterRepoItem item) {
    }

    private boolean clusterRecordValid(ClusterRepoItem item) {
        boolean isCorrect;
        boolean bl = isCorrect = !item.getHostname().equalsIgnoreCase("localhost");
        if (!isCorrect && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Incorrect entry in cluster table, skipping: {0}", item);
        }
        return isCorrect;
    }
}

