/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.DateUtil;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.modules.PresenceModule;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PresenceModuleImpl
extends AbstractMucModule
implements PresenceModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    protected static final Logger log = Logger.getLogger(PresenceModule.class.getName());
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();

    public static void addCodes(PresenceModule.PresenceWrapper wrapper, boolean newRoomCreated, String newNickName) {
        if (newRoomCreated) {
            wrapper.addStatusCode(201);
        }
        if (newNickName != null) {
            wrapper.addStatusCode(303);
            for (Element item : wrapper.items) {
                item.setAttribute("nick", newNickName);
            }
        }
    }

    private static Role getDefaultRole(RoomConfig config, Affiliation affiliation) {
        Role newRole;
        if (config.isRoomModerated() && affiliation == Affiliation.none) {
            newRole = Role.visitor;
        } else {
            switch (affiliation) {
                case admin: {
                    newRole = Role.moderator;
                    break;
                }
                case member: {
                    newRole = Role.participant;
                    break;
                }
                case none: {
                    newRole = Role.participant;
                    break;
                }
                case outcast: {
                    newRole = Role.none;
                    break;
                }
                case owner: {
                    newRole = Role.moderator;
                    break;
                }
                default: {
                    newRole = Role.none;
                }
            }
        }
        return newRole;
    }

    private static Integer toInteger(String v, Integer defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public PresenceModuleImpl() {
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"show"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"status"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"priority"));
        this.allowedElements.add((Criteria)ElementCriteria.xmlns((String)"http://jabber.org/protocol/caps"));
    }

    private void addJoinToHistory(Room room, Date date, JID senderJID, String nickName) {
        MucLogger mucLogger;
        HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
        if (historyProvider != null) {
            historyProvider.addJoinEvent(room, date, senderJID, nickName);
        }
        if ((mucLogger = ((MucContext)this.context).getMucLogger()) != null && room.getConfig().isLoggingEnabled()) {
            mucLogger.addJoinEvent(room, date, senderJID, nickName);
        }
    }

    private void addLeaveToHistory(Room room, Date date, JID senderJID, String nickName) {
        MucLogger mucLogger;
        HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
        if (historyProvider != null) {
            historyProvider.addLeaveEvent(room, date, senderJID, nickName);
        }
        if ((mucLogger = ((MucContext)this.context).getMucLogger()) != null && room.getConfig().isLoggingEnabled()) {
            mucLogger.addLeaveEvent(room, date, senderJID, nickName);
        }
    }

    protected Element clonePresence(Element element) {
        Element toRemove;
        List cc;
        Element presence = new Element(element);
        if (((MucContext)this.context).isPresenceFilterEnabled() && (cc = element.getChildren()) != null) {
            ArrayList<Element> children = new ArrayList<Element>();
            block0: for (Element c : cc) {
                for (Criteria crit : this.allowedElements) {
                    if (!crit.match(c)) continue;
                    children.add(c);
                    continue block0;
                }
            }
            presence.setChildren(children);
        }
        if ((toRemove = presence.getChild("x", "http://jabber.org/protocol/muc")) != null) {
            presence.removeChild(toRemove);
        }
        return presence;
    }

    @Override
    public void doQuit(Room room, JID senderJID) throws TigaseStringprepException {
        String leavingNickname = room.getOccupantsNickname(senderJID);
        Affiliation leavingAffiliation = room.getAffiliation(leavingNickname);
        Role leavingRole = room.getRole(leavingNickname);
        Element presenceElement = new Element("presence");
        if (log.isLoggable(Level.FINER)) {
            log.finer("Occupant " + senderJID + " known as " + leavingNickname + " is leaving room " + room.getRoomJID());
        }
        presenceElement.setAttribute("type", "unavailable");
        ArrayList<JID> occupantJIDs = new ArrayList<JID>(room.getOccupantsJidsByNickname(leavingNickname));
        boolean nicknameGone = room.removeOccupant(senderJID);
        ((MucContext)this.context).getGhostbuster().remove(senderJID, room);
        room.updatePresenceByJid(senderJID, leavingNickname, null);
        if (((MucContext)this.context).isMultiItemMode()) {
            PresenceModule.PresenceWrapper selfPresence = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, presenceElement, senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, leavingRole);
            this.write(selfPresence.packet);
        } else {
            ArrayList<JID> z = new ArrayList<JID>(1);
            z.add(senderJID);
            PresenceModule.PresenceWrapper selfPresence = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, presenceElement, senderJID.getBareJID(), z, leavingNickname, leavingAffiliation, leavingRole);
            this.write(selfPresence.packet);
        }
        if (nicknameGone) {
            for (String occupantNickname : room.getOccupantsNicknames()) {
                for (JID occupantJid : room.getOccupantsJidsByNickname(occupantNickname)) {
                    presenceElement = new Element("presence");
                    presenceElement.setAttribute("type", "unavailable");
                    PresenceModule.PresenceWrapper presence = PresenceModule.PresenceWrapper.preparePresenceW(room, occupantJid, presenceElement, senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, leavingRole);
                    this.write(presence.packet);
                }
            }
            if (room.getConfig().isLoggingEnabled()) {
                this.addLeaveToHistory(room, new Date(), senderJID, leavingNickname);
            }
        } else {
            occupantJIDs = new ArrayList<JID>(room.getOccupantsJidsByNickname(leavingNickname));
            Element pe = room.getLastPresenceCopy(senderJID.getBareJID(), leavingNickname);
            for (String occupantNickname : room.getOccupantsNicknames()) {
                for (JID occupantJid : room.getOccupantsJidsByNickname(occupantNickname)) {
                    if (((MucContext)this.context).isMultiItemMode()) {
                        PresenceModule.PresenceWrapper presence = PresenceModule.PresenceWrapper.preparePresenceW(room, occupantJid, pe.clone(), senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, leavingRole);
                        this.write(presence.packet);
                        continue;
                    }
                    for (JID jid : occupantJIDs) {
                        ArrayList<JID> z = new ArrayList<JID>(1);
                        z.add(jid);
                        PresenceModule.PresenceWrapper presence = PresenceModule.PresenceWrapper.preparePresenceW(room, occupantJid, pe.clone(), senderJID.getBareJID(), z, leavingNickname, leavingAffiliation, leavingRole);
                        this.write(presence.packet);
                    }
                }
            }
        }
        if (room.getOccupantsCount() == 0) {
            HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
            if (historyProvider != null && !room.getConfig().isPersistentRoom()) {
                historyProvider.removeHistory(room);
            }
            ((MucContext)this.context).getMucRepository().leaveRoom(room);
        }
    }

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    protected PresenceModule.PresenceWrapper preparePresence(JID destinationJID, Element presence, Room room, JID occupantJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        PresenceModule.PresenceWrapper wrapper = PresenceModule.PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID);
        PresenceModuleImpl.addCodes(wrapper, newRoomCreated, newNickName);
        return wrapper;
    }

    public void process(Packet element) throws MUCException, TigaseStringprepException {
        JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
        BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
        String nickName = PresenceModuleImpl.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to")));
        String presenceType = element.getAttributeStaticStr("type");
        if (presenceType != null && "error".equals(presenceType)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Ignoring presence with type='" + presenceType + "' from " + senderJID);
            }
            return;
        }
        if (nickName == null) {
            throw new MUCException(Authorization.JID_MALFORMED);
        }
        try {
            boolean probablyReEnter;
            String knownNickname;
            boolean roomCreated;
            Room room = ((MucContext)this.context).getMucRepository().getRoom(roomJID);
            if (presenceType != null && "unavailable".equals(presenceType)) {
                this.processExit(room, element.getElement(), senderJID);
                return;
            }
            if (room == null) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Creating new room '" + roomJID + "' by user " + nickName + "' <" + senderJID.toString() + ">");
                }
                room = ((MucContext)this.context).getMucRepository().createNewRoom(roomJID, senderJID);
                room.addAffiliationByJid(senderJID.getBareJID(), Affiliation.owner);
                room.setRoomLocked(((MucContext)this.context).isNewRoomLocked());
                roomCreated = true;
                knownNickname = null;
                room.getConfig().notifyConfigUpdate();
            } else {
                roomCreated = false;
                knownNickname = room.getOccupantsNickname(senderJID);
            }
            boolean bl = probablyReEnter = element.getElement().getChild("x", "http://jabber.org/protocol/muc") != null;
            if (knownNickname != null && !knownNickname.equals(nickName)) {
                this.processChangeNickname(room, element.getElement(), senderJID, knownNickname, nickName);
            } else if (probablyReEnter || knownNickname == null) {
                this.processEntering(room, roomCreated, element.getElement(), senderJID, nickName);
            } else if (knownNickname.equals(nickName)) {
                this.processChangeAvailabilityStatus(room, element.getElement(), senderJID, knownNickname);
            }
        }
        catch (MUCException e) {
            throw e;
        }
        catch (TigaseStringprepException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processChangeAvailabilityStatus(Room room, Element presenceElement, JID senderJID, String nickname) throws TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + presenceElement.toString());
        }
        if (!room.getConfig().isPresenceFilterEnabled() || room.getConfig().isPresenceFilterEnabled() && !room.getConfig().getPresenceFilteredAffiliations().isEmpty() && room.getConfig().getPresenceFilteredAffiliations().contains((Object)room.getAffiliation(senderJID.getBareJID()))) {
            room.updatePresenceByJid(null, nickname, this.clonePresence(presenceElement));
        }
        Element pe = room.getLastPresenceCopyByJid(senderJID.getBareJID());
        this.sendPresenceToAllOccupants(pe, room, senderJID, false, null);
    }

    protected void processChangeNickname(Room room, Element element, JID senderJID, String senderNickname, String newNickName) throws TigaseStringprepException, MUCException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + element.toString());
        }
        throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED, "Changing nickname is not supported yet.");
    }

    protected void processEntering(Room room, boolean roomCreated, Element element, JID senderJID, String nickname) throws MUCException, TigaseStringprepException {
        Element hist;
        Element password;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + element.toString());
        }
        Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
        Element xElement = element.getChild("x", "http://jabber.org/protocol/muc");
        Element element2 = password = xElement == null ? null : xElement.getChild("password");
        if (room.getConfig().isPasswordProtectedRoom()) {
            String psw = password == null ? null : password.getCData();
            String roomPassword = room.getConfig().getPassword();
            if (psw == null || !psw.equals(roomPassword)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Password '" + psw + "' is not match to room password '" + roomPassword + "' ");
                }
                throw new MUCException(Authorization.NOT_AUTHORIZED);
            }
        }
        if (room.isRoomLocked() && affiliation != Affiliation.owner) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, null, "Room exists but is locked");
        }
        if (!affiliation.isEnterOpenRoom()) {
            if (log.isLoggable(Level.INFO)) {
                log.info("User " + nickname + "' <" + senderJID.toString() + "> is on rooms '" + room.getRoomJID() + "' blacklist");
            }
            throw new MUCException(Authorization.FORBIDDEN);
        }
        if (room.getConfig().isRoomMembersOnly() && !affiliation.isEnterMembersOnlyRoom()) {
            if (log.isLoggable(Level.INFO)) {
                log.info("User " + nickname + "' <" + senderJID.toString() + "> is NOT on rooms '" + room.getRoomJID() + "' member list.");
            }
            throw new MUCException(Authorization.REGISTRATION_REQUIRED);
        }
        BareJID currentOccupantJid = room.getOccupantsJidByNickname(nickname);
        if (!(currentOccupantJid == null || ((MucContext)this.context).isMultiItemMode() && currentOccupantJid.equals((Object)senderJID.getBareJID()))) {
            throw new MUCException(Authorization.CONFLICT);
        }
        this.sendPresencesToNewOccupant(room, senderJID);
        Role newRole = PresenceModuleImpl.getDefaultRole(room.getConfig(), affiliation);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Occupant '" + nickname + "' <" + senderJID.toString() + "> is entering room " + room.getRoomJID() + " as role=" + newRole.name() + ", affiliation=" + affiliation.name());
        }
        Element pe = this.clonePresence(element);
        room.addOccupantByJid(senderJID, nickname, newRole, pe);
        ((MucContext)this.context).getGhostbuster().add(senderJID, room);
        this.sendPresenceToAllOccupants(room, senderJID, roomCreated, null);
        Integer maxchars = null;
        Integer maxstanzas = null;
        Integer seconds = null;
        Date since = null;
        Element element3 = hist = xElement == null ? null : xElement.getChild("history");
        if (hist != null) {
            maxchars = PresenceModuleImpl.toInteger(hist.getAttributeStaticStr("maxchars"), null);
            maxstanzas = PresenceModuleImpl.toInteger(hist.getAttributeStaticStr("maxstanzas"), null);
            seconds = PresenceModuleImpl.toInteger(hist.getAttributeStaticStr("seconds"), null);
            since = DateUtil.parse(hist.getAttributeStaticStr("since"));
        }
        this.sendHistoryToUser(room, senderJID, maxchars, maxstanzas, seconds, since);
        if (room.getSubject() != null && room.getSubjectChangerNick() != null && room.getSubjectChangeDate() != null) {
            Element message = new Element("message", new String[]{"type", "from", "to"}, new String[]{"groupchat", room.getRoomJID() + "/" + room.getSubjectChangerNick(), senderJID.toString()});
            message.addChild((XMLNodeIfc)new Element("subject", room.getSubject()));
            String stamp = DateUtil.formatDatetime(room.getSubjectChangeDate());
            Element delay = new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", stamp});
            delay.setAttribute("jid", room.getRoomJID() + "/" + room.getSubjectChangerNick());
            Element x = new Element("x", new String[]{"xmlns", "stamp"}, new String[]{"jabber:x:delay", DateUtil.formatOld(room.getSubjectChangeDate())});
            message.addChild((XMLNodeIfc)delay);
            message.addChild((XMLNodeIfc)x);
            Packet p = Packet.packetInstance((Element)message);
            p.setXMLNS("jabber:client");
            this.write(p);
        }
        if (room.isRoomLocked()) {
            this.sendMucMessage(room, room.getOccupantsNickname(senderJID), "Room is locked. Please configure.");
        }
        if (roomCreated) {
            StringBuilder sb = new StringBuilder();
            sb.append("Welcome! You created new Multi User Chat Room.");
            if (room.isRoomLocked()) {
                sb.append(" Room is locked now. Configure it please!");
            } else if (((MucContext)this.context).isNewRoomLocked()) {
                sb.append(" Room is unlocked and ready for occupants!");
            }
            this.sendMucMessage(room, room.getOccupantsNickname(senderJID), sb.toString());
        }
        if (room.getConfig().isLoggingEnabled()) {
            this.addJoinToHistory(room, new Date(), senderJID, nickname);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(room.getDebugInfoOccupants());
        }
    }

    protected void processExit(Room room, Element presenceElement, JID senderJID) throws MUCException, TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + presenceElement.toString());
        }
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unkown room");
        }
        String leavingNickname = room.getOccupantsNickname(senderJID);
        if (leavingNickname == null) {
            return;
        }
        this.doQuit(room, senderJID);
    }

    private void sendHistoryToUser(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since) {
        HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending history to user using: " + historyProvider + " history provider");
        }
        if (historyProvider != null) {
            historyProvider.getHistoryMessages(room, senderJID, maxchars, maxstanzas, seconds, since, ((MucContext)this.context).getWriter());
        }
    }

    @Override
    public void sendPresencesToNewOccupant(Room room, JID senderJID) throws TigaseStringprepException {
        BareJID currentOccupantJid = senderJID.getBareJID();
        Affiliation senderAffiliation = room.getAffiliation(currentOccupantJid);
        if (room.getConfig().isPresenceFilterEnabled() && !room.getConfig().getPresenceFilteredAffiliations().contains((Object)senderAffiliation)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Filtering enabled: " + room.getConfig().isPresenceFilterEnabled() + "; new occupant doesn't have propper affiliation -  skip sending occupants list");
            }
            return;
        }
        for (String occupantNickname : room.getOccupantsNicknames()) {
            BareJID occupantJid = room.getOccupantsJidByNickname(occupantNickname);
            if (currentOccupantJid != null && currentOccupantJid.equals((Object)occupantJid)) continue;
            Affiliation affiliation = room.getAffiliation(occupantJid);
            if (room.getConfig().isPresenceFilterEnabled() && !room.getConfig().getPresenceFilteredAffiliations().contains((Object)affiliation)) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Filtering enabled: " + room.getConfig().isPresenceFilterEnabled() + "; target occupant doesn't have propper affiliation -  don't include him in the list");
                continue;
            }
            Element op = room.getLastPresenceCopyByJid(occupantJid);
            Collection<JID> occupantJIDs = room.getOccupantsJidsByNickname(occupantNickname);
            BareJID occupantBareJID = room.getOccupantsJidByNickname(occupantNickname);
            Affiliation occupantAffiliation = room.getAffiliation(occupantBareJID);
            Role occupantRole = room.getRole(occupantNickname);
            if (((MucContext)this.context).isMultiItemMode()) {
                PresenceModule.PresenceWrapper l = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, op.clone(), occupantBareJID, occupantJIDs, occupantNickname, occupantAffiliation, occupantRole);
                this.write(l.packet);
                continue;
            }
            for (JID jid : occupantJIDs) {
                ArrayList<JID> z = new ArrayList<JID>(1);
                z.add(jid);
                PresenceModule.PresenceWrapper l = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, op.clone(), occupantBareJID, z, occupantNickname, occupantAffiliation, occupantRole);
                this.write(l.packet);
            }
        }
    }

    protected void sendPresenceToAllOccupants(Element $presence, Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        String occupantNickname = room.getOccupantsNickname(senderJID);
        BareJID occupantJID = room.getOccupantsJidByNickname(occupantNickname);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJID);
        Role occupantRole = room.getRole(occupantNickname);
        Collection<String> occupantsNicknames = room.getConfig().isPresenceFilterEnabled() ? (room.getConfig().getPresenceFilteredAffiliations().contains((Object)occupantAffiliation) ? room.getPresenceFiltered().getOccupantsPresenceFilteredNicknames() : Arrays.asList(occupantNickname)) : room.getOccupantsNicknames();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending presence to all occupants, filtering enabled: " + room.getConfig().isPresenceFilterEnabled() + ", occupantsNicknames: " + Arrays.asList(occupantsNicknames));
        }
        for (String destinationNickname : occupantsNicknames) {
            for (JID destinationJID : room.getOccupantsJidsByNickname(destinationNickname)) {
                if (((MucContext)this.context).isMultiItemMode()) {
                    PresenceModule.PresenceWrapper presence = this.preparePresence(destinationJID, $presence.clone(), room, senderJID, newRoomCreated, newNickName);
                    this.write(presence.packet);
                    continue;
                }
                for (JID jid : room.getOccupantsJidsByNickname(occupantNickname)) {
                    ArrayList<JID> z = new ArrayList<JID>(1);
                    z.add(jid);
                    PresenceModule.PresenceWrapper l = PresenceModule.PresenceWrapper.preparePresenceW(room, destinationJID, $presence.clone(), occupantJID, z, occupantNickname, occupantAffiliation, occupantRole);
                    PresenceModuleImpl.addCodes(l, newRoomCreated, newNickName);
                    this.write(l.packet);
                }
            }
        }
    }

    protected void sendPresenceToAllOccupants(Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        Element presence;
        if (newNickName != null) {
            presence = new Element("presence");
            presence.setAttribute("type", "unavailable");
        } else if (room.getOccupantsNickname(senderJID) == null) {
            presence = new Element("presence");
            presence.setAttribute("type", "unavailable");
        } else {
            presence = room.getLastPresenceCopyByJid(senderJID.getBareJID());
        }
        this.sendPresenceToAllOccupants(presence, room, senderJID, newRoomCreated, newNickName);
    }

    public static class DelayDeliveryThread
    extends Thread {
        private final LinkedList<Element[]> items = new LinkedList();
        private final DelDeliverySend sender;

        public DelayDeliveryThread(DelDeliverySend component) {
            this.sender = component;
        }

        public void put(Collection<Element> elements) {
            if (elements != null && elements.size() > 0) {
                this.items.push(elements.toArray(new Element[0]));
            }
        }

        public void put(Element element) {
            this.items.add(new Element[]{element});
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block4: while (true) {
                    DelayDeliveryThread.sleep(553L);
                    if (this.items.size() <= 0 || (toSend = this.items.poll()) == null) continue;
                    var2_3 = toSend;
                    var3_4 = var2_3.length;
                    var4_5 = 0;
                    while (true) {
                        block6: {
                            if (var4_5 < var3_4) ** break;
                            continue block4;
                            element = var2_3[var4_5];
                            try {
                                p = Packet.packetInstance((Element)element);
                                p.setXMLNS("jabber:client");
                                this.sender.sendDelayedPacket(p);
                            }
                            catch (TigaseStringprepException ex) {
                                if (!PresenceModuleImpl.log.isLoggable(Level.INFO)) break block6;
                                PresenceModuleImpl.log.info("Packet addressing problem, stringprep failed: " + element);
                            }
                        }
                        ++var4_5;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }

        public static interface DelDeliverySend {
            public void sendDelayedPacket(Packet var1);
        }
    }
}

