/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.script.Bindings;
import tigase.component.AbstractComponent;
import tigase.component.AbstractContext;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.Module;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.conf.ConfigurationException;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.muc.Ghostbuster2;
import tigase.muc.MucContext;
import tigase.muc.RoomConfig;
import tigase.muc.history.HistoryManagerFactory;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.DiscoveryModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.IqStanzaForwarderModule;
import tigase.muc.modules.MediatedInvitationModule;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.muc.modules.PrivateMessageModule;
import tigase.muc.modules.RoomConfigurationModule;
import tigase.muc.modules.UniqueRoomNameModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.server.Packet;
import tigase.xmpp.BareJID;

public class MUCComponent
extends AbstractComponent<MucContext> {
    public static final String DEFAULT_ROOM_CONFIG_PREFIX_KEY = "default_room_config/";
    private static final String GHOSTBUSTER_ENABLED_KEY = "ghostbuster-enabled";
    public static final String LOG_DIR_KEY = "room-log-directory";
    public static final String MESSAGE_FILTER_ENABLED_KEY = "message-filter-enabled";
    public static final String MUC_ALLOW_CHAT_STATES_KEY = "muc-allow-chat-states";
    public static final String MUC_LOCK_NEW_ROOM_KEY = "muc-lock-new-room";
    public static final String MUC_MULTI_ITEM_ALLOWED_KEY = "muc-multi-item-allowed";
    protected static final String MUC_REPO_CLASS_PROP_KEY = "muc-repo-class";
    protected static final String MUC_REPO_URL_PROP_KEY = "muc-repo-url";
    private static final String MUC_REPOSITORY_VAR = "mucRepository";
    private static final String OWNER_MODULE_VAR = "ownerModule";
    @Deprecated
    public static final String PING_EVERY_MINUTE_KEY = "ping-every-minute";
    public static final String PRESENCE_FILTER_ENABLED_KEY = "presence-filter-enabled";
    private static final String PRESENCE_MODULE_VAR = "presenceModule";
    public static final String SEARCH_GHOSTS_EVERY_MINUTE_KEY = "search-ghosts-every-minute";
    protected String chatLoggingDirectory;
    protected Boolean chatStateAllowed;
    protected Ghostbuster2 ghostbuster;
    protected HistoryProvider historyProvider;
    protected boolean messageFilterEnabled;
    protected MucLogger mucLogger;
    protected IMucRepository mucRepository;
    protected boolean multiItemMode;
    protected Boolean newRoomLocked;
    protected boolean presenceFilterEnabled;
    protected boolean searchGhostsEveryMinute = false;

    protected static void addIfExists(Bindings binds, String name, Object value) {
        if (value != null) {
            binds.put(name, value);
        }
    }

    protected MucContext createContext() {
        return new MucContextImpl(this);
    }

    protected IMucRepository createMucRepository(MucContext componentConfig, MucDAO dao) throws RepositoryException {
        return new InMemoryMucRepository(componentConfig, dao);
    }

    public synchronized void everyHour() {
        super.everyHour();
        if (!this.searchGhostsEveryMinute) {
            this.executePingInThread();
        }
    }

    public synchronized void everyMinute() {
        super.everyMinute();
        if (this.searchGhostsEveryMinute) {
            this.executePingInThread();
        }
    }

    private void executePingInThread() {
        if (this.ghostbuster != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        MUCComponent.this.ghostbuster.ping();
                    }
                    catch (Exception e) {
                        MUCComponent.this.log.log(Level.SEVERE, "Can't ping known JIDs", e);
                    }
                }
            }.start();
        }
    }

    public String getComponentVersion() {
        String version = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    protected Map<String, Class<? extends Module>> getDefaultModulesList() {
        HashMap<String, Class<? extends Module>> result = new HashMap<String, Class<? extends Module>>();
        result.put("urn:xmpp:ping", XmppPingModule.class);
        result.put("jabber:iq:version", JabberVersionModule.class);
        result.put("disco", DiscoveryModule.class);
        result.put("groupchat", GroupchatMessageModule.class);
        result.put("iqforwarder", IqStanzaForwarderModule.class);
        result.put("invitations", MediatedInvitationModule.class);
        result.put("admin", ModeratorModule.class);
        result.put("presences", PresenceModuleImpl.class);
        result.put("privatemessages", PrivateMessageModule.class);
        result.put("owner", RoomConfigurationModule.class);
        result.put("unique", UniqueRoomNameModule.class);
        result.put("commands", AdHocCommandModule.class);
        return result;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        props.put(LOG_DIR_KEY, new String("./logs/"));
        props.put(MESSAGE_FILTER_ENABLED_KEY, Boolean.TRUE);
        props.put(PRESENCE_FILTER_ENABLED_KEY, Boolean.FALSE);
        props.put(SEARCH_GHOSTS_EVERY_MINUTE_KEY, Boolean.FALSE);
        props.put(GHOSTBUSTER_ENABLED_KEY, Boolean.TRUE);
        props.put(MUC_ALLOW_CHAT_STATES_KEY, Boolean.FALSE);
        props.put(MUC_LOCK_NEW_ROOM_KEY, Boolean.TRUE);
        props.put(MUC_MULTI_ITEM_ALLOWED_KEY, Boolean.TRUE);
        String repo_uri = params.get("--user-db-uri") != null ? (String)params.get("--user-db-uri") : "memory";
        props.put("history-db-uri", repo_uri);
        return props;
    }

    public String getDiscoCategory() {
        return "conference";
    }

    public String getDiscoCategoryType() {
        return "text";
    }

    public String getDiscoDescription() {
        return "Multi User Chat";
    }

    public IMucRepository getMucRepository() {
        return this.mucRepository;
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaFrom() != null && packet.getPacketFrom() != null && !this.getComponentId().equals((Object)packet.getPacketFrom())) {
            return packet.getStanzaFrom().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        return 1;
    }

    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        MUCComponent.addIfExists(binds, PRESENCE_MODULE_VAR, this.modulesManager.getModule("presences"));
        MUCComponent.addIfExists(binds, OWNER_MODULE_VAR, this.modulesManager.getModule("owner"));
        MUCComponent.addIfExists(binds, MUC_REPOSITORY_VAR, this.mucRepository);
    }

    public boolean isDiscoNonAdmin() {
        return true;
    }

    public boolean isSubdomain() {
        return true;
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public void processPacket(Packet packet) {
        if (this.ghostbuster != null) {
            try {
                this.ghostbuster.update(packet);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "There is no Dana, there is only Zuul", e);
            }
        }
        super.processPacket(packet);
    }

    public void release() {
        super.release();
        if (this.historyProvider != null) {
            this.historyProvider.destroy();
            this.historyProvider = null;
        }
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (props.size() == 1) {
            this.log.config("props.size() == 1, ignoring setting properties");
            return;
        }
        if (props.containsKey(PING_EVERY_MINUTE_KEY)) {
            this.searchGhostsEveryMinute = (Boolean)props.get(PING_EVERY_MINUTE_KEY);
            this.log.config("props.containsKey(PING_EVERY_MINUTE_KEY): " + props.containsKey(PING_EVERY_MINUTE_KEY));
        } else {
            this.log.config("props.containsKey(PING_EVERY_MINUTE_KEY): " + props.containsKey(SEARCH_GHOSTS_EVERY_MINUTE_KEY));
            this.searchGhostsEveryMinute = (Boolean)props.get(SEARCH_GHOSTS_EVERY_MINUTE_KEY);
        }
        this.log.config("searchGhostsEveryMinute: " + this.searchGhostsEveryMinute + "; " + props.containsKey(PING_EVERY_MINUTE_KEY));
        if (props.containsKey(GHOSTBUSTER_ENABLED_KEY)) {
            boolean e = (Boolean)props.get(GHOSTBUSTER_ENABLED_KEY);
            if (e && this.ghostbuster == null) {
                this.log.config("Enabling Ghostbuster");
                this.ghostbuster = new Ghostbuster2(this);
            } else if (!e && this.ghostbuster != null) {
                this.log.config("Disabling Ghostbuster");
                this.ghostbuster = null;
            }
        }
        if (props.containsKey(MESSAGE_FILTER_ENABLED_KEY)) {
            this.messageFilterEnabled = (Boolean)props.get(MESSAGE_FILTER_ENABLED_KEY);
        }
        this.log.config("messageFilterEnabled: " + this.messageFilterEnabled + "; props: " + props.containsKey(MESSAGE_FILTER_ENABLED_KEY));
        if (props.containsKey(PRESENCE_FILTER_ENABLED_KEY)) {
            this.presenceFilterEnabled = (Boolean)props.get(PRESENCE_FILTER_ENABLED_KEY);
        }
        this.log.config("presenceFilterEnabled: " + this.presenceFilterEnabled + "; props: " + props.containsKey(PRESENCE_FILTER_ENABLED_KEY));
        if (props.containsKey(MUC_MULTI_ITEM_ALLOWED_KEY)) {
            this.multiItemMode = (Boolean)props.get(MUC_MULTI_ITEM_ALLOWED_KEY);
        }
        this.log.config("multiItemMode: " + this.multiItemMode + "; props: " + props.containsKey(MUC_MULTI_ITEM_ALLOWED_KEY));
        if (props.containsKey(MUC_ALLOW_CHAT_STATES_KEY)) {
            this.chatStateAllowed = (Boolean)props.get(MUC_ALLOW_CHAT_STATES_KEY);
        }
        this.log.config("chatStateAllowed: " + this.chatStateAllowed + "; props: " + props.containsKey(MUC_ALLOW_CHAT_STATES_KEY));
        if (props.containsKey(MUC_LOCK_NEW_ROOM_KEY)) {
            this.newRoomLocked = (Boolean)props.get(MUC_LOCK_NEW_ROOM_KEY);
        }
        this.log.config("newRoomLocked: " + this.newRoomLocked + "; props: " + props.containsKey(MUC_LOCK_NEW_ROOM_KEY));
        if (props.containsKey(LOG_DIR_KEY)) {
            this.log.config("Setting Chat Logging Directory");
            this.chatLoggingDirectory = (String)props.get(LOG_DIR_KEY);
        }
        this.log.config("Initializing History Provider, props.containsKey(HistoryManagerFactory.DB_CLASS_KEY): " + props.containsKey("history-db"));
        HistoryProvider oldHistoryProvider = this.historyProvider;
        this.historyProvider = HistoryManagerFactory.getHistoryManager(props);
        this.historyProvider.init(props);
        if (oldHistoryProvider != null) {
            oldHistoryProvider.destroy();
        }
        if (this.mucRepository == null) {
            try {
                String cls_name = (String)props.get(MUC_REPO_CLASS_PROP_KEY);
                String res_uri = (String)props.get(MUC_REPO_URL_PROP_KEY);
                this.log.config("Initializing MUC Repository; cls_name: " + cls_name + "; res_uri: " + res_uri);
                UserRepository userRepository = cls_name != null && res_uri != null ? RepositoryFactory.getUserRepository((String)cls_name, (String)res_uri, null) : (UserRepository)props.get("shared-user-repo");
                MucDAO dao = new MucDAO((MucContext)this.context, userRepository);
                this.mucRepository = this.createMucRepository((MucContext)this.context, dao);
                this.log.config("MUC Repository initialized; userRepository: " + userRepository + "; MucDAO dao: " + dao + "; mucRepository: " + this.mucRepository);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Cannot initialize MUC Repository", e);
            }
        }
        this.log.config("Initializing MUC Logger, props.containsKey(MucLogger.MUC_LOGGER_CLASS_KEY)" + props.containsKey("muc-logger-class"));
        if (props.containsKey("muc-logger-class")) {
            String loggerClassName = (String)props.get("muc-logger-class");
            try {
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Using Room Logger: " + loggerClassName);
                }
                this.mucLogger = (MucLogger)Class.forName(loggerClassName).newInstance();
                this.mucLogger.init((MucContext)this.context);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Cannot initialize MUC Logger", e);
            }
        }
        try {
            this.updateDefaultRoomConfig(props);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Cannot update Default Room Config", e);
        }
        super.setProperties(props);
        if (this.ghostbuster != null && this.modulesManager.isRegistered("presences")) {
            PresenceModule module = (PresenceModule)this.modulesManager.getModule("presences");
            this.ghostbuster.setPresenceModule(module);
        }
    }

    private void updateDefaultRoomConfig(Map<String, Object> props) throws RepositoryException {
        boolean found = false;
        for (Map.Entry<String, Object> x : props.entrySet()) {
            if (!x.getKey().startsWith(DEFAULT_ROOM_CONFIG_PREFIX_KEY)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.log.config("Updating Default Room Config");
        RoomConfig defaultRoomConfig = this.mucRepository.getDefaultRoomConfig();
        boolean changed = false;
        for (Map.Entry<String, Object> x : props.entrySet()) {
            if (!x.getKey().startsWith(DEFAULT_ROOM_CONFIG_PREFIX_KEY)) continue;
            String var = x.getKey().substring(DEFAULT_ROOM_CONFIG_PREFIX_KEY.length());
            Field field = defaultRoomConfig.getConfigForm().get(var);
            if (field != null) {
                changed = true;
                String[] values = ((String)x.getValue()).split(",");
                field.setValues(values);
                continue;
            }
            if (!this.log.isLoggable(Level.WARNING)) continue;
            this.log.warning("Default config room doesn't contains variable '" + var + "'!");
        }
        if (changed) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Default room configuration is udpated");
            }
            this.mucRepository.updateDefaultRoomConfig(defaultRoomConfig);
        }
    }

    private class MucContextImpl
    extends AbstractContext
    implements MucContext {
        private final BareJID serviceName;

        public MucContextImpl(AbstractComponent<?> component) {
            super(component);
            this.serviceName = BareJID.bareJIDInstanceNS((String)"multi-user-chat");
        }

        @Override
        public String getChatLoggingDirectory() {
            return MUCComponent.this.chatLoggingDirectory;
        }

        @Override
        public Ghostbuster2 getGhostbuster() {
            return MUCComponent.this.ghostbuster;
        }

        @Override
        public HistoryProvider getHistoryProvider() {
            return MUCComponent.this.historyProvider;
        }

        @Override
        public MucLogger getMucLogger() {
            return MUCComponent.this.mucLogger;
        }

        @Override
        public IMucRepository getMucRepository() {
            return MUCComponent.this.mucRepository;
        }

        @Override
        public BareJID getServiceName() {
            return this.serviceName;
        }

        @Override
        public boolean isChatStateAllowed() {
            return MUCComponent.this.chatStateAllowed;
        }

        @Override
        public boolean isMessageFilterEnabled() {
            return MUCComponent.this.messageFilterEnabled;
        }

        @Override
        public boolean isMultiItemMode() {
            return MUCComponent.this.multiItemMode;
        }

        @Override
        public boolean isNewRoomLocked() {
            return MUCComponent.this.newRoomLocked;
        }

        @Override
        public boolean isPresenceFilterEnabled() {
            return MUCComponent.this.presenceFilterEnabled;
        }

        @Override
        public boolean isPublicLoggingEnabled() {
            return MUCComponent.this.mucLogger != null || MUCComponent.this.historyProvider != null && MUCComponent.this.historyProvider.isPersistent();
        }
    }
}

