/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5;

import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.conf.ConfigurationException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.socks5.QuotaException;
import tigase.socks5.Socks5ConnectionManager;
import tigase.socks5.Socks5Exception;
import tigase.socks5.Socks5IOService;
import tigase.socks5.Stream;
import tigase.socks5.VerifierIfc;
import tigase.socks5.repository.Socks5Repository;
import tigase.util.Algorithms;
import tigase.util.DNSEntry;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class Socks5ProxyComponent
extends Socks5ConnectionManager
implements ClusteredComponentIfc {
    private static final String[] IQ_QUERY_ACTIVATE_PATH = new String[]{"iq", "query", "activate"};
    private static final Logger log = Logger.getLogger(Socks5ProxyComponent.class.getCanonicalName());
    private static final String PACKET_FORWARD_CMD = "socks5-packet-forward";
    private static final String PARAMS_REPO_NODE = "repo-params";
    private static final String PARAMS_REPO_URL = "repo-url";
    private static final String PARAMS_VERIFIER_NODE = "verifier-params";
    private static final String[] QUERY_ACTIVATE_PATH = new String[]{"query", "activate"};
    private static final String REMOTE_ADDRESSES_KEY = "remote-addresses";
    private static final String SOCKS5_REPOSITORY_CLASS_KEY = "socks5-repo-cls";
    private static final String SOCKS5_REPOSITORY_CLASS_VAL = "tigase.socks5.repository.DummySocks5Repository";
    private static final String VERIFIER_CLASS_KEY = "verifier-class";
    private static final String VERIFIER_CLASS_VAL = "tigase.socks5.verifiers.DummyVerifier";
    private static final String XMLNS_BYTESTREAMS = "http://jabber.org/protocol/bytestreams";
    private ClusterControllerIfc clusterController = null;
    private String[] remoteAddresses = null;
    private Socks5Repository socks5_repo = null;
    private VerifierIfc verifier = null;
    private PacketForward packetForwardCmd = new PacketForward();
    private final List<JID> cluster_nodes = new LinkedList<JID>();

    public synchronized void everyHour() {
        super.everyHour();
    }

    public void nodeConnected(String node) {
        try {
            this.cluster_nodes.add(JID.jidInstance((String)(this.getName() + "@" + node)));
        }
        catch (TigaseStringprepException e) {
            log.log(Level.WARNING, "TigaseStringprepException occured processing {0}", node);
        }
    }

    public void nodeDisconnected(String node) {
        try {
            this.cluster_nodes.remove(JID.jidInstance((String)(this.getName() + "@" + node)));
        }
        catch (TigaseStringprepException e) {
            log.log(Level.WARNING, "TigaseStringprepException occured processing {0}", node);
        }
    }

    public void processPacket(Packet packet) {
        block24: {
            try {
                if (packet.getPacketFrom() != null && packet.getPacketFrom().getLocalpart().equals(this.getName()) && this.cluster_nodes.contains(packet.getPacketFrom())) {
                    packet.setPacketFrom(this.getComponentId());
                    packet.setPacketTo(null);
                    this.addOutPacket(packet);
                    return;
                }
                if (packet.getType() == StanzaType.error) {
                    return;
                }
                if (packet.getElement().getChild("query", XMLNS_BYTESTREAMS) != null) {
                    Element query;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "processing bytestream query packet = {0}", packet);
                    }
                    if ((query = packet.getElement().getChild("query")).getChild("activate") == null) {
                        try {
                            String jid = packet.getStanzaTo().getBareJID().toString();
                            String hostname = this.getComponentId().getDomain();
                            LinkedList<Element> children = new LinkedList<Element>();
                            if (this.remoteAddresses == null || this.remoteAddresses.length == 0) {
                                DNSEntry[] entries;
                                for (DNSEntry entry : entries = DNSResolver.getHostSRV_Entries((String)hostname)) {
                                    int[] ports;
                                    for (int port : ports = this.getPorts()) {
                                        Element streamhost = new Element("streamhost");
                                        streamhost.setAttribute("jid", jid);
                                        streamhost.setAttribute("host", entry.getIp());
                                        streamhost.setAttribute("port", String.valueOf(port));
                                        children.add(streamhost);
                                    }
                                }
                            } else {
                                for (String addr : this.remoteAddresses) {
                                    int[] ports;
                                    for (int port : ports = this.getPorts()) {
                                        Element streamhost = new Element("streamhost");
                                        streamhost.setAttribute("jid", jid);
                                        streamhost.setAttribute("host", addr);
                                        streamhost.setAttribute("port", String.valueOf(port));
                                        children.add(streamhost);
                                    }
                                }
                            }
                            query.addChildren(children);
                            this.addOutPacket(packet.okResult(query, 0));
                        }
                        catch (UnknownHostException e) {
                            this.addOutPacket(packet.errorResult("cancel", null, "internal-server-error", "Address of streamhost not found", false));
                        }
                        break block24;
                    }
                    String sid = query.getAttributeStaticStr("sid");
                    if (sid != null) {
                        Stream stream;
                        String cid = this.createConnId(sid, packet.getStanzaFrom().toString(), query.getCDataStaticStr(QUERY_ACTIVATE_PATH));
                        if (cid == null) {
                            this.addOutPacket(packet.errorResult("cancel", null, "internal-server-error", null, false));
                        }
                        if ((stream = this.getStream(cid)) != null) {
                            stream.setRequester(packet.getStanzaFrom());
                            stream.setTarget(JID.jidInstance((String)query.getCDataStaticStr(QUERY_ACTIVATE_PATH)));
                            if (!this.verifier.isAllowed(stream)) {
                                stream.close();
                                this.addOutPacket(packet.errorResult("cancel", null, "not-allowed", null, false));
                                return;
                            }
                            if (!stream.activate()) {
                                stream.close();
                                this.addOutPacket(packet.errorResult("cancel", null, "internal-server-error", null, false));
                                return;
                            }
                            this.addOutPacket(packet.okResult((Element)null, 0));
                        } else if (!this.sendToNextNode(packet)) {
                            this.addOutPacket(packet.errorResult("cancel", null, "item-not-found", null, true));
                        }
                    } else {
                        this.addOutPacket(packet.errorResult("cancel", null, "bad-request", null, false));
                    }
                    break block24;
                }
                this.addOutPacket(packet.errorResult("cancel", Integer.valueOf(400), "feature-not-implemented", null, false));
            }
            catch (Exception ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "exception while processing packet = " + packet, ex);
                }
                this.addOutPacket(packet.errorResult("cancel", null, "internal-server-error", null, false));
            }
        }
    }

    @Override
    public boolean serviceStopped(Socks5IOService<?> serv) {
        block3: {
            try {
                this.verifier.updateTransfer(serv, true);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "problem during accessing database ", ex);
            }
            catch (QuotaException ex) {
                if (!log.isLoggable(Level.FINEST)) break block3;
                log.log(Level.FINEST, ex.getMessage(), ex);
            }
        }
        return super.serviceStopped(serv);
    }

    @Override
    public void socketDataProcessed(Socks5IOService service) {
        try {
            this.verifier.updateTransfer(service, false);
            super.socketDataProcessed(service);
        }
        catch (Socks5Exception ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "stopping service after exception from verifier: " + ex.getMessage());
            }
            Packet message = Message.getMessage((JID)this.getComponentId(), (JID)service.getJID(), (StanzaType)StanzaType.error, (String)ex.getMessage(), null, null, null);
            this.addOutPacket(message);
            service.forceStop();
        }
        catch (TigaseDBException ex) {
            Logger.getLogger(Socks5ProxyComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put(SOCKS5_REPOSITORY_CLASS_KEY, SOCKS5_REPOSITORY_CLASS_VAL);
        props.put(VERIFIER_CLASS_KEY, VERIFIER_CLASS_VAL);
        return props;
    }

    public String getDiscoCategory() {
        return "proxy";
    }

    public String getDiscoCategoryType() {
        return "bytestreams";
    }

    public String getDiscoDescription() {
        return "Socks5 Bytestreams Service";
    }

    public Socks5Repository getSock5Repository() {
        return this.socks5_repo;
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.clusterController = cl_controller;
        this.clusterController.removeCommandListener((CommandListener)this.packetForwardCmd);
        this.clusterController.setCommandListener((CommandListener)this.packetForwardCmd);
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        Map<String, Object> verifierProps = null;
        if (props.size() > 1) {
            String socks5RepoCls = (String)props.get(SOCKS5_REPOSITORY_CLASS_KEY);
            if (socks5RepoCls == null) {
                socks5RepoCls = SOCKS5_REPOSITORY_CLASS_VAL;
            }
            try {
                UserRepository user_repo;
                String connectionString = (String)props.get(PARAMS_REPO_URL);
                if (connectionString == null && (user_repo = (UserRepository)props.get("shared-user-repo")) != null) {
                    connectionString = user_repo.getResourceUri();
                }
                HashMap<String, String> params = new HashMap<String, String>(10);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    String[] nodes;
                    if (!entry.getKey().startsWith(PARAMS_REPO_NODE) || (nodes = entry.getKey().split("/")).length <= 1) continue;
                    params.put(nodes[1], entry.getValue().toString());
                }
                Socks5Repository socks5_repo = (Socks5Repository)Class.forName(socks5RepoCls).newInstance();
                socks5_repo.initRepository(connectionString, params);
                this.socks5_repo = socks5_repo;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "An error initializing data repository pool: ", ex);
            }
            String verifierCls = (String)props.get(VERIFIER_CLASS_KEY);
            if (verifierCls == null) {
                verifierCls = VERIFIER_CLASS_VAL;
            }
            try {
                this.verifier = (VerifierIfc)Class.forName(verifierCls).newInstance();
                verifierProps = this.verifier.getDefaults();
                this.verifier.setProxyComponent(this);
            }
            catch (Exception ex) {
                Logger.getLogger(Socks5ProxyComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            verifierProps = new HashMap<String, Object>();
        }
        if (props.containsKey(REMOTE_ADDRESSES_KEY)) {
            this.remoteAddresses = (String[])props.get(REMOTE_ADDRESSES_KEY);
        }
        if (this.verifier != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String[] nodes;
                if (!entry.getKey().startsWith(PARAMS_VERIFIER_NODE) || (nodes = entry.getKey().split("/")).length <= 1) continue;
                verifierProps.put(nodes[1], entry.getValue());
            }
            this.verifier.setProperties(verifierProps);
        }
        this.updateServiceDiscoveryItem(this.getName(), null, this.getDiscoDescription(), this.getDiscoCategory(), this.getDiscoCategoryType(), false, new String[]{XMLNS_BYTESTREAMS});
    }

    protected boolean sendToNextNode(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Packet packet) throws TigaseStringprepException {
        JID next_node = null;
        List<JID> nodes = this.cluster_nodes;
        if (nodes != null) {
            for (JID node : nodes) {
                if (visitedNodes.contains(node) || this.getComponentId().equals((Object)node)) continue;
                next_node = node;
                break;
            }
        }
        if (next_node != null) {
            this.clusterController.sendToNodes(PACKET_FORWARD_CMD, packet.getElement(), fromNode, visitedNodes, new JID[]{next_node});
        }
        return next_node != null;
    }

    protected boolean sendToNextNode(Packet packet) {
        if (this.cluster_nodes.size() > 0) {
            JID cluster_node = this.getFirstClusterNode(packet.getStanzaTo());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Cluster node found: {0}", cluster_node);
            }
            if (cluster_node != null) {
                this.clusterController.sendToNodes(PACKET_FORWARD_CMD, packet.getElement(), this.getComponentId(), null, new JID[]{cluster_node});
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected int[] getDefaultPorts() {
        return new int[]{1080};
    }

    protected JID getFirstClusterNode(JID userJid) {
        JID cluster_node = null;
        List<JID> nodes = this.cluster_nodes;
        if (nodes != null) {
            for (JID node : nodes) {
                if (node.equals((Object)this.getComponentId())) continue;
                cluster_node = node;
                break;
            }
        }
        return cluster_node;
    }

    private String createConnId(String sid, String from, String to) {
        try {
            String id = sid + from + to;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return Algorithms.hexDigest((String)"", (String)id, (String)"SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.warning(e.getMessage());
            return null;
        }
    }

    private class PacketForward
    extends CommandListenerAbstract {
        public PacketForward() {
            super(Socks5ProxyComponent.PACKET_FORWARD_CMD);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            for (Element el_packet : packets) {
                try {
                    Packet packet = Packet.packetInstance((Element)el_packet);
                    packet.setPacketFrom(fromNode);
                    packet.setPacketTo(Socks5ProxyComponent.this.getComponentId());
                    String cid = Socks5ProxyComponent.this.createConnId(el_packet.getAttributeStaticStr(Iq.IQ_QUERY_PATH, "sid"), el_packet.getAttributeStaticStr("from"), el_packet.getCDataStaticStr(IQ_QUERY_ACTIVATE_PATH));
                    if (cid == null) {
                        Socks5ProxyComponent.this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Could not calculate SID", true));
                        continue;
                    }
                    if (Socks5ProxyComponent.this.hasStream(cid)) {
                        Socks5ProxyComponent.this.processPacket(packet);
                        continue;
                    }
                    if (Socks5ProxyComponent.this.sendToNextNode(fromNode, visitedNodes, data, packet)) continue;
                    Socks5ProxyComponent.this.addOutPacket(packet.errorResult("cancel", null, "item-not-found", null, true));
                }
                catch (PacketErrorTypeException ex) {
                    Logger.getLogger(Socks5ProxyComponent.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.WARNING, "Addressing error, stringprep failure: {0}", el_packet);
                }
            }
        }
    }
}

