/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import tigase.http.jetty.AbstractJettyHttpServer;

public class JettyStandaloneHttpServer
extends AbstractJettyHttpServer {
    private static final Logger log = Logger.getLogger(JettyStandaloneHttpServer.class.getCanonicalName());
    private int port = 8080;
    private Server server = null;
    private final ContextHandlerCollection contexts = new ContextHandlerCollection();

    @Override
    protected void deploy(ServletContextHandler ctx) {
        this.contexts.addHandler((Handler)ctx);
        try {
            ctx.start();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception deploying http context " + ctx.getContextPath(), ex);
        }
    }

    @Override
    protected void undeploy(ServletContextHandler ctx) {
        this.contexts.removeHandler((Handler)ctx);
        try {
            ctx.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception undeploying http context " + ctx.getContextPath(), ex);
        }
    }

    public void start() {
        if (this.server != null && (this.server.isStarted() || this.server.isStarting())) {
            this.stop();
        }
        if (this.server == null) {
            this.server = new Server(this.port);
        }
        this.server.setHandler((Handler)this.contexts);
        try {
            this.server.start();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception starting internal HTTP server", ex);
        }
    }

    public void stop() {
        if (this.server == null || !this.server.isStarted() && !this.server.isStarting()) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception stopping internal HTTP server", ex);
        }
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("port")) {
            this.port = (Integer)props.get("port");
        }
    }
}

