/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster.commands;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class NodesChangedCommand
extends CommandListenerAbstract {
    private static final Logger a = Logger.getLogger(NodesChangedCommand.class.getCanonicalName());
    public static final String NODES_CHANGED_CMD = "nodes-changed-cmd";
    public static final String ROOT_NODE_ADDED = "root-node-added";
    public static final String ROOT_NODE_REMOVED = "root-node-removed";
    public static final String NODE_CONFIG_CHANGED = "node-config-changed";

    public NodesChangedCommand() {
        super(NODES_CHANGED_CMD);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        Element element;
        CachedPubSubRepositoryClustered cachedPubSubRepositoryClustered = this.getPubSubRepositoryClustered();
        block12: while ((element = packets.poll()) != null) {
            try {
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("service-jid"));
                String string = element.getAttributeStaticStr("node");
                switch (element.getName()) {
                    case "root-node-added": {
                        cachedPubSubRepositoryClustered.getRootCollectionSet(bareJID).add(string);
                        continue block12;
                    }
                    case "root-node-removed": {
                        cachedPubSubRepositoryClustered.getRootCollectionSet(bareJID).remove(string);
                        continue block12;
                    }
                    case "node-config-changed": {
                        cachedPubSubRepositoryClustered.forgetConfiguration(bareJID, string);
                        continue block12;
                    }
                }
                a.log(Level.FINER, "received unknown action: {0} as {1}", new Object[]{element.getName(), element});
            }
            catch (RepositoryException repositoryException) {
                a.log(Level.WARNING, "execution of command nodes-changed-cmd for " + element + " failed", repositoryException);
            }
        }
    }

    protected abstract CachedPubSubRepositoryClustered getPubSubRepositoryClustered();
}

