/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.xmpp.BareJID;

public class CachedPubSubRepositoryClustered<T>
extends CachedPubSubRepository<T> {
    private static final Logger a = Logger.getLogger(CachedPubSubRepositoryClustered.class.getCanonicalName());
    private ThreadLocal<Map<String, Node>> b = new ThreadLocal();
    private StrategyIfc c;

    public CachedPubSubRepositoryClustered(PubSubDAO dao, Integer maxCacheSize, StrategyIfc strategy) {
        super(dao, maxCacheSize);
        this.c = strategy;
    }

    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.addToRootCollection(serviceJid, nodeName);
        this.c.nodeAddedToRootCollection(serviceJid, nodeName);
    }

    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.removeFromRootCollection(serviceJid, nodeName);
        this.c.nodeRemovedFromRootCollection(serviceJid, nodeName);
    }

    public Set<String> getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        return super.getRootCollectionSet(serviceJid);
    }

    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.forgetConfiguration(serviceJid, nodeName);
    }

    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        super.update(serviceJid, nodeName, nodeConfig);
        this.c.nodeConfigurationChanged(serviceJid, nodeName);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node;
        String string = this.createKey(serviceJid, nodeName);
        if (this.isLocalNode(serviceJid, nodeName)) {
            node = super.getNode(serviceJid, nodeName);
        } else {
            Map<String, Node> map = this.b.get();
            if (map == null) {
                map = new HashMap<String, Node>();
                this.b.set(map);
            }
            if ((node = map.get(string)) == null) {
                Object object = this.dao.getNodeId(serviceJid, nodeName);
                if (object == null) {
                    return null;
                }
                String string2 = this.dao.getNodeConfig(serviceJid, object);
                AbstractNodeConfig abstractNodeConfig = this.dao.parseConfig(nodeName, string2);
                if (abstractNodeConfig == null) {
                    return null;
                }
                NodeAffiliations nodeAffiliations = new NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, object));
                tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = this.wrapNodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, object));
                node = new Node(object, serviceJid, abstractNodeConfig, nodeAffiliations, nodeSubscriptions);
                map.put(string, node);
            }
        }
        return node;
    }

    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        AbstractNodeConfig abstractNodeConfig = super.getNodeConfig(serviceJid, nodeName);
        if (abstractNodeConfig != null) {
            return this.c.wrapNodeConfig(serviceJid, nodeName, abstractNodeConfig);
        }
        return abstractNodeConfig;
    }

    public void clearRemoteNodes() {
        Map<String, Node> map = this.b.get();
        if (map != null) {
            map.clear();
        }
    }

    protected boolean isLocalNode(BareJID serviceJid, String nodeName) {
        return this.c.isLocalNode(serviceJid, nodeName);
    }

    protected tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        return this.c.wrapNodeSubscriptions(nodeSubscriptions);
    }
}

