/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.component2.exceptions.ComponentException;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class AbstractStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(AbstractStrategy.class.getCanonicalName());
    protected static final String NODE_ATTR = "node";
    protected static final String NODE_CONFIG_REFRESH_CMD = "node-config-refresh-pubsub-cmd";
    protected static final String[] PUBSUB_PATH = new String[]{"iq", "pubsub"};
    private final CopyOnWriteArrayList<JID> b = new CopyOnWriteArrayList();
    protected final Set<String> nodeConfigureElemNames = new HashSet<String>();
    private final AtomicInteger c = new AtomicInteger();
    protected ClusterControllerIfc cl_controller;
    protected PubSubConfig config;
    protected JID localNodeJid;
    protected PubSubComponentClusteredIfc pubSubComponent;
    protected final ThreadLocal<ArrayDeque<Element>> nodesModifications = new ThreadLocal(){

        public ArrayDeque<Element> a() {
            return new ArrayDeque<Element>();
        }

        public /* synthetic */ Object initialValue() {
            return this.a();
        }
    };

    protected AbstractStrategy() {
        this.nodeConfigureElemNames.add("create");
        this.nodeConfigureElemNames.add("configure");
        this.nodeConfigureElemNames.add("default");
        this.nodeConfigureElemNames.add("delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(JID nodeJid) {
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.b;
        synchronized (copyOnWriteArrayList) {
            if (this.b.addIfAbsent(nodeJid)) {
                this.a(this.b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDisconnected(JID nodeJid) {
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.b;
        synchronized (copyOnWriteArrayList) {
            this.b.remove(nodeJid);
        }
    }

    @Override
    public List<JID> getAllNodes() {
        return new ArrayList<JID>(this.b);
    }

    @Override
    public JID getLocalNodeJid() {
        return this.localNodeJid;
    }

    protected JID getNodeForHashCode(int hashCode) {
        return this.b.get(Math.abs(hashCode % this.b.size()));
    }

    public JID getNodeForServiceJid(JID serviceJid) {
        int n = serviceJid.hashCode();
        return this.getNodeForHashCode(n);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.cl_controller = cl_controller;
    }

    @Override
    public void setConfig(PubSubConfig config) {
        this.config = config;
    }

    protected void setLocalNodeJid(JID jid) {
        this.localNodeJid = jid;
        this.nodeConnected(this.localNodeJid);
    }

    @Override
    public void setPubSubComponentClustered(PubSubComponentClusteredIfc pubSubComponent) {
        this.pubSubComponent = pubSubComponent;
        this.setLocalNodeJid(JID.jidInstanceNS((String)pubSubComponent.getName(), (String)pubSubComponent.getDefHostName().getDomain(), null));
    }

    @Override
    public void packetProcessed() {
    }

    @Override
    public boolean sendException(Packet packet, ComponentException ex) {
        return true;
    }

    @Override
    public AbstractNodeConfig wrapNodeConfig(BareJID serviceJid, String nodeName, AbstractNodeConfig config) {
        return config;
    }

    @Override
    public tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        return new tigase.pubsub.repository.cached.NodeSubscriptions(nodeSubscriptions);
    }

    private void a(List<JID> list) {
        Object[] objectArray = list.toArray(new JID[list.size()]);
        Arrays.sort(objectArray);
        list.clear();
        list.addAll(Arrays.asList(objectArray));
    }

    protected Map<String, String> prepareCommandData(BareJID serviceJid, String nodeName) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (serviceJid != null) {
            hashMap.put("service-jid", serviceJid.toString());
        }
        if (nodeName != null) {
            hashMap.put(NODE_ATTR, nodeName);
            hashMap.put("userId", nodeName);
        } else {
            int n = this.c.incrementAndGet();
            hashMap.put("userId", String.valueOf(n));
        }
        return hashMap;
    }

    protected boolean isNodeConfigure(Element pubsubElem) {
        String string = pubsubElem.getName();
        return this.nodeConfigureElemNames.contains(string);
    }
}

