/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.BareJID;

public class NodeAffiliations
extends tigase.pubsub.repository.NodeAffiliations {
    protected final ThreadLocal<Map<BareJID, UsersAffiliation>> changedAffs = new ThreadLocal();

    public NodeAffiliations() {
    }

    public NodeAffiliations(tigase.pubsub.repository.NodeAffiliations nodeAffiliations) {
        this.affs.putAll(nodeAffiliations.getAffiliationsMap());
    }

    @Override
    public void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a2 = new UsersAffiliation(bareJid, affiliation);
        this.changedAffs().put(bareJid, a2);
    }

    @Override
    public void changeAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a2 = this.get(bareJid);
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        if (a2 != null) {
            a2.setAffiliation(affiliation);
            changedAffs.put(bareJid, a2);
        } else {
            a2 = new UsersAffiliation(bareJid, affiliation);
            changedAffs.put(bareJid, a2);
        }
    }

    @Override
    public NodeAffiliations clone() throws CloneNotSupportedException {
        NodeAffiliations clone = new NodeAffiliations();
        for (UsersAffiliation a2 : this.affs.values()) {
            clone.affs.put(a2.getJid(), a2.clone());
        }
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        Map<BareJID, UsersAffiliation> cloneChangedAffs = clone.changedAffs();
        for (UsersAffiliation a3 : changedAffs.values()) {
            cloneChangedAffs.put(a3.getJid(), a3.clone());
        }
        return clone;
    }

    @Override
    protected UsersAffiliation get(BareJID bareJid) {
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        UsersAffiliation us = changedAffs.get(bareJid);
        if (us == null && (us = (UsersAffiliation)this.affs.get(bareJid)) != null) {
            try {
                return us.clone();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return us;
    }

    @Override
    public UsersAffiliation[] getAffiliations() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.affs.values());
        result.addAll(this.changedAffs().values());
        return result.toArray(new UsersAffiliation[0]);
    }

    public Map<BareJID, UsersAffiliation> getChanged() {
        return this.changedAffs();
    }

    public void init(Queue<UsersAffiliation> data) {
        UsersAffiliation a2 = null;
        while ((a2 = data.poll()) != null) {
            this.affs.put(a2.getJid(), a2);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changedAffs().size() > 0;
    }

    public void merge() {
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        for (Map.Entry<BareJID, UsersAffiliation> entry : changedAffs.entrySet()) {
            if (entry.getValue().getAffiliation() == Affiliation.none) {
                this.affs.remove(entry.getKey());
                continue;
            }
            this.affs.put(entry.getKey(), entry.getValue());
        }
        changedAffs.clear();
    }

    @Override
    public void resetChangedFlag() {
        this.changedAffs().clear();
    }

    private Map<BareJID, UsersAffiliation> changedAffs() {
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs.get();
        if (changedAffs == null) {
            changedAffs = new HashMap<BareJID, UsersAffiliation>();
            this.changedAffs.set(changedAffs);
        }
        return changedAffs;
    }
}

