/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AdHocConfigCommandModule;
import tigase.pubsub.repository.IItems;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class DiscoverItemsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#items"));
    private final AdHocConfigCommandModule adHocCommandsModule;

    public DiscoverItemsModule(PubSubConfig config, PacketWriter packetWriter, AdHocConfigCommandModule adCommandModule) {
        super(config, packetWriter);
        this.adHocCommandsModule = adCommandModule;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            Element element = packet.getElement();
            Element query = element.getChild("query", "http://jabber.org/protocol/disco#items");
            String nodeName = query.getAttributeStaticStr("node");
            JID senderJid = packet.getStanzaFrom();
            JID toJid = packet.getStanzaTo();
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            if ("http://jabber.org/protocol/commands".equals(nodeName)) {
                List<Element> commandList = this.adHocCommandsModule.getCommandListItems(senderJid, toJid);
                if (commandList != null) {
                    for (Element item : commandList) {
                        resultQuery.addChild((XMLNodeIfc)item);
                    }
                }
            } else {
                AbstractNodeConfig nodeConfig;
                this.log.finest("Asking about Items of node " + nodeName);
                AbstractNodeConfig abstractNodeConfig = nodeConfig = nodeName == null ? null : this.getRepository().getNodeConfig(toJid.getBareJID(), nodeName);
                if (nodeName == null || nodeConfig != null && nodeConfig.getNodeType() == NodeType.collection) {
                    String[] nodes;
                    String parentName;
                    if (nodeName == null) {
                        parentName = "";
                        nodes = this.getRepository().getRootCollection(toJid.getBareJID());
                    } else {
                        parentName = nodeName;
                        nodes = nodeConfig.getChildren();
                    }
                    if (nodes != null) {
                        for (String node : nodes) {
                            AbstractNodeConfig childNodeConfig = this.getRepository().getNodeConfig(toJid.getBareJID(), node);
                            if (childNodeConfig == null) continue;
                            boolean allowed = senderJid == null || childNodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), childNodeConfig.getDomains());
                            String collection = childNodeConfig.getCollection();
                            if (allowed) {
                                String name = childNodeConfig.getTitle();
                                name = name == null || name.length() == 0 ? node : name;
                                Element item = new Element("item", new String[]{"jid", "node", "name"}, new String[]{element.getAttributeStaticStr("to"), node, name});
                                if (!parentName.equals(collection)) continue;
                                resultQuery.addChild((XMLNodeIfc)item);
                                continue;
                            }
                            this.log.fine("User " + senderJid + " not allowed to see node '" + node + "'");
                        }
                    }
                } else {
                    boolean allowed;
                    boolean bl = allowed = senderJid == null || nodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains());
                    if (!allowed) {
                        throw new PubSubException(Authorization.FORBIDDEN);
                    }
                    resultQuery.addAttribute("node", nodeName);
                    IItems items = this.getRepository().getNodeItems(toJid.getBareJID(), nodeName);
                    String[] itemsId = items.getItemsIds();
                    if (itemsId != null) {
                        for (String itemId : itemsId) {
                            resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{element.getAttributeStaticStr("to"), itemId}));
                        }
                    }
                }
            }
            this.packetWriter.write(resultIq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

