/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component2.exceptions.ComponentException;
import tigase.conf.ConfigurationException;
import tigase.licence.LicenceChecker;
import tigase.osgi.ModulesManagerImpl;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.cluster.PartitionedStrategy;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.modules.PresenceCollectorModuleClustered;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.CapsModule;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.XMPPServer;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class PubSubComponentClustered
extends PubSubComponent
implements ClusteredComponentIfc,
PubSubComponentClusteredIfc {
    private static final Logger a = Logger.getLogger(PubSubComponentClustered.class.getCanonicalName());
    private static final String b = "packet-forward-pubsub-cmd";
    private static final String c = "perm";
    private static final String d = PartitionedStrategy.class.getCanonicalName();
    private static final String e = "pubsub-strategy-class";
    private a f = new a();
    private ClusterControllerIfc g;
    private StrategyIfc h;
    private ComponentInfo i = null;
    private LicenceChecker j = LicenceChecker.getLicenceChecker((String)"acs");

    protected boolean addOutPacket(Packet packet) {
        if (!this.h.filterOutPacket(packet)) {
            return super.addOutPacket(packet);
        }
        return false;
    }

    @Override
    public PublishItemModule getPublishItemModule() {
        return this.publishNodeModule;
    }

    public void nodeConnected(String node) {
        JID jID = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        this.h.nodeConnected(jID);
    }

    public void nodeDisconnected(String node) {
        JID jID = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        this.h.nodeDisconnected(jID);
    }

    @Override
    public void processPacket(Packet packet) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Received packet: {0}", packet);
        }
        try {
            Serializable serializable;
            List<JID> list = this.h.getNodesForPacket(packet);
            boolean bl = list.contains(this.h.getLocalNodeJid());
            if (a.isLoggable(Level.FINEST)) {
                serializable = new StringBuilder();
                for (JID jID : list) {
                    if (((StringBuilder)serializable).length() > 0) {
                        ((StringBuilder)serializable).append(", ");
                    }
                    ((StringBuilder)serializable).append(jID.toString());
                }
                a.log(Level.FINEST, "packet, processLocally: {0}, will be processed by nodes: [{1}]", new Object[]{bl, ((StringBuilder)serializable).toString()});
            }
            if (bl) {
                if (list.size() == 1) {
                    list = null;
                } else {
                    list.remove(this.h.getLocalNodeJid());
                }
            }
            if (list != null) {
                serializable = new HashMap();
                if (packet.getPermissions() != null) {
                    serializable.put(c, packet.getPermissions().name());
                }
                this.g.sendToNodes(b, (Map)((Object)serializable), packet.getElement(), bl ? this.h.getLocalNodeJid() : packet.getPacketFrom(), null, list.toArray(new JID[list.size()]));
            }
            if (bl) {
                super.processPacket(packet);
                this.getPubSubRepository().clearRemoteNodes();
                this.h.packetProcessed();
            }
        }
        catch (PubSubException pubSubException) {
            this.sendException(packet, pubSubException);
        }
    }

    public ComponentInfo getComponentInfo() {
        this.i = super.getComponentInfo();
        this.i.getComponentData().put("PubSubClusteringStrategy", this.h != null ? this.h.getClass() : null);
        return this.i;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> map = super.getDefaults(params);
        map.put(e, d);
        return map;
    }

    @Override
    public String getDiscoDescription() {
        return super.getDiscoDescription() + " acs-clustered";
    }

    @Override
    public CachedPubSubRepositoryClustered getPubSubRepository() {
        return (CachedPubSubRepositoryClustered)this.pubsubRepository;
    }

    @Override
    protected void init() {
        if (!this.isRegistered(CapsModule.class)) {
            this.capsModule = this.registerModule(new CapsModule((PubSubConfig)this.componentConfig, this.getWriter()));
        }
        if (!this.isRegistered(PresenceCollectorModule.class)) {
            this.presenceCollectorModule = this.modulesManager.register(PresenceCollectorModule.class, new PresenceCollectorModuleClustered((PubSubConfig)this.componentConfig, this.getWriter(), this.capsModule), false);
        }
        ((PresenceCollectorModuleClustered)this.presenceCollectorModule).setStrategy(this.h);
        super.init();
    }

    @Override
    protected void sendException(Packet packet, ComponentException e) {
        if (this.h.sendException(packet, e)) {
            super.sendException(packet, e);
        }
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.g != null) {
            this.g.removeCommandListener((CommandListener)this.f);
        }
        this.g = cl_controller;
        this.g.setCommandListener((CommandListener)this.f);
        this.h.setClusterController(cl_controller);
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (props.size() > 1) {
            String string = (String)props.get(e);
            try {
                this.h = (StrategyIfc)ModulesManagerImpl.getInstance().forName(string).newInstance();
                this.h.setProperties(props);
                this.h.setConfig((PubSubConfig)this.componentConfig);
                this.h.setPubSubComponentClustered(this);
                if (this.g != null) {
                    this.h.setClusterController(this.g);
                }
            }
            catch (Exception exception) {
                if (!XMPPServer.isOSGi()) {
                    a.log(Level.SEVERE, "Cannot instance clustering strategy class: " + string, exception);
                }
                throw new ConfigurationException("Cannot instance clustering strategy class: " + string);
            }
        }
        super.setProperties(props);
    }

    @Override
    protected CachedPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        return new CachedPubSubRepositoryClustered(directRepository, this.maxRepositoryCacheSize, this.h);
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(PubSubComponentClustered.b);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            for (Element element : packets) {
                try {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "processing forwarded packet = {0}", element.toString());
                    }
                    Packet packet = Packet.packetInstance((Element)element);
                    packet.setPacketFrom(fromNode);
                    if (data != null && data.get(PubSubComponentClustered.c) != null) {
                        Permissions permissions = Permissions.valueOf((String)data.get(PubSubComponentClustered.c));
                        packet.setPermissions(permissions);
                    }
                    if (PubSubComponentClustered.super.addPacketNB(packet)) {
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "forwarded packet added to processing queue of component = {0}", element.toString());
                        continue;
                    }
                    a.log(Level.FINE, "forwarded packet dropped due to component queue overflow = {0}", element.toString());
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    a.log(Level.FINEST, "Addressing problem, stringprep failed for packet: {0}", element);
                }
                catch (Throwable throwable) {
                    a.log(Level.SEVERE, "Exception processing forwarded packet = " + element.toString(), throwable);
                }
            }
        }
    }
}

