/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class PepPlugin
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger(PepPlugin.class.getCanonicalName());
    protected static final String DISCO_INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    protected static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    protected static final String PUBSUB_XMLNS = "http://jabber.org/protocol/pubsub";
    private static final String ID = "pep";
    protected static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#owner"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#publish"}), new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "pep"})};
    protected static final String[][] ELEMENTS = new String[][]{Iq.IQ_PUBSUB_PATH, {"presence"}, Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH};
    protected static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/pubsub", "jabber:client", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/disco#info"};
    protected JID pubsubJid = null;
    protected boolean simplePepEnabled = false;
    protected final Set<String> simpleNodes = new HashSet<String>();

    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        this.simpleNodes.add("http://jabber.org/protocol/tune");
        this.simpleNodes.add("http://jabber.org/protocol/mood");
        this.simpleNodes.add("http://jabber.org/protocol/activity");
        this.simpleNodes.add("http://jabber.org/protocol/geoloc");
        this.simpleNodes.add("urn:xmpp:avatar:data");
        this.simpleNodes.add("urn:xmpp:avatar:metadata");
        String defHost = DNSResolver.getDefaultHostname();
        this.pubsubJid = JID.jidInstanceNS((String)"pubsub", (String)defHost, null);
        if (settings.containsKey("simplePepEnabled")) {
            this.simplePepEnabled = (Boolean)settings.get("simple-pep-enabled");
        }
    }

    public String id() {
        return ID;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (packet.getElemName() == "iq") {
            this.processIq(packet, session, results);
        }
        if (packet.getElemName() == "presence") {
            this.processPresence(packet, session, results);
        }
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    protected void processIq(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws XMPPException {
        Packet result;
        if (session != null && session.isServerSession()) {
            return;
        }
        Element pubsubEl = packet.getElement().findChildStaticStr(Iq.IQ_PUBSUB_PATH);
        if (pubsubEl != null && this.simplePepEnabled) {
            List children = pubsubEl.getChildren();
            boolean simple = false;
            for (Element child : children) {
                String node = child.getAttributeStaticStr("node");
                simple |= this.simpleNodes.contains(node);
            }
            if (simple) {
                return;
            }
        }
        if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
            if (pubsubEl != null && pubsubEl.getXMLNS() == PUBSUB_XMLNS) {
                XMPPResourceConnection con;
                result = null;
                if (session != null && (con = session.getParentSession().getResourceForResource(packet.getStanzaTo().getResource())) != null) {
                    result = packet.copyElementOnly();
                    result.setPacketTo(con.getConnectionId());
                    result.setPacketFrom(packet.getTo());
                }
                if (result == null) {
                    result = Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true);
                }
                results.offer(result);
            }
            return;
        }
        if (session != null && packet.getStanzaTo() != null && !session.isUserId(packet.getStanzaTo().getBareJID())) {
            results.offer(packet.copyElementOnly());
            return;
        }
        if (packet.getStanzaTo() == null) {
            if (pubsubEl == null || pubsubEl.getXMLNS() != PUBSUB_XMLNS) {
                log.log(Level.FINEST, "got <iq/> packet with no 'to' attribute = {0}", packet);
                return;
            }
        } else if (packet.getStanzaTo().getResource() == null && packet.getType() == StanzaType.error) {
            return;
        }
        result = packet.copyElementOnly();
        if (packet.getStanzaTo() == null && session != null) {
            JID userJid = JID.jidInstance((BareJID)session.getBareJID());
            result.initVars(packet.getStanzaFrom() != null ? packet.getStanzaFrom() : session.getJID(), userJid);
        }
        result.setPacketTo(this.pubsubJid);
        results.offer(result);
    }

    protected void processPresence(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (packet.getType() != null && packet.getType() != StanzaType.available && packet.getType() != StanzaType.unavailable) {
            return;
        }
        if (session == null || packet.getStanzaTo() == null || session.isUserId(packet.getStanzaTo().getBareJID()) && packet.getStanzaTo().getResource() == null) {
            Packet result = packet.copyElementOnly();
            if (packet.getStanzaTo() == null && session != null) {
                JID userJid = JID.jidInstance((BareJID)session.getBareJID());
                result.initVars(session.getJID(), userJid);
            }
            result.setPacketTo(this.pubsubJid);
            results.offer(result);
        }
    }
}

