/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.AbstractCriteria;
import tigase.archive.RSM;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class JDBCMessageArchiveRepository
extends AbstractMessageArchiveRepository<Criteria> {
    private static final String JIDS_ID = "jid_id";
    private static final String JIDS_JID = "jid";
    private static final String JIDS_TABLE = "tig_ma_jids";
    private static final Logger log = Logger.getLogger(JDBCMessageArchiveRepository.class.getCanonicalName());
    private static final long LONG_NULL = 0L;
    private static final long MILIS_PER_DAY = 86400000L;
    private static final String[] MSG_BODY_PATH = new String[]{"message", "body"};
    private static final String MSGS_ID = "msg_id";
    private static final String MSGS_BUDDY_ID = "buddy_id";
    private static final String MSGS_BODY = "body";
    private static final String MSGS_DIRECTION = "direction";
    private static final String MSGS_MSG = "msg";
    private static final String MSGS_OWNER_ID = "owner_id";
    private static final String MSGS_TABLE = "tig_ma_msgs";
    private static final String MSGS_TIMESTAMP = "ts";
    private static final String MSGS_TYPE = "type";
    private static final String TAGS_TABLE = "tig_ma_tags";
    private static final String TAGS_ID = "tag_id";
    private static final String TAGS_TAG = "tag";
    private static final String TAGS_OWNER_ID = "owner_id";
    private static final String MSGS_TAGS_TABLE = "tig_ma_msgs_tags";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final String GET_JID_IDS_QUERY = "select jid, jid_id from tig_ma_jids where jid = ? or jid = ?";
    private static final String GET_JID_ID_QUERY = "select jid, jid_id from tig_ma_jids where jid = ?";
    private static final String ADD_JID_QUERY = "insert into tig_ma_jids (jid) values (?)";
    private static final String DERBY_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint generated by default as identity not null, jid varchar(2049), primary key ( jid_id ));create unique index tig_ma_jids_jid on tig_ma_jids (jid);";
    private static final String PGSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigserial, jid varchar(2049), primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid);";
    private static final String SQLSERVER_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint identity(1,1), jid nvarchar(2049),jid_fragment as left (jid, 765),primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid_fragment );";
    private static final String MYSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint unsigned NOT NULL auto_increment, jid varchar(2049), primary key (jid_id)); ";
    private static final String GENERIC_GET_MESSAGES_START = "select m.msg, m.ts, m.direction from tig_ma_msgs m where m.owner_id = ? ";
    private static final String MSSQL2008_GET_MESSAGES_START = "select x.msg, x.ts, x.direction FROM ( select m.msg, m.ts, m.direction, ROW_NUMBER() over (order by m.ts) as rn from tig_ma_msgs m where m.owner_id = ? ";
    private static final String GENERIC_GET_MESSAGES_START_WITH = "select m.msg, m.ts, m.direction, b.jid from tig_ma_msgs m inner join tig_ma_jids b ON b.jid_id = m.buddy_id where m.owner_id = ? ";
    private static final String MSSQL2008_GET_MESSAGES_START_WITH = "select x.msg, x.ts, x.direction, b.jid FROM ( select m.msg, m.ts, m.direction, ROW_NUMBER() over (order by m.ts) as rn, m.buddy_id from tig_ma_msgs m where m.owner_id = ? ";
    private static final String MSSQL2008_GET_MESSAGES_END = ") x";
    private static final String MSSQL2008_GET_MESSAGES_END_WITH = ") x inner join tig_ma_jids b ON b.jid_id = x.buddy_id";
    private static final String GENERIC_GET_MESSAGES_END = "select msg, ts,direction from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? and ts <= ?";
    private static final String GENERIC_GET_MESSAGES_COUNT = "select count(m.ts) from tig_ma_msgs m where m.owner_id = ?";
    private static final String GENERIC_GET_MESSAGES_ORDER_BY = " order by ts";
    private static final String GENERIC_GET_COLLECTIONS_SELECT = "select min(m.ts) as ts, j.jid from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT = "select x.ts, x.jid from ( select min(m.ts) as ts, j.jid, ROW_NUMBER() over (order by min(m.ts), j.jid) as rn from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String GENERIC_GET_COLLECTIONS_SELECT_GROUP = " group by date(m.ts), m.buddy_id, j.jid";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT_GROUP = " group by cast(m.ts as date), m.buddy_id, j.jid) x ";
    private static final String GENERIC_GET_COLLECTIONS_SELECT_ORDER = " order by min(m.ts), j.jid";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT_ORDER = " order by x.ts, x.jid";
    private static final String GENERIC_GET_COLLECTIONS_COUNT = "select count(1) from (select min(m.ts) as ts, m.buddy_id from tig_ma_msgs m where m.owner_id = ? ";
    private static final String GENERIC_GET_COLLECTIONS_COUNT_GROUP = "group by date(m.ts), m.buddy_id) x";
    private static final String MSSQL2008_GET_COLLECTIONS_COUNT_GROUP = "group by cast(m.ts as date), m.buddy_id) x";
    private static final String GENERIC_LIMIT = " limit ? offset ?";
    private static final String DERBY_LIMIT = " offset ? rows fetch next ? rows only";
    private static final String MSSQL2008_LIMIT = " where x.rn > ? and x.rn <= ?";
    private static final String DERBY_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigint generated by default as identity not null, tag varchar(255), owner_id bigint references  tig_ma_jids(jid_id) on delete cascade, primary key ( tag_id ));create index tig_ma_tags_owner_id on tig_ma_tags (owner_id);create unique index tig_ma_tags_tag_owner_id on tig_ma_tags ( owner_id,tag);";
    private static final String PGSQL_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigserial, tag varchar(255), owner_id bigint not null,\tprimary key (tag_id), foreign key (owner_id) references tig_ma_jids (jid_id) on delete cascade ); create index tig_ma_tags_owner_id on tig_ma_tags (owner_id);create unique index tig_ma_tags_tag_owner_id on tig_ma_tags ( owner_id,tag);";
    private static final String SQLSERVER_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigint identity(1,1), tag nvarchar(255),owner_id bigint not null,primary key (tag_id), foreign key (owner_id) references tig_ma_jids(jid_id) on delete cascade ); create index tig_ma_tags_owner_id on tig_ma_tags (owner_id);create unique index tig_ma_tags_tag_owner_id on tig_ma_tags ( owner_id,tag);";
    private static final String MYSQL_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigint unsigned NOT NULL auto_increment, tag varchar(255), owner_id bigint unsigned not null,  primary key (tag_id), foreign key (owner_id) references tig_ma_jids(jid_id) on delete cascade, key tig_ma_tags_owner_id ( owner_id ),  unique key tig_ma_tags_tag_owner_id ( owner_id,tag ) ); ";
    private static final String DERBY_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint not null references tig_ma_msgs(msg_id) on delete cascade, tag_id bigint not null references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);";
    private static final String PGSQL_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);";
    private static final String SQLSERVER_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);";
    private static final String MYSQL_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint unsigned not null, tag_id bigint unsigned not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade,  key tig_ma_msgs_tags_msg_id (msg_id),  key tig_ma_msgs_tags_tag_id (tag_id) );";
    private static final String[][] GET_COLLECTIONS_WHERES = new String[][]{{"FROM", " and m.ts >= ? "}, {"TO", " and m.ts <= ? "}, {"WITH", " and m.buddy_id = ? "}};
    private static final String[] GET_COLLECTIONS_COMBINATIONS = new String[]{"", "FROM", "FROM_TO", "FROM_TO_WITH", "FROM_WITH", "TO", "TO_WITH", "WITH"};
    private static final String ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, ts, direction, type, body, msg) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String REMOVE_MSGS = "delete from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts <= ? and ts >= ?";
    private static final String DERBY_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigint generated by default as identity not null PRIMARY KEY,owner_id bigint references tig_ma_jids(jid_id),buddy_id bigint references tig_ma_jids(jid_id),ts timestamp, direction smallint, type varchar(10), body varchar(32672), msg varchar(32672));create index tig_ma_msgs_owner_id_index on tig_ma_msgs (owner_id);create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs (owner_id, buddy_id);create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs (owner_id, ts, buddy_id);";
    private static final String PGSQL_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigserial, owner_id bigint, buddy_id bigint, ts timestamp, direction smallint, type varchar(10), body text, msg text, primary key (msg_id), foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); ";
    private static final String SQLSERVER_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigint IDENTITY(1,1) NOT NULL, owner_id bigint, buddy_id bigint, ts datetime, direction smallint, type nvarchar(10),body ntext, msg ntext, primary key (msg_id), foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); ";
    private static final String MYSQL_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigint unsigned NOT NULL auto_increment, owner_id bigint unsigned, buddy_id bigint unsigned, ts timestamp, direction smallint, type varchar(10),body text, msg text, primary key (msg_id),  foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id), key (owner_id), key (owner_id, buddy_id), key (owner_id, ts, buddy_id));";
    private static final String ADD_TAG = "insert into tig_ma_tags (owner_id, tag) values (?,?)";
    private static final String ADD_MESSAGE_TAG = "insert into tig_ma_msgs_tags (msg_id, tag_id) values (?,?)";
    private static final String GET_TAG_IDS = "select tag_id, tag from tig_ma_tags WHERE owner_id = ? AND ( ";
    private static final String GET_TAG_IDS_WHERE_PART = "tag = ? ";
    private static final String GET_TAG_IDS_END = " )";
    private static final String GET_TAGS_FOR_USER = "select t.tag from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ";
    private static final String GET_TAGS_FOR_USER_COUNT = "select count(t.tag_id) from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ";
    private static final String GET_TAGS_FOR_USER_ORDER = " order by tag";
    private static final String SQLSERVER_GET_TAGS_FOR_USER = "select x.tag from ( select t.tag, ROW_NUMBER() over (order by t.tag) as rn from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ) x ";
    private static final String STORE_PLAINTEXT_BODY_KEY = "store-plaintext-body";
    private DataRepository data_repo = null;
    private boolean storePlaintextBody = true;

    public void initRepository(String conn_str, Map<String, String> params) throws DBInitException {
        try {
            StringBuilder count;
            this.data_repo = RepositoryFactory.getDataRepository(null, (String)conn_str, params);
            this.storePlaintextBody = params.containsKey(STORE_PLAINTEXT_BODY_KEY) ? Boolean.parseBoolean(params.get(STORE_PLAINTEXT_BODY_KEY)) : true;
            switch (this.data_repo.getDatabaseType()) {
                case mysql: {
                    this.data_repo.checkTable(JIDS_TABLE, MYSQL_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, MYSQL_CREATE_MSGS);
                    break;
                }
                case derby: {
                    this.data_repo.checkTable(JIDS_TABLE, DERBY_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, DERBY_CREATE_MSGS);
                    break;
                }
                case postgresql: {
                    this.data_repo.checkTable(JIDS_TABLE, PGSQL_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, PGSQL_CREATE_MSGS);
                    break;
                }
                case jtds: 
                case sqlserver: {
                    this.data_repo.checkTable(JIDS_TABLE, SQLSERVER_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, SQLSERVER_CREATE_MSGS);
                }
            }
            this.checkDB();
            switch (this.data_repo.getDatabaseType()) {
                case mysql: {
                    this.data_repo.checkTable(TAGS_TABLE, MYSQL_CREATE_TAGS);
                    this.data_repo.checkTable(MSGS_TAGS_TABLE, MYSQL_CREATE_MSGS_TAGS);
                    break;
                }
                case derby: {
                    this.data_repo.checkTable(TAGS_TABLE, DERBY_CREATE_TAGS);
                    this.data_repo.checkTable(MSGS_TAGS_TABLE, DERBY_CREATE_MSGS_TAGS);
                    break;
                }
                case postgresql: {
                    this.data_repo.checkTable(TAGS_TABLE, PGSQL_CREATE_TAGS);
                    this.data_repo.checkTable(MSGS_TAGS_TABLE, "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);");
                    break;
                }
                case jtds: 
                case sqlserver: {
                    this.data_repo.checkTable(TAGS_TABLE, SQLSERVER_CREATE_TAGS);
                    this.data_repo.checkTable(MSGS_TAGS_TABLE, "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);");
                }
            }
            this.data_repo.initPreparedStatement(ADD_JID_QUERY, ADD_JID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_ID_QUERY, GET_JID_ID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_IDS_QUERY, GET_JID_IDS_QUERY);
            this.data_repo.initPreparedStatement(ADD_MESSAGE, ADD_MESSAGE, 1);
            HashMap<String, String> combinations = new HashMap<String, String>();
            for (String combination : GET_COLLECTIONS_COMBINATIONS) {
                StringBuilder sbMain = new StringBuilder();
                if (!combination.isEmpty()) {
                    String[] whereParts;
                    for (String part : whereParts = combination.split("_")) {
                        for (String[] where : GET_COLLECTIONS_WHERES) {
                            if (!part.equals(where[0])) continue;
                            sbMain.append(where[1]);
                        }
                    }
                }
                for (int j = 0; j < 6; ++j) {
                    StringBuilder combinationSb1 = new StringBuilder().append(combination);
                    StringBuilder querySb1 = new StringBuilder().append((CharSequence)sbMain);
                    if (j > 0) {
                        if (combinationSb1.length() > 0) {
                            combinationSb1.append("_");
                        }
                        combinationSb1.append("TAGS[").append(j).append("]");
                        querySb1.append(" and EXISTS( select 1 from ").append(TAGS_TABLE).append(" t inner join ").append(MSGS_TAGS_TABLE).append(" tm on t.").append(TAGS_ID).append(" = tm.").append(TAGS_ID).append(" where m.").append(MSGS_ID).append(" = tm.").append(MSGS_ID).append(" and (");
                        for (int x = 0; x < j; ++x) {
                            if (x > 0) {
                                querySb1.append(" or ");
                            }
                            querySb1.append("t.").append(TAGS_TAG).append(" = ?");
                        }
                        querySb1.append(" )) ");
                    }
                    for (int i = 0; i < 6; ++i) {
                        StringBuilder combinationSb = new StringBuilder().append((CharSequence)combinationSb1);
                        StringBuilder querySb = new StringBuilder().append((CharSequence)querySb1);
                        if (i > 0) {
                            if (combinationSb.length() > 0) {
                                combinationSb.append("_");
                            }
                            combinationSb.append("CONTAINS[").append(i).append("]");
                            for (int x = 0; x < i; ++x) {
                                querySb.append(" and m.").append(MSGS_BODY).append(" like ? ");
                            }
                        }
                        combinations.put(combinationSb.toString(), querySb.toString());
                    }
                }
            }
            for (Map.Entry entry : combinations.entrySet()) {
                StringBuilder select = new StringBuilder();
                count = new StringBuilder().append(GENERIC_GET_COLLECTIONS_COUNT);
                switch (this.data_repo.getDatabaseType()) {
                    case jtds: 
                    case sqlserver: {
                        select.append(MSSQL2008_GET_COLLECTIONS_SELECT);
                        break;
                    }
                    default: {
                        select.append(GENERIC_GET_COLLECTIONS_SELECT);
                    }
                }
                select.append((String)entry.getValue());
                count.append((String)entry.getValue());
                switch (this.data_repo.getDatabaseType()) {
                    case jtds: 
                    case sqlserver: {
                        select.append(MSSQL2008_GET_COLLECTIONS_SELECT_GROUP);
                        count.append(MSSQL2008_GET_COLLECTIONS_COUNT_GROUP);
                        break;
                    }
                    default: {
                        select.append(" group by date(m.ts), m.buddy_id, j.jid order by min(m.ts), j.jid");
                        count.append(GENERIC_GET_COLLECTIONS_COUNT_GROUP);
                    }
                }
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        select.append(DERBY_LIMIT);
                        break;
                    }
                    case jtds: 
                    case sqlserver: {
                        select.append(MSSQL2008_LIMIT).append(MSSQL2008_GET_COLLECTIONS_SELECT_ORDER);
                        break;
                    }
                    default: {
                        select.append(GENERIC_LIMIT);
                    }
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "prepared collection select query for " + (String)entry.getKey() + " as '" + select.toString() + "'");
                    log.log(Level.FINEST, "prepared collection count query for " + (String)entry.getKey() + " as '" + count.toString() + "'");
                }
                this.data_repo.initPreparedStatement("GET_COLLECTIONS_" + (String)entry.getKey() + "_SELECT", select.toString());
                this.data_repo.initPreparedStatement("GET_COLLECTIONS_" + (String)entry.getKey() + "_COUNT", count.toString());
            }
            for (Map.Entry entry : combinations.entrySet()) {
                StringBuilder select = new StringBuilder();
                count = new StringBuilder().append(GENERIC_GET_MESSAGES_COUNT);
                boolean containsWith = ((String)entry.getKey()).contains("WITH");
                switch (this.data_repo.getDatabaseType()) {
                    case jtds: 
                    case sqlserver: {
                        if (containsWith) {
                            select.append(MSSQL2008_GET_MESSAGES_START);
                            break;
                        }
                        select.append(MSSQL2008_GET_MESSAGES_START_WITH);
                        break;
                    }
                    default: {
                        if (containsWith) {
                            select.append(GENERIC_GET_MESSAGES_START);
                            break;
                        }
                        select.append(GENERIC_GET_MESSAGES_START_WITH);
                    }
                }
                select.append((String)entry.getValue());
                count.append((String)entry.getValue());
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        select.append(GENERIC_GET_MESSAGES_ORDER_BY).append(DERBY_LIMIT);
                        break;
                    }
                    case jtds: 
                    case sqlserver: {
                        if (containsWith) {
                            select.append(MSSQL2008_GET_MESSAGES_END);
                        } else {
                            select.append(MSSQL2008_GET_MESSAGES_END_WITH);
                        }
                        select.append(MSSQL2008_LIMIT).append(GENERIC_GET_MESSAGES_ORDER_BY);
                        break;
                    }
                    default: {
                        select.append(GENERIC_GET_MESSAGES_ORDER_BY).append(GENERIC_LIMIT);
                    }
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "prepared messages select query for " + (String)entry.getKey() + " as '" + select.toString() + "'");
                    log.log(Level.FINEST, "prepared messages count query for " + (String)entry.getKey() + " as '" + count.toString() + "'");
                }
                this.data_repo.initPreparedStatement("GET_MESSAGES_" + (String)entry.getKey() + "_SELECT", select.toString());
                this.data_repo.initPreparedStatement("GET_MESSAGES_" + (String)entry.getKey() + "_COUNT", count.toString());
            }
            this.data_repo.initPreparedStatement(REMOVE_MSGS, REMOVE_MSGS);
            for (int i = 0; i <= 5; ++i) {
                StringBuilder select = new StringBuilder().append(GET_TAG_IDS);
                for (int j = 1; j <= i; ++j) {
                    if (j > 1) {
                        select.append(" or ");
                    }
                    select.append(GET_TAG_IDS_WHERE_PART);
                }
                if (i == 0) {
                    select.append("1=1");
                }
                select.append(")");
                this.data_repo.initPreparedStatement("select tag_id, tag from tig_ma_tags WHERE owner_id = ? AND ( _" + i, select.toString());
            }
            this.data_repo.initPreparedStatement(ADD_TAG, ADD_TAG, 1);
            this.data_repo.initPreparedStatement(ADD_MESSAGE_TAG, ADD_MESSAGE_TAG);
            this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER_COUNT, GET_TAGS_FOR_USER_COUNT);
            switch (this.data_repo.getDatabaseType()) {
                case derby: {
                    this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER, "select t.tag from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ?  order by tag offset ? rows fetch next ? rows only");
                    break;
                }
                case jtds: 
                case sqlserver: {
                    this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER, "select x.tag from ( select t.tag, ROW_NUMBER() over (order by t.tag) as rn from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ) x  where x.rn > ? and x.rn <= ? order by tag");
                    break;
                }
                default: {
                    this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER, "select t.tag from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ?  order by tag limit ? offset ?");
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "MessageArchiveDB initialization exception", ex);
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDB() {
        Statement stmt = null;
        try {
            String alterTable;
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select body from tig_ma_msgs where owner_id = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        alterTable = "alter table tig_ma_msgs add body varchar(32672)";
                        break;
                    }
                    case mysql: {
                        alterTable = "alter table tig_ma_msgs add body text";
                        break;
                    }
                    case postgresql: {
                        alterTable = "alter table tig_ma_msgs add body text";
                        break;
                    }
                    case jtds: 
                    case sqlserver: {
                        alterTable = "alter table tig_ma_msgs add body ntext";
                    }
                }
                try {
                    stmt.execute(alterTable);
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select msg_id from tig_ma_msgs where owner_id = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                try {
                    switch (this.data_repo.getDatabaseType()) {
                        case derby: {
                            alterTable = "alter table tig_ma_msgs add msg_id bigint generated by default as identity not null";
                            stmt.execute(alterTable);
                            alterTable = "alter table tig_ma_msgs add primary key (msg_id)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case mysql: {
                            alterTable = "alter table tig_ma_msgs add msg_id bigint unsigned NOT NULL auto_increment, add primary key (msg_id)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case postgresql: {
                            alterTable = "alter table tig_ma_msgs add msg_id serial";
                            stmt.execute(alterTable);
                            alterTable = "alter table tig_ma_msgs add primary key (msg_id)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case jtds: 
                        case sqlserver: {
                            alterTable = "alter table tig_ma_msgs add msg_id bigint identity(1,1)";
                            stmt.execute(alterTable);
                            alterTable = "alter table tig_ma_msgs add primary key (msg_id)";
                            stmt.execute(alterTable);
                        }
                    }
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
        }
        finally {
            this.data_repo.release(stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveMessage(BareJID owner, BareJID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags) {
        ResultSet rs = null;
        try {
            String owner_str = owner.toString();
            String buddy_str = buddy.toString();
            long[] jids_ids = this.getJidsIds(owner_str, buddy_str);
            long owner_id = jids_ids[0] != 0L ? jids_ids[0] : this.addJidId(owner_str);
            long buddy_id = jids_ids[1] != 0L ? jids_ids[1] : this.addJidId(buddy_str);
            Timestamp mtime = new Timestamp(timestamp.getTime());
            msg.addAttribute("time", String.valueOf(mtime.getTime()));
            String type = msg.getAttributeStaticStr(MSGS_TYPE);
            String msgStr = msg.toString();
            String body = this.storePlaintextBody ? msg.getChildCData(MSG_BODY_PATH) : null;
            PreparedStatement add_message_st = this.data_repo.getPreparedStatement(owner, ADD_MESSAGE);
            Long msgId = null;
            PreparedStatement preparedStatement = add_message_st;
            synchronized (preparedStatement) {
                add_message_st.setLong(1, owner_id);
                add_message_st.setLong(2, buddy_id);
                add_message_st.setTimestamp(3, mtime);
                add_message_st.setShort(4, direction.getValue());
                add_message_st.setString(5, type);
                add_message_st.setString(6, body);
                add_message_st.setString(7, msgStr);
                add_message_st.executeUpdate();
                if (tags != null && (rs = add_message_st.getGeneratedKeys()).next()) {
                    switch (this.data_repo.getDatabaseType()) {
                        case postgresql: {
                            msgId = rs.getLong(MSGS_ID);
                            break;
                        }
                        default: {
                            msgId = rs.getLong(1);
                        }
                    }
                }
            }
            if (tags != null && !tags.isEmpty()) {
                PreparedStatement add_message_tag_st;
                Map<String, Long> tagsMap = this.ensureTags(owner, owner_id, tags);
                PreparedStatement preparedStatement2 = add_message_tag_st = this.data_repo.getPreparedStatement(owner, ADD_MESSAGE_TAG);
                synchronized (preparedStatement2) {
                    for (Long tagId : tagsMap.values()) {
                        add_message_tag_st.setLong(1, msgId);
                        add_message_tag_st.setLong(2, tagId);
                        add_message_tag_st.addBatch();
                    }
                    add_message_tag_st.executeBatch();
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: " + msg, ex);
        }
        finally {
            this.data_repo.release(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> ensureTags(BareJID owner, long owner_id, Set<String> tags) throws SQLException {
        HashMap<String, Long> tagsMap = new HashMap<String, Long>();
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement;
            Iterator<String> it = tags.iterator();
            int iters = tags.size() / 5 + 1;
            for (int i = 0; i < iters; ++i) {
                PreparedStatement get_tag_ids_st;
                int params = i == iters - 1 ? tags.size() % 5 : 5;
                preparedStatement = get_tag_ids_st = this.data_repo.getPreparedStatement(owner, "select tag_id, tag from tig_ma_tags WHERE owner_id = ? AND ( _" + params);
                synchronized (preparedStatement) {
                    get_tag_ids_st.setLong(1, owner_id);
                    for (int j = 0; j < params; ++j) {
                        String tag = it.next();
                        get_tag_ids_st.setString(j + 2, tag);
                    }
                    rs = get_tag_ids_st.executeQuery();
                    while (rs.next()) {
                        long id = rs.getLong(1);
                        String tag = rs.getString(2);
                        tagsMap.put(tag, id);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                    continue;
                }
            }
            if (tagsMap.size() >= tags.size()) return tagsMap;
            PreparedStatement add_tag_st = this.data_repo.getPreparedStatement(owner, ADD_TAG);
            for (String tag : tags) {
                if (tagsMap.containsKey(tag)) continue;
                preparedStatement = add_tag_st;
                synchronized (preparedStatement) {
                    add_tag_st.setLong(1, owner_id);
                    add_tag_st.setString(2, tag);
                    add_tag_st.executeUpdate();
                    rs = add_tag_st.getGeneratedKeys();
                    if (rs.next()) {
                        tagsMap.put(tag, rs.getLong(1));
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
            }
            return tagsMap;
        }
        finally {
            this.data_repo.release(null, rs);
        }
    }

    @Override
    public List<Element> getCollections(BareJID owner, Criteria crit) throws TigaseDBException {
        try {
            Integer count;
            long[] jids_ids = crit.getWith() == null ? this.getJidsIds(owner.toString()) : this.getJidsIds(owner.toString(), crit.getWith());
            crit.setOwnerId(jids_ids[0]);
            if (jids_ids.length > 1) {
                crit.setBuddyId(jids_ids[1]);
            }
            if ((count = this.getCollectionsCount(owner, crit)) == null) {
                count = 0;
            }
            crit.setSize(count);
            List<Element> results = this.getCollectionsItems(owner, crit);
            RSM rsm = crit.getRSM();
            rsm.setResults(count, crit.getOffset());
            if (!results.isEmpty()) {
                rsm.setFirst(String.valueOf(crit.getOffset()));
                rsm.setLast(String.valueOf(crit.getOffset() + (results.size() - 1)));
            }
            return results;
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve collections", (Throwable)ex);
        }
    }

    @Override
    public List<Element> getItems(BareJID owner, Criteria crit) throws TigaseDBException {
        try {
            Integer count;
            long[] jids_ids = crit.getWith() != null ? this.getJidsIds(owner.toString(), crit.getWith()) : this.getJidsIds(owner.toString());
            crit.setOwnerId(jids_ids[0]);
            if (jids_ids.length > 1) {
                crit.setBuddyId(jids_ids[1]);
            }
            if ((count = this.getItemsCount(owner, crit)) == null) {
                count = 0;
            }
            crit.setSize(count);
            List<Element> items = this.getItemsItems(owner, crit);
            RSM rsm = crit.getRSM();
            rsm.setResults(count, crit.getOffset());
            if (items != null && !items.isEmpty()) {
                rsm.setFirst(String.valueOf(crit.getOffset()));
                rsm.setLast(String.valueOf(crit.getOffset() + (items.size() - 1)));
            }
            return items;
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItems(BareJID owner, String withJid, Date start, Date end) throws TigaseDBException {
        try {
            PreparedStatement remove_msgs_st;
            long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
            if (start == null) {
                start = new Date(0L);
            }
            if (end == null) {
                end = new Date(0L);
            }
            Timestamp start_ = new Timestamp(start.getTime());
            Timestamp end_ = new Timestamp(end.getTime());
            PreparedStatement preparedStatement = remove_msgs_st = this.data_repo.getPreparedStatement(owner, REMOVE_MSGS);
            synchronized (preparedStatement) {
                PreparedStatement preparedStatement2 = remove_msgs_st;
                synchronized (preparedStatement2) {
                    remove_msgs_st.setLong(1, jids_ids[0]);
                    remove_msgs_st.setLong(2, jids_ids[1]);
                    remove_msgs_st.setTimestamp(3, end_);
                    remove_msgs_st.setTimestamp(4, start_);
                    remove_msgs_st.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not remove items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTags(BareJID owner, String startsWith, Criteria crit) throws TigaseDBException {
        ArrayList<String> results = new ArrayList<String>();
        ResultSet rs = null;
        try {
            PreparedStatement get_tags_st;
            PreparedStatement get_tags_count_st;
            int count = 0;
            startsWith = startsWith + "%";
            PreparedStatement preparedStatement = get_tags_count_st = this.data_repo.getPreparedStatement(owner, GET_TAGS_FOR_USER_COUNT);
            synchronized (preparedStatement) {
                get_tags_count_st.setString(1, owner.toString());
                get_tags_count_st.setString(2, startsWith);
                rs = get_tags_count_st.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                this.data_repo.release(null, rs);
            }
            crit.setSize(count);
            PreparedStatement preparedStatement2 = get_tags_st = this.data_repo.getPreparedStatement(owner, GET_TAGS_FOR_USER);
            synchronized (preparedStatement2) {
                int i = 1;
                get_tags_st.setString(i++, owner.toString());
                get_tags_st.setString(i++, startsWith);
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        get_tags_st.setInt(i++, crit.getOffset());
                        get_tags_st.setInt(i++, crit.getLimit());
                        break;
                    }
                    case jtds: 
                    case sqlserver: {
                        get_tags_st.setInt(i++, crit.getOffset());
                        get_tags_st.setInt(i++, crit.getOffset() + crit.getLimit());
                        break;
                    }
                    default: {
                        get_tags_st.setInt(i++, crit.getLimit());
                        get_tags_st.setInt(i++, crit.getOffset());
                    }
                }
                rs = get_tags_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
            }
            RSM rsm = crit.getRSM();
            rsm.setResults(count, crit.getOffset());
            if (results != null && !results.isEmpty()) {
                rsm.setFirst(String.valueOf(crit.getOffset()));
                rsm.setLast(String.valueOf(crit.getOffset() + (results.size() - 1)));
            }
        }
        catch (SQLException ex) {
            try {
                throw new TigaseDBException("Could not retrieve known tags from database", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> getCollectionsItems(BareJID owner, Criteria crit) throws SQLException {
        LinkedList<Element> results = new LinkedList<Element>();
        ResultSet selectRs = null;
        try {
            PreparedStatement get_collections_st = this.data_repo.getPreparedStatement(owner, "GET_COLLECTIONS_" + crit.getQueryName() + "_SELECT");
            int i = 2;
            PreparedStatement preparedStatement = get_collections_st;
            synchronized (preparedStatement) {
                crit.setItemsQueryParams(get_collections_st, this.data_repo.getDatabaseType());
                selectRs = get_collections_st.executeQuery();
                while (selectRs.next()) {
                    Timestamp startTs = selectRs.getTimestamp(1);
                    String with = selectRs.getString(2);
                    this.addCollectionToResults(results, with, startTs);
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, selectRs);
            throw throwable;
        }
        this.data_repo.release(null, selectRs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCollectionsCount(BareJID owner, Criteria crit) throws SQLException {
        ResultSet countRs = null;
        Integer count = null;
        try {
            PreparedStatement get_collections_count = this.data_repo.getPreparedStatement(owner, "GET_COLLECTIONS_" + crit.getQueryName() + "_COUNT");
            int i = 2;
            PreparedStatement preparedStatement = get_collections_count;
            synchronized (preparedStatement) {
                crit.setCountQueryParams(get_collections_count, this.data_repo.getDatabaseType());
                countRs = get_collections_count.executeQuery();
                if (countRs.next()) {
                    count = countRs.getInt(1);
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, countRs);
            throw throwable;
        }
        this.data_repo.release(null, countRs);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> getItemsItems(BareJID owner, Criteria crit) throws SQLException {
        Item item;
        ResultSet rs = null;
        ArrayDeque<Item> results = new ArrayDeque<Item>();
        boolean i = true;
        try {
            PreparedStatement get_messages_st;
            boolean containsWith = crit.getQueryName().contains("WITH");
            PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, "GET_MESSAGES_" + crit.getQueryName() + "_SELECT");
            synchronized (preparedStatement) {
                crit.setItemsQueryParams(get_messages_st, this.data_repo.getDatabaseType());
                rs = get_messages_st.executeQuery();
                while (rs.next()) {
                    item = new Item();
                    item.message = rs.getString(1);
                    item.timestamp = rs.getTimestamp(2);
                    item.direction = MessageArchiveRepository.Direction.getDirection(rs.getShort(3));
                    if (!containsWith) {
                        item.with = rs.getString(4);
                    }
                    results.offer(item);
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        LinkedList<Element> msgs = new LinkedList<Element>();
        if (!results.isEmpty()) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            Object startTimestamp = crit.getStart();
            item = null;
            while ((item = (Item)results.poll()) != null) {
                if (startTimestamp == null) {
                    startTimestamp = item.timestamp;
                }
                parser.parse((SimpleHandler)domHandler, item.message.toCharArray(), 0, item.message.length());
                Queue queue = domHandler.getParsedElements();
                Element msg = null;
                while ((msg = (Element)queue.poll()) != null) {
                    this.addMessageToResults((List<Element>)msgs, (Date)startTimestamp, msg, item.timestamp, item.direction, item.with);
                }
            }
            crit.setStart((Date)startTimestamp);
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getItemsCount(BareJID owner, Criteria crit) throws SQLException {
        ResultSet rs = null;
        Integer count = null;
        try {
            PreparedStatement get_messages_st;
            PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, "GET_MESSAGES_" + crit.getQueryName() + "_COUNT");
            synchronized (preparedStatement) {
                crit.setCountQueryParams(get_messages_st, this.data_repo.getDatabaseType());
                rs = get_messages_st.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected long[] getJidsIds(String ... jids) throws SQLException {
        long[] lArray;
        long[] results;
        ResultSet rs;
        block13: {
            Object object;
            block14: {
                rs = null;
                results = new long[jids.length];
                Arrays.fill(results, 0L);
                if (jids.length != 1) break block13;
                PreparedStatement get_jid_id_st = this.data_repo.getPreparedStatement(null, GET_JID_ID_QUERY);
                object = get_jid_id_st;
                // MONITORENTER : object
                get_jid_id_st.setString(1, jids[0]);
                rs = get_jid_id_st.executeQuery();
                if (!rs.next()) break block14;
                results[0] = rs.getLong(JIDS_ID);
                long[] lArray2 = results;
                // MONITOREXIT : object
                this.data_repo.release(null, rs);
                return lArray2;
            }
            // MONITOREXIT : object
            object = results;
            this.data_repo.release(null, rs);
            return object;
        }
        try {
            PreparedStatement get_jids_id_st;
            PreparedStatement preparedStatement = get_jids_id_st = this.data_repo.getPreparedStatement(null, GET_JID_IDS_QUERY);
            // MONITORENTER : preparedStatement
            for (int i = 0; i < jids.length; ++i) {
                get_jids_id_st.setString(i + 1, jids[i]);
            }
            rs = get_jids_id_st.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                String db_jid = rs.getString(JIDS_JID);
                for (int i = 0; i < jids.length; ++i) {
                    if (!db_jid.equals(jids[i])) continue;
                    results[i] = rs.getLong(JIDS_ID);
                    ++cnt;
                }
            }
            lArray = results;
            // MONITOREXIT : preparedStatement
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addJidId(String jid) throws SQLException {
        PreparedStatement add_jid_st = this.data_repo.getPreparedStatement(null, ADD_JID_QUERY);
        try {
            PreparedStatement preparedStatement = add_jid_st;
            synchronized (preparedStatement) {
                add_jid_st.setString(1, jid);
                add_jid_st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            log.log(Level.FINEST, "Exception adding jid to tig_ma_jids table, it may occur if other thread added this jid in the meantime", ex);
        }
        long[] jid_ids = this.getJidsIds(jid);
        if (jid_ids != null) {
            return jid_ids[0];
        }
        log.log(Level.WARNING, "I have just added new jid but it was not found.... {0}", jid);
        return 0L;
    }

    @Override
    public AbstractCriteria newCriteriaInstance() {
        return new Criteria();
    }

    public static class Criteria
    extends AbstractCriteria<Timestamp> {
        private long ownerId;
        private long buddyId;
        private String queryName;

        @Override
        protected Timestamp convertTimestamp(Date date) {
            if (date == null) {
                return null;
            }
            return new Timestamp(date.getTime());
        }

        public String getQueryName() {
            if (this.queryName == null) {
                return this.updateQueryName();
            }
            return this.queryName;
        }

        public String updateQueryName() {
            StringBuilder query = new StringBuilder(20);
            if (this.getStart() != null) {
                query.append("FROM");
            }
            if (this.getEnd() != null) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("TO");
            }
            if (this.getWith() != null) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("WITH");
            }
            if (!this.getTags().isEmpty()) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("TAGS[").append(this.getTags().size()).append("]");
            }
            if (!this.getContains().isEmpty()) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("CONTAINS[").append(this.getContains().size()).append("]");
            }
            this.queryName = query.toString();
            return this.queryName;
        }

        public void setOwnerId(Long id) {
            this.ownerId = id == null ? 0L : id;
        }

        public void setBuddyId(Long id) {
            this.buddyId = id == null ? 0L : id;
        }

        public int setCountQueryParams(PreparedStatement stmt, DataRepository.dbTypes dbType) throws SQLException {
            int i = 1;
            stmt.setLong(i++, this.ownerId);
            if (this.getStart() != null) {
                stmt.setTimestamp(i++, (Timestamp)this.getStart());
            }
            if (this.getEnd() != null) {
                stmt.setTimestamp(i++, (Timestamp)this.getEnd());
            }
            if (this.getWith() != null) {
                stmt.setLong(i++, this.buddyId);
            }
            for (String tag : this.getTags()) {
                stmt.setString(i++, tag);
            }
            for (String contains : this.getContains()) {
                stmt.setString(i++, "%" + contains + "%");
            }
            return i;
        }

        public void setItemsQueryParams(PreparedStatement stmt, DataRepository.dbTypes dbType) throws SQLException {
            int i = this.setCountQueryParams(stmt, dbType);
            switch (dbType) {
                case derby: {
                    stmt.setInt(i++, this.getOffset());
                    stmt.setInt(i++, this.getLimit());
                    break;
                }
                case jtds: 
                case sqlserver: {
                    stmt.setInt(i++, this.getOffset());
                    stmt.setInt(i++, this.getOffset() + this.getLimit());
                    break;
                }
                default: {
                    stmt.setInt(i++, this.getLimit());
                    stmt.setInt(i++, this.getOffset());
                }
            }
        }
    }

    private class Item {
        String message;
        Date timestamp;
        MessageArchiveRepository.Direction direction;
        String with;

        private Item() {
        }
    }
}

