/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.server.Packet;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOServiceListener;

public class XMPPIOService<RefObject>
extends IOService<RefObject> {
    public static final String ACK_NAME = "ack";
    public static final String CROSS_DOMAIN_POLICY_FILE_PROP_KEY = "cross-domain-policy-file";
    public static final String CROSS_DOMAIN_POLICY_FILE_PROP_VAL = "etc/cross-domain-policy.xml";
    public static final String DOM_HANDLER = "XMPPDomBuilderHandler";
    public static final String ID_ATT = "id";
    public static final String REQ_NAME = "req";
    private static String cross_domain_policy = null;
    private static final Logger log = Logger.getLogger(XMPPIOService.class.getName());
    private XMPPDomBuilderHandler<RefObject> domHandler = null;
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    private String jid = null;
    private long packetsReceived = 0L;
    private long packetsSent = 0L;
    private XMPPIOProcessor[] processors = null;
    private long req_idx = 0L;
    private XMPPIOServiceListener serviceListener = null;
    private long totalPacketsReceived = 0L;
    private long totalPacketsSent = 0L;
    private long lastXmppPacketReceivedTime = 0L;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentSkipListMap<String, Packet> waitingForAck = new ConcurrentSkipListMap();
    private boolean white_char_ack = false;
    private String xmlns = null;
    private boolean xmpp_ack = false;
    private boolean strict_ack = false;
    private ConcurrentLinkedQueue<Packet> receivedPackets = new ConcurrentLinkedQueue();
    private boolean firstPacket = true;
    public ReentrantLock writeInProgress = new ReentrantLock();

    public XMPPIOService() {
        this.domHandler = new XMPPDomBuilderHandler(this);
        this.getSessionData().put(DOM_HANDLER, this.domHandler);
        if (cross_domain_policy == null) {
            String file_name = System.getProperty(CROSS_DOMAIN_POLICY_FILE_PROP_KEY, CROSS_DOMAIN_POLICY_FILE_PROP_VAL);
            try {
                BufferedReader br = new BufferedReader(new FileReader(file_name));
                String line = br.readLine();
                StringBuilder sb = new StringBuilder();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                sb.append('\u0000');
                br.close();
                cross_domain_policy = sb.toString();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem reading cross domain poicy file: " + file_name, ex);
            }
        }
    }

    public void addPacketToSend(Packet packet) {
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                if (!processor.processOutgoing(this, packet)) continue;
                return;
            }
        }
        if (this.xmpp_ack) {
            String req = "" + ++this.req_idx;
            packet.getElement().addChild(new Element(REQ_NAME, new String[]{ID_ATT}, new String[]{req}));
            this.waitingForAck.put(req, packet);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Added req {1} for packet: {2}", new Object[]{this.toString(), req, packet});
            }
        }
        ++this.packetsSent;
        ++this.totalPacketsSent;
        this.waitingPackets.offer(packet);
    }

    @Override
    public boolean checkBufferLimit(int bufferSize) {
        if (!super.checkBufferLimit(bufferSize)) {
            try {
                this.writeRawData("<stream:error><policy-violation xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>");
                int counter = 0;
                while (this.isConnected() && this.waitingToSend() && ++counter < 10) {
                    this.writeData(null);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ex) {
                log.log(Level.FINEST, "{0}, Exception sending policy-violation stream error", new Object[]{this.toString()});
            }
            this.forceStop();
            return false;
        }
        return true;
    }

    public boolean checkData(char[] data) throws IOException {
        return false;
    }

    public void clearWaitingPackets() {
        this.waitingPackets.clear();
    }

    public Queue<Packet> getWaitingPackets() {
        return this.waitingPackets;
    }

    @Override
    public void forceStop() {
        boolean stop = false;
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                stop |= processor.serviceStopped(this, false);
            }
        }
        if (!stop) {
            super.forceStop();
        }
    }

    @Override
    public void processWaitingPackets() throws IOException {
        Packet packet = null;
        while ((packet = this.waitingPackets.peek()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Sending packet: {1}", new Object[]{this.toString(), packet});
            }
            this.writeRawData(packet.getElement().toString());
            this.waitingPackets.poll();
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "{0}, SENT: {1}", new Object[]{this.toString(), packet.getElement().toString()});
        }
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                processor.packetsSent(this);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public String toString() {
        return super.toString() + ", jid: " + this.jid;
    }

    public void writeRawData(String data) throws IOException {
        this.writeData(data);
    }

    public void xmppStreamOpen(String data) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Sending data: {1}", new Object[]{this.toString(), data});
            }
            this.writeRawData(data);
            assert (this.debug(data, "--SENT:"));
        }
        catch (IOException e) {
            log.log(Level.WARNING, "{0}, Error sending stream open data: {1}", new Object[]{this.toString(), e});
            this.forceStop();
        }
    }

    public long getPacketsReceived(boolean reset) {
        long tmp = this.packetsReceived;
        if (reset) {
            this.packetsReceived = 0L;
        }
        return tmp;
    }

    public long getPacketsSent(boolean reset) {
        long tmp = this.packetsSent;
        if (reset) {
            this.packetsSent = 0L;
        }
        return tmp;
    }

    public Queue<Packet> getReceivedPackets() {
        return this.receivedPackets;
    }

    public long getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    public long getTotalPacketsSent() {
        return this.totalPacketsSent;
    }

    public String getUserJid() {
        return this.jid;
    }

    public Map<String, Packet> getWaitingForAct() {
        for (Packet p : this.waitingForAck.values()) {
            Element req = p.getElement().getChild(REQ_NAME);
            if (req == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "{0}, Missing req element in waiting for ACK packet: {1}", new Object[]{this.toString(), p});
                continue;
            }
            p.getElement().removeChild(req);
        }
        return this.waitingForAck;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    public void setAckMode(boolean white_char_ack, boolean xmpp_ack, boolean strict) {
        this.white_char_ack = white_char_ack;
        this.xmpp_ack = xmpp_ack;
        this.strict_ack = strict;
    }

    public void setElementLimits(int limit) {
    }

    public void setIOServiceListener(XMPPIOServiceListener servList) {
        this.serviceListener = servList;
        super.setIOServiceListener(servList);
    }

    public void setProcessors(XMPPIOProcessor[] processors) {
        this.processors = processors;
    }

    public void setUserJid(String jid) {
        this.jid = jid;
    }

    public void setXMLNS(String xmlns) {
        this.xmlns = xmlns;
    }

    protected void addReceivedPacket(Packet packet) {
        if (this.firstPacket) {
            if ("policy-file-request" == packet.getElemName()) {
                log.fine("Got flash cross-domain request" + packet);
                if (cross_domain_policy != null) {
                    try {
                        this.writeRawData(cross_domain_policy);
                    }
                    catch (Exception ex) {
                        log.log(Level.INFO, "Can't send cross-domain policy: ", ex);
                    }
                    log.log(Level.FINER, "Cross-domain policy sent: {1}", cross_domain_policy);
                } else {
                    log.log(Level.FINER, "No cross-domain policy defined to sent.");
                }
                return;
            }
            this.firstPacket = false;
        }
        if (this.processors != null) {
            boolean stop = false;
            for (XMPPIOProcessor processor : this.processors) {
                stop |= processor.processIncoming(this, packet);
            }
            if (stop) {
                return;
            }
        }
        if (packet.getElemName() == ACK_NAME) {
            String string = packet.getAttributeStaticStr(ID_ATT);
        } else {
            this.sendAck(packet);
            ++this.packetsReceived;
            ++this.totalPacketsReceived;
            this.setLastXmppPacketReceiveTime();
            this.receivedPackets.offer(packet);
        }
    }

    protected String prepareStreamClose() {
        return "</stream:stream>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSocketData() throws IOException {
        if (this.isConnected()) {
            char[] data = this.readData();
            while (this.isConnected() && data != null && data.length > 0) {
                boolean disconnect;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, READ:{1}", new Object[]{this.toString(), new String(data)});
                }
                if (disconnect = this.checkData(data)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0}, checkData says disconnect: {1}", new Object[]{this.toString(), new String(data)});
                    } else {
                        log.log(Level.WARNING, "{0}, checkData says disconnect", this.toString());
                    }
                    this.forceStop();
                    return;
                }
                assert (this.debug(new String(data), "--RECEIVED:"));
                Element elem = null;
                try {
                    this.parser.parse(this.domHandler, data, 0, data.length);
                    if (this.domHandler.parseError()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "{0}, Data parsing error: {1}", new Object[]{this.toString(), new String(data)});
                        } else {
                            log.log(Level.WARNING, "{0}, data parsing error, stopping connection", this.toString());
                        }
                        this.forceStop();
                        return;
                    }
                    Queue<Element> elems = this.domHandler.getParsedElements();
                    if (elems.size() > 0) {
                        this.readCompleted();
                    }
                    while ((elem = elems.poll()) != null) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "{0}, Read packet: {1}", new Object[]{this.toString(), elem});
                        }
                        Packet pack = Packet.packetInstance(elem);
                        this.addReceivedPacket(pack);
                        this.sendAck(pack);
                    }
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.INFO, this.toString() + ", Incorrect to/from JID format for stanza: " + elem.toString(), ex);
                }
                catch (Exception ex) {
                    log.log(Level.INFO, this.toString() + ", Incorrect XML data: " + new String(data) + ", stopping connection: " + this.getConnectionId() + ", exception: ", ex);
                    this.forceStop();
                }
                finally {
                    if (this.domHandler.isStreamClosed()) {
                        this.xmppStreamClosed();
                    }
                }
                data = this.readData();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}, function called when the service is not connected! forceStop()", this.toString());
            }
            this.forceStop();
        }
    }

    @Override
    protected int receivedPackets() {
        return this.receivedPackets.size();
    }

    protected void xmppStreamClosed() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, Received STREAM-CLOSE from the client", this.toString());
        }
        if (this.processors != null) {
            for (XMPPIOProcessor processor : this.processors) {
                processor.serviceStopped(this, true);
            }
        }
        try {
            if (this.isConnected()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, Sending data: </stream:stream>, as socket is still connected", this.toString());
                }
                this.writeRawData(this.prepareStreamClose());
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Not sending data: </stream:stream>, as socket is alreadt closed", this.toString());
            }
        }
        catch (IOException e) {
            log.log(Level.INFO, "{0}, Error sending stream closed data: {1}", new Object[]{this.toString(), e});
        }
        if (this.serviceListener != null) {
            this.serviceListener.xmppStreamClosed(this);
        }
    }

    protected void xmppStreamOpened(Map<String, String> attribs) {
        if (this.serviceListener != null) {
            String response = this.serviceListener.xmppStreamOpened(this, attribs);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, Sending data: {1}", new Object[]{this.toString(), response});
                }
                this.writeRawData(response);
                this.processWaitingPackets();
                if (response != null && response.endsWith("</stream:stream>")) {
                    this.stop();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "{0}, Error sending stream open data: {1}", new Object[]{this.toString(), e});
                this.forceStop();
            }
        }
    }

    private void sendAck(Packet packet) {
        if (this.white_char_ack || this.xmpp_ack) {
            Element req;
            String ack = null;
            if (this.white_char_ack) {
                ack = " ";
            }
            if (this.xmpp_ack && (req = packet.getElement().getChild(REQ_NAME)) != null) {
                packet.getElement().removeChild(req);
                String req_val = req.getAttributeStaticStr(ID_ATT);
                if (req_val != null) {
                    ack = "<ack id=\"" + req_val + "\"/>";
                }
            }
            if (ack != null) {
                try {
                    this.writeRawData(ack);
                    log.log(Level.FINEST, "Sent ack confirmation: '" + ack + "'");
                }
                catch (Exception ex) {
                    this.forceStop();
                    log.log(Level.FINE, "Can't send ack confirmation: '" + ack + "'", ex);
                }
            }
        }
    }

    private void setLastXmppPacketReceiveTime() {
        this.lastXmppPacketReceivedTime = System.currentTimeMillis();
    }

    public long getLastXmppPacketReceiveTime() {
        return this.lastXmppPacketReceivedTime;
    }
}

