/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.component.AbstractEventBusModule;
import tigase.disteventbus.component.ElemPathCriteria;
import tigase.disteventbus.component.EventBusContext;
import tigase.disteventbus.component.NodeNameUtil;
import tigase.disteventbus.component.stores.Affiliation;
import tigase.disteventbus.component.stores.Subscription;
import tigase.disteventbus.impl.EventName;
import tigase.disteventbus.impl.LocalEventBus;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class SubscribeModule
extends AbstractEventBusModule {
    private static final Criteria CRIT = new ElemPathCriteria(new String[]{"iq", "pubsub", "subscribe"}, new String[]{null, "http://jabber.org/protocol/pubsub", null});
    public static final String ID = "subscribe";
    private final LocalEventBus.LocalEventBusListener eventBusListener = new LocalEventBus.LocalEventBusListener(){

        @Override
        public void onAddHandler(String name, String xmlns, EventHandler handler) {
            SubscribeModule.this.onAddHandler(name, xmlns);
        }

        @Override
        public void onFire(String name, String xmlns, Element event) {
        }

        @Override
        public void onRemoveHandler(String name, String xmlns, EventHandler handler) {
        }
    };

    @Override
    public void afterRegistration() {
        super.afterRegistration();
        ((EventBusContext)this.context).getEventBusInstance().addListener(this.eventBusListener);
    }

    public void clusterNodeConnected(String node) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Node " + node + " is connected.");
        }
        HashSet<Element> pubsubNodes = new HashSet<Element>();
        for (EventName eventName : ((EventBusContext)this.context).getEventBusInstance().getAllListenedEvents()) {
            pubsubNodes.add(this.prepareSubscribeElement(eventName, ((EventBusContext)this.context).getComponentID(), null));
        }
        for (EventName eventName : ((EventBusContext)this.context).getSubscriptionStore().getSubscribedEvents()) {
            Collection<Subscription> subscriptions = ((EventBusContext)this.context).getSubscriptionStore().getSubscribersJIDs(eventName.getName(), eventName.getXmlns());
            for (Subscription subscription : subscriptions) {
                if (subscription.getServiceJID() == null) continue;
                pubsubNodes.add(this.prepareSubscribeElement(eventName, subscription.getJid(), subscription.getServiceJID().toString()));
            }
        }
        if (!pubsubNodes.isEmpty()) {
            this.sendSubscribeRequest("eventbus@" + node, pubsubNodes);
        }
    }

    public void clusterNodeDisconnected(String node) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Node " + node + " is disconnected.");
        }
        ((EventBusContext)this.context).getSubscriptionStore().remove(new Subscription(JID.jidInstanceNS("eventbus", node, null)));
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#subscribe"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    protected void onAddHandler(String eventName, String eventXmlns) {
        for (String node : ((EventBusContext)this.context).getConnectedNodes()) {
            Element se = this.prepareSubscribeElement(new EventName(eventName, eventXmlns), ((EventBusContext)this.context).getComponentID(), null);
            this.sendSubscribeRequest("eventbus@" + node, Collections.singleton(se));
        }
    }

    private Element prepareSubscribeElement(EventName event, JID jid, String service) {
        Element subscribeElem = new Element(ID);
        subscribeElem.addAttribute("node", event.toEventBusNode());
        subscribeElem.addAttribute("jid", jid.toString());
        if (service != null) {
            subscribeElem.addChild(new Element("service", service));
        }
        return subscribeElem;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getType() != StanzaType.set) {
            throw new ComponentException(Authorization.NOT_ALLOWED);
        }
        this.processSet(packet);
    }

    protected Element processClusterSubscription(Packet packet) throws TigaseStringprepException {
        List<Element> subscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        for (Element subscribe : subscribeElements) {
            Element serviceItem = subscribe.getChild("service");
            EventName parsedName = NodeNameUtil.parseNodeName(subscribe.getAttributeStaticStr("node"));
            JID jid = JID.jidInstance(subscribe.getAttributeStaticStr("jid"));
            String service = serviceItem != null && serviceItem.getCData() != null ? serviceItem.getCData() : null;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Node " + jid + " subscribed for events " + parsedName);
            }
            Subscription subscription = new Subscription(jid);
            subscription.setServiceJID(JID.jidInstanceNS(service));
            ((EventBusContext)this.context).getSubscriptionStore().addSubscription(parsedName.getName(), parsedName.getXmlns(), subscription);
        }
        return null;
    }

    protected Element processNonClusterSubscription(Packet packet) throws TigaseStringprepException, ComponentException {
        Affiliation affiliation = ((EventBusContext)this.context).getAffiliationStore().getAffiliation(packet.getStanzaFrom());
        if (!affiliation.isSubscribe()) {
            throw new ComponentException(Authorization.FORBIDDEN);
        }
        List<Element> subscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        Element response = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        HashSet<Element> subscribedNodes = new HashSet<Element>();
        for (Element subscribe : subscribeElements) {
            EventName parsedName = NodeNameUtil.parseNodeName(subscribe.getAttributeStaticStr("node"));
            JID jid = JID.jidInstance(subscribe.getAttributeStaticStr("jid"));
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Entity " + jid + " subscribed for events " + parsedName);
            }
            ((EventBusContext)this.context).getSubscriptionStore().addSubscription(parsedName.getName(), parsedName.getXmlns(), new Subscription(jid, packet.getStanzaTo()));
            subscribedNodes.add(this.prepareSubscribeElement(parsedName, jid, packet.getStanzaTo().toString()));
            response.addChild(new Element("subscription", new String[]{"node", "jid", "subscription"}, new String[]{parsedName.toEventBusNode(), jid.toString(), "subscribed"}));
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Forwarding subscription to: " + ((EventBusContext)this.context).getConnectedNodes());
        }
        for (String node : ((EventBusContext)this.context).getConnectedNodes()) {
            this.sendSubscribeRequest("eventbus@" + node, subscribedNodes);
        }
        return response;
    }

    private void processSet(Packet packet) throws TigaseStringprepException, ComponentException {
        Element subscriptionResponse = this.isClusteredEventBus(packet.getStanzaFrom()) ? this.processClusterSubscription(packet) : this.processNonClusterSubscription(packet);
        Packet response = packet.okResult(subscriptionResponse, 0);
        response.setPermissions(Permissions.ADMIN);
        this.write(response);
    }

    protected void sendSubscribeRequest(String to, Collection<Element> subscriptionElement) {
        try {
            Element iq = new Element("iq", new String[]{"from", "to", "type", "id"}, new String[]{((EventBusContext)this.context).getComponentID().toString(), to, "set", this.nextStanzaID()});
            Element pubsubElem = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            iq.addChild(pubsubElem);
            for (Element node : subscriptionElement) {
                pubsubElem.addChild(node);
            }
            Packet packet = Packet.packetInstance(iq);
            packet.setPermissions(Permissions.ADMIN);
            packet.setXMLNS("jabber:client");
            this.write(packet, new AsyncCallback(){

                @Override
                public void onError(Packet responseStanza, String errorCondition) {
                }

                @Override
                public void onSuccess(Packet responseStanza) {
                }

                @Override
                public void onTimeout() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregisterModule() {
        ((EventBusContext)this.context).getEventBusInstance().removeListener(this.eventBusListener);
        super.unregisterModule();
    }
}

