/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.conf.ConfigurationException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.ComponentInfo;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsList;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class SessionManagerClustered
extends SessionManager
implements ClusteredComponentIfc,
SessionManagerClusteredIfc {
    public static final String CLUSTER_STRATEGY_VAR = "clusterStrategy";
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String STRATEGY_CLASS_PROP_KEY = "sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.DefaultClusteringStrategy";
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final int SYNC_MAX_BATCH_SIZE = 1000;
    private static final Logger log = Logger.getLogger(SessionManagerClustered.class.getName());
    private ClusterControllerIfc clusterController = null;
    private ComponentInfo cmpInfo = null;
    private JID my_address = null;
    private JID my_hostname = null;
    private int nodesNo = 0;
    private ClusteringStrategyIfc strategy = null;

    @Override
    public boolean containsJid(BareJID jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for jid: {0}", jid);
        }
        return super.containsJid(jid) || this.strategy.containsJid(jid);
    }

    @Override
    public boolean fastAddOutPacket(Packet packet) {
        return super.fastAddOutPacket(packet);
    }

    @Override
    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
        if (this.strategy != null) {
            this.strategy.handleLocalPacket(packet, conn);
        }
    }

    @Override
    public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        super.handleLogin(userId, conn);
        this.strategy.handleLocalUserLogin(userId, conn);
    }

    @Override
    public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        try {
            if (conn.isAuthorized() && conn.isResourceSet()) {
                this.strategy.handleLocalUserLogout(userId, conn);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
        super.handleLogout(userId, conn);
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        super.handleResourceBind(conn);
        this.strategy.handleLocalResourceBind(conn);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(CLUSTER_STRATEGY_VAR, (Object)this.strategy);
    }

    @Override
    public void nodeConnected(String node) {
        log.log(Level.FINE, "Nodes connected: {0}", node);
        JID jid = JID.jidInstanceNS(this.getName(), node, null);
        this.strategy.nodeConnected(jid);
        this.sendAdminNotification(node, STATUS.CONNECETED);
    }

    @Override
    public void nodeDisconnected(String node) {
        log.log(Level.FINE, "Nodes disconnected: {0}", node);
        JID jid = JID.jidInstanceNS(this.getName(), node, null);
        this.strategy.nodeDisconnected(jid);
        this.sendAdminNotification(node, STATUS.DISCONNECTED);
    }

    @Override
    public int processingInThreads() {
        return Math.max(this.nodesNo, super.processingInThreads());
    }

    @Override
    public int processingOutThreads() {
        return Math.max(this.nodesNo, super.processingOutThreads());
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Received packet: {0}", packet);
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
        } else {
            XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ressource connection found: {0}", conn);
            }
            boolean clusterOK = this.strategy.processPacket(packet, conn);
            if (conn == null) {
                if (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Ignoring/dropping packet: {0}", packet);
                    }
                } else if (!clusterOK) {
                    this.processPacket(packet, (XMPPResourceConnection)null);
                }
            } else {
                this.processPacket(packet, conn);
            }
        }
    }

    @Override
    public void processPacket(Packet packet, XMPPResourceConnection conn) {
        super.processPacket(packet, conn);
    }

    @Override
    public void processPresenceUpdate(XMPPSession session, Element packet) {
        super.processPresenceUpdate(session, packet);
    }

    @Override
    public ComponentInfo getComponentInfo() {
        this.cmpInfo = super.getComponentInfo();
        this.cmpInfo.getComponentData().put("ClusteringStrategy", this.strategy != null ? this.strategy.getClass() : null);
        return this.cmpInfo;
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        Object[] ids = super.getConnectionIdsForJid(jid);
        if (ids == null) {
            ids = this.strategy.getConnectionIdsForJid(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for jid: {0}, results: {1}", new Object[]{jid, Arrays.toString(ids)});
        }
        return ids;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String strategy_class = (String)params.get(STRATEGY_CLASS_PROPERTY);
        if (strategy_class == null) {
            strategy_class = STRATEGY_CLASS_PROP_VAL;
        }
        props.put(STRATEGY_CLASS_PROP_KEY, strategy_class);
        try {
            ClusteringStrategyIfc strat_tmp = (ClusteringStrategyIfc)ModulesManagerImpl.getInstance().forName(strategy_class).newInstance();
            Map<String, Object> strat_defs = strat_tmp.getDefaults(params);
            if (strat_defs != null) {
                props.putAll(strat_defs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate clustering strategy for class: " + strategy_class, e);
        }
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        props.put(MY_DOMAIN_NAME_PROP_KEY, local_domains[0]);
        if (params.get("--cluster-nodes") != null) {
            String[] cl_nodes = ((String)params.get("--cluster-nodes")).split(",");
            this.nodesNo = cl_nodes.length;
        }
        return props;
    }

    @Override
    public String getDiscoDescription() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "disco description from SM Clustered");
        }
        String result = super.getDiscoDescription();
        result = result + " clustered, ";
        result = result + this.strategy;
        return result;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.strategy.getStatistics(list);
    }

    public ClusteringStrategyIfc getStrategy() {
        return this.strategy;
    }

    @Override
    public XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        return super.getXMPPResourceConnection(p);
    }

    @Override
    public ConcurrentHashMap<JID, XMPPResourceConnection> getXMPPResourceConnections() {
        return this.connectionsByFrom;
    }

    @Override
    public ConcurrentHashMap<BareJID, XMPPSession> getXMPPSessions() {
        return this.sessionsByNodeId;
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return this.strategy.hasCompleteJidsInfo();
    }

    @Override
    public boolean hasXMPPResourceConnectionForConnectionJid(JID connJid) {
        return this.connectionsByFrom.containsKey(connJid);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.clusterController = cl_controller;
        if (this.strategy != null) {
            this.strategy.setClusterController(this.clusterController);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.get(STRATEGY_CLASS_PROP_KEY) != null) {
            String strategy_class = (String)props.get(STRATEGY_CLASS_PROP_KEY);
            try {
                ClusteringStrategyIfc strategy_tmp = this.strategy;
                if (this.strategy == null || !strategy_class.equals(this.strategy.getClass().getCanonicalName())) {
                    Class<?> cls = ModulesManagerImpl.getInstance().forName(strategy_class);
                    strategy_tmp = (ClusteringStrategyIfc)cls.newInstance();
                }
                strategy_tmp.setSessionManagerHandler(this);
                strategy_tmp.setProperties(props);
                this.strategy = strategy_tmp;
                this.strategy.setSessionManagerHandler(this);
                log.log(Level.CONFIG, "Loaded SM strategy: {0}", strategy_class);
                this.addTrusted(this.getComponentId());
                if (this.clusterController != null) {
                    this.strategy.setClusterController(this.clusterController);
                }
            }
            catch (Exception e) {
                if (!XMPPServer.isOSGi()) {
                    log.log(Level.SEVERE, "Cannot instance clustering strategy class: " + strategy_class, e);
                }
                throw new ConfigurationException("Can not instantiate clustering strategy for class: " + strategy_class);
            }
        }
        this.updateServiceEntity();
        try {
            if (props.get(MY_DOMAIN_NAME_PROP_KEY) != null) {
                this.my_hostname = JID.jidInstance((String)props.get(MY_DOMAIN_NAME_PROP_KEY));
                this.my_address = JID.jidInstance(this.getName(), (String)props.get(MY_DOMAIN_NAME_PROP_KEY), null);
            }
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.WARNING, "Creating component source address failed stringprep processing: {0}@{1}", new Object[]{this.getName(), this.my_hostname});
        }
    }

    @Override
    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}, closeOnly: {1}", new Object[]{conn, closeOnly});
        }
        try {
            if (conn.isAuthorized() && conn.isResourceSet()) {
                BareJID userId = conn.getBareJID();
                this.strategy.handleLocalUserLogout(userId, conn);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
        try {
            super.closeSession(conn, closeOnly);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
    }

    private void sendAdminNotification(String node, STATUS stat) {
        String message = "Cluster ";
        String subject = null;
        if (node != null) {
            message = message + "node " + node + " ";
        }
        switch (stat) {
            case CONNECETED: {
                message = message + "connected to ";
                break;
            }
            case DISCONNECTED: {
                message = message + "disconnected from ";
            }
        }
        message = message + this.getDefHostName() + " (" + new Date() + ")";
        Packet p_msg = Message.getMessage(this.my_address, this.my_hostname, StanzaType.chat, message, subject, "cluster_status_update", this.newPacketId(null));
        this.sendToAdmins(p_msg);
    }

    private static enum STATUS {
        CONNECETED,
        DISCONNECTED;

    }
}

