/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.cluster.AbstractStrategy;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.StrategyIfc;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.PresenceModule;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class AbstractClusteredRoomStrategy
extends AbstractStrategy
implements Room.RoomListener,
InMemoryMucRepositoryClustered.RoomListener,
StrategyIfc {
    private static final Logger a = Logger.getLogger(AbstractClusteredRoomStrategy.class.getCanonicalName());
    private static final String b = "muc-sync-response";
    private static final String c = "muc-room-created-cmd";
    private static final String d = "muc-room-destroyed-cmd";
    private static final String e = "muc-room-message-cmd";
    private static final String f = "muc-room-affiliation-cmd";
    private static final int g = 1000;
    private final d h = new d();
    private final e i = new e();
    private final f j = new f();
    private final a k = new a();
    private final b l = new b();
    private final c m = new c();
    protected final ConcurrentHashMap<BareJID, ConcurrentMap<JID, ConcurrentMap<BareJID, String>>> occupantsPerNode = new ConcurrentHashMap();

    @Override
    public void nodeDisconnected(JID nodeJid) {
        super.nodeDisconnected(nodeJid);
        ConcurrentMap<JID, ConcurrentMap<BareJID, String>> concurrentMap = this.occupantsPerNode.remove(nodeJid.getBareJID());
        if (concurrentMap == null) {
            return;
        }
        int n = this.connectedNodes.indexOf(this.localNodeJid);
        int n2 = this.connectedNodes.size();
        for (Map.Entry entry : concurrentMap.entrySet()) {
            JID jID = (JID)entry.getKey();
            boolean bl = !this.muc.isLocalDomain(jID.getDomain()) && jID.hashCode() % n2 == n;
            Map map = (Map)entry.getValue();
            if (map == null) continue;
            for (BareJID bareJID : map.keySet()) {
                try {
                    Room room = this.mucRepository.getRoom(bareJID);
                    if (room != null) {
                        this.sendRemoteOccupantRemovalOnDisconnect(room, jID, (String)map.get(bareJID), bl);
                        continue;
                    }
                    a.log(Level.FINER, "no room {0} in repository, while instance available in map of active rooms, propably room removed on other node but not yet synchronized?", bareJID);
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "exception retrieving occupants for room " + bareJID, exception);
                }
            }
        }
    }

    @Override
    public boolean processPacket(Packet packet) {
        JID jID = packet.getStanzaFrom();
        BareJID bareJID = this.getNodeForJID(jID);
        if (bareJID != null) {
            if (a.isLoggable(Level.FINER)) {
                a.log(Level.FINER, "forwarding packet to node = {1}", new Object[]{bareJID});
            }
            this.forwardPacketToNode(JID.jidInstance((BareJID)bareJID), packet);
            return true;
        }
        return false;
    }

    @Override
    public void setMucRepository(InMemoryMucRepositoryClustered mucRepository) {
        super.setMucRepository(mucRepository);
        mucRepository.setRoomListener(this);
        mucRepository.setRoomOccupantListener(this);
        try {
            RoomConfig roomConfig = mucRepository.getDefaultRoomConfig();
            roomConfig.setValue("muc#roomconfig_persistentroom", (Object)true);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.k);
            this.cl_controller.removeCommandListener((CommandListener)this.l);
            this.cl_controller.removeCommandListener((CommandListener)this.h);
            this.cl_controller.removeCommandListener((CommandListener)this.i);
            this.cl_controller.removeCommandListener((CommandListener)this.j);
            this.cl_controller.removeCommandListener((CommandListener)this.m);
        }
        super.setClusterController(cl_controller);
        if (cl_controller != null) {
            cl_controller.setCommandListener((CommandListener)this.k);
            cl_controller.setCommandListener((CommandListener)this.l);
            cl_controller.setCommandListener((CommandListener)this.h);
            cl_controller.setCommandListener((CommandListener)this.i);
            cl_controller.setCommandListener((CommandListener)this.j);
            cl_controller.setCommandListener((CommandListener)this.m);
        }
    }

    @Override
    public void onRoomCreated(Room room) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("creator", room.getCreatorJid().toString());
        hashMap.put("userId", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is created", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(c, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomDestroyed(Room room, Element destroyElement) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is destroyed", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(d, hashMap, destroyElement, this.localNodeJid, null, list.toArray(new JID[list.size()]));
    }

    public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
    }

    public void onSetAffiliation(Room room, BareJID jid, Affiliation newAffiliation) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", jid.toString());
        hashMap.put("newAffiliation", newAffiliation.toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] about new affiliation", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(f, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    public void onMessageToOccupants(Room room, JID from, Element[] contents) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", from.toString());
        Element element = new Element("message");
        for (Element element2 : contents) {
            element.addChild((XMLNodeIfc)element2);
        }
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] about new message", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(e, hashMap, element, this.localNodeJid, null, list.toArray(new JID[list.size()]));
    }

    @Override
    protected boolean addOccupant(BareJID node, BareJID roomJid, JID occupantJid, String nickname) {
        Object object;
        Object object2;
        ConcurrentMap<JID, Object> concurrentMap = this.occupantsPerNode.get(node);
        if (concurrentMap == null && (concurrentMap = (ConcurrentMap<JID, Object>)this.occupantsPerNode.putIfAbsent(node, (ConcurrentMap<JID, ConcurrentMap<BareJID, String>>)(object2 = new ConcurrentHashMap()))) == null) {
            concurrentMap = object2;
        }
        if ((object2 = (ConcurrentMap)concurrentMap.get(occupantJid)) == null && (object2 = (ConcurrentMap)concurrentMap.putIfAbsent(occupantJid, object = new ConcurrentHashMap())) == null) {
            object2 = object;
        }
        return (object = object2.put(roomJid, nickname)) == null;
    }

    @Override
    protected boolean removeOccupant(BareJID node, BareJID roomJid, JID occupantJid) {
        Object object;
        Object object2;
        Map map = this.occupantsPerNode.get(node);
        if (map == null && (map = (ConcurrentMap)this.occupantsPerNode.putIfAbsent(node, (ConcurrentMap<JID, ConcurrentMap<BareJID, String>>)(object2 = new ConcurrentHashMap()))) == null) {
            map = object2;
        }
        if ((object2 = (Map)map.get(occupantJid)) == null && (object2 = (Map)map.putIfAbsent(occupantJid, object = new ConcurrentHashMap())) == null) {
            object2 = object;
        }
        object = (String)object2.remove(roomJid);
        if (object2.isEmpty()) {
            map.remove(occupantJid);
        }
        return object != null;
    }

    public BareJID getNodeForJID(JID jid) {
        if (this.muc.isLocalDomain(jid.getDomain())) {
            return null;
        }
        for (BareJID bareJID : this.occupantsPerNode.keySet()) {
            Map map = this.occupantsPerNode.get(bareJID);
            if (!map.containsKey(jid)) continue;
            return bareJID;
        }
        return null;
    }

    private class c
    extends CommandListenerAbstract {
        public c() {
            super(AbstractClusteredRoomStrategy.f);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            BareJID bareJID2 = BareJID.bareJIDInstanceNS((String)data.get("userId"));
            Affiliation affiliation = Affiliation.valueOf((String)data.get("newAffiliation"));
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "executig RoomAffiliationCmd command for room = {0}, from = {1}, newAffiliation: {2}", new Object[]{bareJID, bareJID2, affiliation});
            }
            try {
                Room room = AbstractClusteredRoomStrategy.this.muc.getMucRepository().getRoom(bareJID);
                room.setNewAffiliation(bareJID2, affiliation);
            }
            catch (RepositoryException | MUCException throwable) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, throwable);
            }
        }
    }

    private class b
    extends CommandListenerAbstract {
        public b() {
            super(AbstractClusteredRoomStrategy.b);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig ResponseSyncCmd command fromNode = {0}, packets: {1}", new Object[]{fromNode, packets});
                }
                for (Element element : packets) {
                    if (element.getName() != "occupant") continue;
                    JID jID = JID.jidInstanceNS((String)element.getAttributeStaticStr("jid"));
                    List list = element.getChildren();
                    if (list == null || list.isEmpty()) continue;
                    for (Element element2 : list) {
                        BareJID bareJID = BareJID.bareJIDInstanceNS((String)element2.getAttributeStaticStr("jid"));
                        String string = element2.getAttributeStaticStr("nickname");
                        AbstractClusteredRoomStrategy.this.addOccupant(fromNode.getBareJID(), bareJID, jID, string);
                    }
                }
            }
        }
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super("muc-sync-request");
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ConcurrentMap<JID, ConcurrentMap<BareJID, String>> concurrentMap = AbstractClusteredRoomStrategy.this.occupantsPerNode.get(AbstractClusteredRoomStrategy.this.localNodeJid.getBareJID());
            LinkedList<Element> linkedList = new LinkedList<Element>();
            if (concurrentMap != null) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig RequestSyncCmd command fromNode = {0}, nodeOccupants = {1}", new Object[]{fromNode, concurrentMap});
                }
                for (Map.Entry entry : concurrentMap.entrySet()) {
                    Element element = new Element("occupant", new String[]{"jid"}, new String[]{((JID)entry.getKey()).toString()});
                    Map map = (Map)entry.getValue();
                    for (Map.Entry entry2 : map.entrySet()) {
                        element.addChild((XMLNodeIfc)new Element("room", new String[]{"jid", "nickname"}, new String[]{((BareJID)entry2.getKey()).toString(), (String)entry2.getValue()}));
                    }
                    linkedList.add(element);
                    if (linkedList.size() <= 1000) continue;
                    AbstractClusteredRoomStrategy.this.cl_controller.sendToNodes(AbstractClusteredRoomStrategy.b, linkedList, AbstractClusteredRoomStrategy.this.localNodeJid, null, new JID[]{fromNode});
                    linkedList = new LinkedList();
                }
            }
            if (!linkedList.isEmpty()) {
                AbstractClusteredRoomStrategy.this.cl_controller.sendToNodes(AbstractClusteredRoomStrategy.b, linkedList, AbstractClusteredRoomStrategy.this.localNodeJid, null, new JID[]{fromNode});
            }
        }
    }

    private class f
    extends CommandListenerAbstract {
        public f() {
            super(AbstractClusteredRoomStrategy.e);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("userId"));
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "executig RoomMessageCmd command for room = {0}, from = {1}, packets: {2}", new Object[]{bareJID, jID, packets});
            }
            try {
                Room room = AbstractClusteredRoomStrategy.this.muc.getMucRepository().getRoom(bareJID);
                GroupchatMessageModule groupchatMessageModule = (GroupchatMessageModule)AbstractClusteredRoomStrategy.this.muc.getModule("groupchat");
                Element element = packets.poll();
                List list = element.getChildren();
                groupchatMessageModule.sendMessagesToAllOccupantsJids(room, jID, list.toArray(new Element[list.size()]));
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
            catch (MUCException mUCException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, mUCException);
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }

    private class e
    extends CommandListenerAbstract {
        public e() {
            super(AbstractClusteredRoomStrategy.d);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "executig RoomDestroyedCmd command for room = {0}, packets: {1}", new Object[]{bareJID, packets});
            }
            try {
                Room room = AbstractClusteredRoomStrategy.this.muc.getMucRepository().getRoom(bareJID);
                Element element = packets.poll();
                for (JID jID : room.getAllOccupantsJID()) {
                    String string = room.getOccupantsNickname(jID);
                    Element element2 = new Element("presence");
                    element2.addAttribute("type", "unavailable");
                    PresenceModule.PresenceWrapper presenceWrapper = PresenceModule.PresenceWrapper.preparePresenceW((Room)room, (JID)jID, (Element)element2, (BareJID)jID.getBareJID(), Collections.singleton(jID), (String)string, (Affiliation)Affiliation.none, (Role)Role.none);
                    presenceWrapper.getX().addChild((XMLNodeIfc)element);
                }
                AbstractClusteredRoomStrategy.this.mucRepository.destroyRoomWithoutListener(room, element);
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
            catch (MUCException mUCException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, mUCException);
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }

    private class d
    extends CommandListenerAbstract {
        public d() {
            super(AbstractClusteredRoomStrategy.c);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("creator"));
            try {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig RoomCreatedCmd command for room = {0}, creatorJid = {1}", new Object[]{bareJID, jID});
                }
                AbstractClusteredRoomStrategy.this.mucRepository.createNewRoomWithoutListener(bareJID, jID);
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
        }
    }
}

