/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Arrays;

public class Base64 {
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] ALPHABET_1 = new int[256];

    public static byte[] decode(String s) {
        int separatorsCounter = 0;
        int inputLen = s.length();
        for (int i = 0; i < inputLen; ++i) {
            int c = ALPHABET_1[s.charAt(i)];
            if (c >= 0 || c == 61) continue;
            ++separatorsCounter;
        }
        int deltas = 0;
        for (int i = inputLen - 1; i > 1 && ALPHABET_1[s.charAt(i)] <= 0; --i) {
            if (s.charAt(i) != '=') continue;
            ++deltas;
        }
        int outputLen = (inputLen - separatorsCounter) * 3 / 4 - deltas;
        byte[] buffer = new byte[outputLen];
        int mask = 255;
        int index = 0;
        int o = 0;
        while (o < s.length()) {
            int c3;
            int c2;
            int c1;
            int c0;
            if ((c0 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = Base64.findNexIt(s, o);
                if ((c0 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            if ((c1 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = Base64.findNexIt(s, o);
                if ((c1 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) break;
            if ((c2 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = Base64.findNexIt(s, o);
                if ((c2 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) break;
            if ((c3 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = Base64.findNexIt(s, o);
                if ((c3 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    public static String encode(byte[] buf) {
        int size = buf.length;
        int outputSize = (size + 2) / 3 * 4;
        char[] output = new char[outputSize];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            output[a++] = ALPHABET[b0 >> 2 & mask];
            output[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            output[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            output[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                output[--a] = 61;
            }
            case 2: {
                output[--a] = 61;
            }
        }
        return new String(output);
    }

    private static int findNexIt(String s, int i) {
        int c2;
        int sl = s.length() - 1;
        if (i >= sl) {
            return i;
        }
        while ((c2 = ALPHABET_1[s.charAt(++i)]) == -1 && i < sl) {
        }
        return i;
    }

    static {
        Arrays.fill(ALPHABET_1, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base64.ALPHABET_1[Base64.ALPHABET[i]] = i;
        }
        Base64.ALPHABET_1[61] = 0;
    }
}

