/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.xmpp.JID;

public class S2SConnectionClustered
extends S2SConnectionManager
implements ClusteredComponentIfc {
    private static final String ASKING_SESSION_ID = "asking_sessionId";
    private static final String CHECK_DB_KEY_CMD = "check-db-key-s2s-cmd";
    private static final String CHECK_DB_KEY_RESULT_CMD = "check-db-key-result-s2s-cmd";
    private static final String CONN_CID = "connection-cid";
    private static final String FORKEY_SESSION_ID = "forkey_sessionId";
    private static final String KEY_CID = "key-cid";
    private static final String KEY_P = "key";
    private static final Logger log = Logger.getLogger(S2SConnectionClustered.class.getName());
    private static final String VALID = "valid";
    private ClusterControllerIfc clusterController = null;
    private List<JID> cl_nodes_array = new CopyOnWriteArrayList<JID>();

    @Override
    public void nodeConnected(String node) {
        this.cl_nodes_array.add(JID.jidInstanceNS(this.getName(), node, null));
    }

    @Override
    public void nodeDisconnected(String node) {
        this.cl_nodes_array.remove(JID.jidInstanceNS(this.getName(), node, null));
    }

    @Override
    public String getDiscoDescription() {
        return super.getDiscoDescription() + " clustered";
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.clusterController = cl_controller;
    }

    protected JID getFirstClusterNode() {
        JID cluster_node = null;
        for (JID node : this.cl_nodes_array) {
            if (node.equals(this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }
}

