/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceCheckerUpdater;
import tigase.licence.LicenceLoaderFactory;
import tigase.stats.collector.DefaultElementSigner;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.StatisticsData;
import tigase.stats.collector.provider.StatisticsUploader;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class LicenceChecker {
    protected static int failCount = 0;
    protected static final int failCountLimit = 10;
    private static final Logger a = Logger.getLogger("tigase.licence");
    private static final SecretKeySpec b = new SecretKeySpec("0000".getBytes(), "HmacSHA1");
    protected static final ElementSigner signer = new DefaultElementSigner((Key)b);
    protected static StatisticsUploader uploader = new StatisticsUploader(signer);
    private static StatisticsUploader.ResultCallback c;
    protected static ScheduledExecutorService timer;
    protected static TimerTask licencePeriodicCheck;
    private final String d;
    private boolean e;
    private Licence f;
    private final File g;
    private final LicenceCheckerUpdateCallback h;
    private Date i;
    private boolean j = true;
    protected static final Map<String, LicenceChecker> licenceCheckers;

    public static LicenceChecker getLicenceChecker(String cmpName) {
        return LicenceChecker.getLicenceChecker(cmpName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LicenceChecker getLicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        LicenceChecker licenceChecker;
        if (call == null) {
            call = new LicenceCheckerUpdateCallbackImpl(cmpName);
        }
        if ((licenceChecker = licenceCheckers.get(cmpName)) == null) {
            String string;
            void var1_1;
            licenceChecker = new LicenceChecker(cmpName, (LicenceCheckerUpdateCallback)var1_1);
            licenceCheckers.put(string, licenceChecker);
        }
        return licenceChecker;
    }

    /*
     * WARNING - void declaration
     */
    private LicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        void var1_1;
        Object object;
        this.h = object;
        this.d = cmpName;
        this.e = false;
        object = System.getProperty("statistics-log-level");
        Level level = Level.ALL;
        if (object != null) {
            level = Level.parse((String)object);
        }
        object = this;
        Logger logger = Logger.getLogger("tigase.stats.collector");
        a.setLevel(level);
        logger.setLevel(level);
        try {
            FileHandler fileHandler = new FileHandler("logs/statistics.log", 10000000, 5, true);
            fileHandler.setLevel(level);
            logger.addHandler(fileHandler);
            a.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            a.log(Level.CONFIG, ((LicenceChecker)object).d);
        }
        if (licencePeriodicCheck == null) {
            licencePeriodicCheck = new a(this, 0);
            timer.schedule(licencePeriodicCheck, 5L, TimeUnit.MINUTES);
        }
        a.log(Level.CONFIG, "Created licence checker for {0}", var1_1);
        this.g = new File("etc/" + this.d + ".licence");
    }

    private boolean c() {
        try {
            Object object = LicenceLoaderFactory.create();
            if (!this.g.exists()) {
                a.log(Level.WARNING, "Missing licence file ({0})!", this.g);
                return false;
            }
            this.f = object.loadLicence(this.g);
            this.i = this.f.getPropertyAsDate("valid-until");
            try {
                switch (this.f.check()) {
                    case invalidDates: {
                        a.log(Level.WARNING, "Licence expired.");
                        return false;
                    }
                    case invalidSignature: {
                        a.log(Level.WARNING, "Invalid or modified licence file.");
                        return false;
                    }
                    case valid: {
                        a.log(Level.INFO, "Licence OK");
                    }
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "Licence invalid", exception);
                return false;
            }
            object = this.f.getPropertyAsString("app-id");
            if (object == null || !((String)object).equals(this.d)) {
                a.log(Level.WARNING, "This is not licence for {0} Component!", this.d);
                return false;
            }
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "Can't load licence file. Error: {0}", exception.getMessage());
            return false;
        }
        return true;
    }

    public Date getValidUntil() {
        return this.i;
    }

    public LicenceCheckerUpdateCallback getUpdateCall() {
        return this.h;
    }

    static /* synthetic */ boolean a(LicenceChecker licenceChecker, boolean bl) {
        licenceChecker.e = true;
        return true;
    }

    static /* synthetic */ boolean b(LicenceChecker licenceChecker, boolean bl) {
        licenceChecker.j = false;
        return false;
    }

    static {
        timer = Executors.newSingleThreadScheduledExecutor();
        licenceCheckers = new HashMap<String, LicenceChecker>(5);
    }

    public class ResCall
    implements StatisticsUploader.ResultCallback {
        private /* synthetic */ LicenceChecker a;

        public ResCall(LicenceChecker licenceChecker) {
            this.a = licenceChecker;
        }

        /*
         * WARNING - void declaration
         */
        public void onFailure(Exception ex) {
            void var1_1;
            if (this.a.j) {
                a.log(Level.SEVERE, "Could not upload statistics within required period of time, shutting down the system");
                System.exit(402);
                return;
            }
            a.log(Level.WARNING, "Could not upload statistics; " + (10 - ++failCount) + " attempts before system shutdown", (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onSuccess(Element result) {
            void var1_1;
            a.log(Level.FINE, "statistics uploaded = {0}; resetting number of attempts", result != null ? var1_1.toString() : null);
            failCount = 0;
            LicenceChecker.b(this.a, false);
        }
    }

    private final class a
    extends TimerTask {
        private /* synthetic */ LicenceChecker a;

        private a(LicenceChecker licenceChecker) {
            this.a = licenceChecker;
        }

        @Override
        public final void run() {
            boolean bl = false;
            boolean bl2 = false;
            long l = Long.MAX_VALUE;
            long l2 = new Date().getTime();
            a.log(Level.FINE, "License verification runtime.\n");
            if (failCount > 10) {
                a.log(Level.FINE, "Could not upload statistics within required period of time, shutting down the system");
                System.exit(402);
            }
            Element element = new Element("unlicencedComponenents");
            for (String string : licenceCheckers.keySet()) {
                LicenceChecker licenceChecker = licenceCheckers.get(string);
                if (licenceChecker.c() && licenceChecker.h.additionalValidation(licenceChecker.f)) {
                    a.log(Level.INFO, "Licence valid untill: {0}", licenceChecker.getValidUntil());
                    long l3 = licenceChecker.i.getTime() - l2 + 300000L;
                    l = l3 < l ? l3 : l;
                    Boolean bl3 = licenceChecker.f.getPropertyAsBoolean("sendingStatistics");
                    a.log(Level.INFO, "forceSendingStatistics: " + (bl2 |= bl3 != null && bl3 != false));
                    continue;
                }
                if (!this.a.e) {
                    a.log(Level.WARNING, licenceChecker.getUpdateCall().getMissingLicenseWarning());
                    LicenceChecker.a(this.a, true);
                }
                Element element2 = licenceChecker.getUpdateCall().getComponentAdditionalData();
                element.addChild((XMLNodeIfc)element2);
                bl |= true;
            }
            if (bl || bl2) {
                StatisticsData statisticsData = LicenceCheckerUpdater.updateData();
                statisticsData.setAdditionalData(statisticsData.getAdditionalData() + element.toString());
                a.log(Level.WARNING, "Uploading data");
                a.log(Level.FINEST, "Uploading data: " + statisticsData.toElement());
                c = new ResCall(this.a);
                uploader.upload(statisticsData, c);
                timer.schedule(licencePeriodicCheck, 1L, TimeUnit.DAYS);
                return;
            }
            timer.schedule(licencePeriodicCheck, l, TimeUnit.MILLISECONDS);
        }

        /* synthetic */ a(LicenceChecker licenceChecker, byte by) {
            this(licenceChecker);
        }
    }
}

