/*
 * Decompiled with CFR 0.152.
 */
package tigase.component2.eventbus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventBus;
import tigase.component2.eventbus.EventBusException;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventListener;
import tigase.component2.eventbus.EventType;

public class DefaultEventBus
extends EventBus {
    protected final Map<Object, Map<EventType<?>, List<EventHandler>>> handlers = new HashMap();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private boolean throwingExceptionOn = true;

    @Override
    public <H extends EventHandler> void addHandler(EventType<H> type, H handler) {
        this.doAdd(type, null, handler);
    }

    @Override
    public <H extends EventHandler> void addHandler(EventType<H> type, Object source, H handler) {
        this.doAdd(type, source, handler);
    }

    @Override
    public <H extends EventHandler> void addListener(EventListener listener) {
        this.doAdd(null, null, listener);
    }

    @Override
    public <H extends EventHandler> void addListener(EventType<H> type, EventListener listener) {
        this.doAdd(type, null, listener);
    }

    @Override
    public <H extends EventHandler> void addListener(EventType<H> type, Object source, EventListener listener) {
        this.doAdd(type, source, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAdd(EventType<?> type, Object source, EventHandler handler) {
        Map<Object, Map<EventType<?>, List<EventHandler>>> map = this.handlers;
        synchronized (map) {
            List<EventHandler> lst;
            Map<EventType<?>, List<EventHandler>> hdlrs = this.handlers.get(source);
            if (hdlrs == null) {
                hdlrs = new HashMap();
                this.handlers.put(source, hdlrs);
            }
            if ((lst = hdlrs.get(type)) == null) {
                lst = new ArrayList<EventHandler>();
                hdlrs.put(type, lst);
            }
            lst.add(handler);
        }
    }

    protected void doFire(Event<EventHandler> event, Object source) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        this.setEventSource(event, source);
        ArrayList<EventHandler> handlers = new ArrayList<EventHandler>();
        handlers.addAll(this.getHandlersList(event.getType(), source));
        handlers.addAll(this.getHandlersList(null, source));
        if (source != null) {
            handlers.addAll(this.getHandlersList(event.getType(), null));
            handlers.addAll(this.getHandlersList(null, null));
        }
        HashSet<Throwable> causes = new HashSet<Throwable>();
        for (EventHandler eventHandler : handlers) {
            try {
                if (eventHandler instanceof EventListener) {
                    ((EventListener)eventHandler).onEvent(event);
                    continue;
                }
                event.dispatch(eventHandler);
            }
            catch (Throwable e) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "", e);
                }
                causes.add(e);
            }
        }
        if (!causes.isEmpty() && this.throwingExceptionOn) {
            throw new EventBusException(causes);
        }
    }

    @Override
    public void fire(Event<?> event) {
        this.doFire(event, null);
    }

    @Override
    public void fire(Event<?> event, Object source) {
        this.doFire(event, source);
    }

    protected Collection<EventHandler> getHandlersList(EventType<?> type, Object source) {
        Map<EventType<?>, List<EventHandler>> hdlrs = this.handlers.get(source);
        if (hdlrs == null) {
            return Collections.emptyList();
        }
        List<EventHandler> lst = hdlrs.get(type);
        if (lst != null) {
            return lst;
        }
        return Collections.emptyList();
    }

    public boolean isThrowingExceptionOn() {
        return this.throwingExceptionOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(EventHandler handler) {
        Map<Object, Map<EventType<?>, List<EventHandler>>> map = this.handlers;
        synchronized (map) {
            Iterator<Map.Entry<Object, Map<EventType<?>, List<EventHandler>>>> l = this.handlers.entrySet().iterator();
            while (l.hasNext()) {
                Map<EventType<?>, List<EventHandler>> eventHandlers = l.next().getValue();
                Iterator<Map.Entry<EventType<?>, List<EventHandler>>> iterator = eventHandlers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<EventType<?>, List<EventHandler>> entry = iterator.next();
                    if (entry == null) continue;
                    entry.getValue().remove(handler);
                    if (!entry.getValue().isEmpty()) continue;
                    iterator.remove();
                }
                if (!eventHandlers.isEmpty()) continue;
                l.remove();
            }
        }
    }

    @Override
    public void remove(EventType<?> type, EventHandler handler) {
        this.remove(type, null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(EventType<?> type, Object source, EventHandler handler) {
        Map<Object, Map<EventType<?>, List<EventHandler>>> map = this.handlers;
        synchronized (map) {
            List<EventHandler> lst;
            Map<EventType<?>, List<EventHandler>> hdlrs = this.handlers.get(source);
            if (hdlrs != null && (lst = hdlrs.get(type)) != null) {
                lst.remove(handler);
                if (lst.isEmpty()) {
                    hdlrs.remove(type);
                }
                if (hdlrs.isEmpty()) {
                    this.handlers.remove(source);
                }
            }
        }
    }

    public void setThrowingExceptionOn(boolean throwingExceptionOn) {
        this.throwingExceptionOn = throwingExceptionOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<Object, Map<EventType<?>, List<EventHandler>>> map = this.handlers;
        synchronized (map) {
            this.handlers.clear();
        }
    }
}

