/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;

public class LastActivity
extends XMPPProcessorAbstract
implements XMPPStopListenerIfc {
    private static final String XMLNS = "jabber:iq:last";
    private static final String[] XMLNSS = new String[]{"jabber:iq:last", "jabber:client", "jabber:client"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:last"})};
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH, {"presence"}, {"message"}};
    private static final String ID = "jabber:iq:last";
    private static final String LAST_ACTIVITY_KEY = "LAST_ACTIVITY_KEY";
    private static final String LAST_STATUS_KEY = "LAST_STATUS_KEY";
    private static final Logger log = Logger.getLogger(LastActivity.class.getName());
    private static final String[] STATUS_PATH = new String[]{"presence", "status"};

    private static String getStatus(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        return repo.getPublicData(requestedJid, "jabber:iq:last", LAST_STATUS_KEY, null);
    }

    private static long getTime(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        String data = repo.getPublicData(requestedJid, "jabber:iq:last", LAST_ACTIVITY_KEY, null);
        if (data == null) {
            return -1L;
        }
        try {
            return Long.parseLong(data);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static long getTime(XMPPResourceConnection session) {
        Long last = (Long)session.getSessionData(LAST_ACTIVITY_KEY);
        return last == null ? -1L : last;
    }

    @Override
    public String id() {
        return "jabber:iq:last";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (packet.getElemName() != "iq" && session != null && session.getBareJID().equals(packet.getStanzaFrom().getBareJID())) {
            long time = System.currentTimeMillis();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Updating last:activity of user " + session.getUserName() + " to " + time);
            }
            session.putSessionData(LAST_ACTIVITY_KEY, time);
        } else if (packet.getElemName() == "iq") {
            super.process(packet, session, repo, results, settings);
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() == StanzaType.get) {
            long last = LastActivity.getTime(session);
            if (last != -1L) {
                Packet resp = packet.okResult((Element)null, 0);
                long result = (System.currentTimeMillis() - last) / 1000L;
                Element q = new Element("query", new String[]{"xmlns", "seconds"}, new String[]{"jabber:iq:last", "" + result});
                resp.getElement().addChild(q);
                results.offer(resp);
            } else {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Unknown last activity time", true));
            }
        } else {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        block8: {
            if (packet.getType() == StanzaType.get) {
                try {
                    BareJID requestedJid = packet.getStanzaTo().getBareJID();
                    long last = LastActivity.getTime(repo, requestedJid);
                    String status = LastActivity.getStatus(repo, requestedJid);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Get last:activity of offline user " + requestedJid + ". value=" + last + ", status=" + status);
                    }
                    if (last != -1L) {
                        long result = (System.currentTimeMillis() - last) / 1000L;
                        Packet resp = packet.okResult((Element)null, 0);
                        Element q = new Element("query", status, new String[]{"xmlns", "seconds"}, new String[]{"jabber:iq:last", "" + result});
                        resp.getElement().addChild(q);
                        results.offer(resp);
                        break block8;
                    }
                    results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Unknown last activity time", true));
                }
                catch (UserNotFoundException e) {
                    results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
                }
            } else if (packet.getType() == StanzaType.set) {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
            } else {
                super.processNullSessionPacket(packet, repo, results, settings);
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() == StanzaType.get) {
            long last = LastActivity.getTime(session);
            if (last != -1L) {
                long result = (System.currentTimeMillis() - last) / 1000L;
                Packet resp = packet.okResult((Element)null, 0);
                Element q = new Element("query", new String[]{"xmlns", "seconds"}, new String[]{"jabber:iq:last", "" + result});
                resp.getElement().addChild(q);
                results.offer(resp);
            } else {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Unknown last activity time", true));
            }
        } else if (packet.getType() == StanzaType.set) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
        } else {
            super.processToUserPacket(packet, session, repo, results, settings);
        }
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (session != null) {
            long last = LastActivity.getTime(session);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Persiting last:activity of user " + session.getUserName() + " in storage (value=" + last + ").");
                }
                session.setPublicData("jabber:iq:last", LAST_ACTIVITY_KEY, String.valueOf(last));
                String status = session.getPresence().getChildCDataStaticStr(STATUS_PATH);
                session.setPublicData("jabber:iq:last", LAST_STATUS_KEY, status);
            }
            catch (NotAuthorizedException e) {
                log.finest("session isn't authorized" + session);
            }
            catch (TigaseDBException e) {
                log.warning("Tigase Db Exception");
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

