/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.logging.Level;
import tigase.stats.StatisticType;

public class StatRecord {
    private StatisticType type = StatisticType.OTHER;
    private Level level = Level.INFO;
    private long longValue = -1L;
    private int intValue = -1;
    private float floatValue = -1.0f;
    private String description = null;
    private String value = null;
    private String component = null;

    public StatRecord(String comp, String description, String value, Level level) {
        this.description = description;
        this.value = value;
        this.level = level;
        this.component = comp;
    }

    public StatRecord(String comp, String description, int value, Level level) {
        this(comp, description, "" + value, level);
        this.intValue = value;
    }

    public StatRecord(String comp, StatisticType type, long value, Level level) {
        this(comp, type.getDescription(), "" + value, level);
        this.type = type;
        this.longValue = value;
    }

    public StatRecord(String comp, StatisticType type, int value, Level level) {
        this(comp, type.getDescription(), "" + value, level);
        this.type = type;
        this.intValue = value;
    }

    public StatRecord(String comp, String description, long value, Level level) {
        this(comp, description, "" + value, level);
        this.longValue = value;
    }

    StatRecord(String comp, String description, float value, Level level) {
        this(comp, description, "" + value, level);
        this.floatValue = value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public StatisticType getType() {
        return this.type;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getComponent() {
        return this.component;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.component).append('/').append(this.description);
        sb.append(" = ").append(this.value);
        return sb.toString();
    }

    float getFloatValue() {
        return this.floatValue;
    }
}

