/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionType;
import tigase.server.Packet;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.xml.Element;

public class StreamFeatures
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(StreamFeatures.class.getName());

    @Override
    public int order() {
        return S2SAbstractProcessor.Order.StreamFeatures.ordinal();
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        if (p.isElement("features", "http://etherx.jabber.org/streams")) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Stream features received: {1}", new Object[]{serv, p});
            }
            return true;
        }
        return false;
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        if (attribs.containsKey("version") && serv.connectionType() == ConnectionType.accept) {
            List<Element> features = this.handler.getStreamFeatures(serv);
            Element featuresElement = new Element("stream:features");
            featuresElement.addChildren(features);
            if (attribs.containsKey("from") && this.skipTLSForHost(attribs.get("from"))) {
                Element startTls = featuresElement.getChild("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
                featuresElement.removeChild(startTls);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Sending stream features: {1}", new Object[]{serv, featuresElement});
            }
            serv.addPacketToSend(Packet.packetInstance(featuresElement, null, null));
        }
        return null;
    }
}

