/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.repo.ClConConfigRepository;
import tigase.cluster.repo.ClusterRepoConstants;
import tigase.cluster.repo.ClusterRepoItem;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class ClConSQLRepository
extends ClConConfigRepository
implements ClusterRepoConstants {
    private static final Logger log = Logger.getLogger(ClConSQLRepository.class.getName());
    private static final String GET_ITEM_QUERY = "select hostname, password, last_update, port, cpu_usage, mem_usage from cluster_nodes where hostname = ?";
    private static final String GET_ALL_ITEMS_QUERY = "select hostname, password, last_update, port, cpu_usage, mem_usage from cluster_nodes";
    private static final String DELETE_ITEM_QUERY = "delete from cluster_nodes where (hostname = ?)";
    private static final String CREATE_TABLE_QUERY_MYSQL = "create table cluster_nodes (  hostname varchar(255) not null,  password varchar(255) not null,  last_update TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  port int,  cpu_usage double precision unsigned not null,  mem_usage double precision unsigned not null,  primary key(hostname)) ENGINE=InnoDB default character set utf8 ROW_FORMAT=DYNAMIC";
    private static final String CREATE_TABLE_QUERY = "create table cluster_nodes (  hostname varchar(512) not null,  password varchar(255) not null,  last_update TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  port int,  cpu_usage double precision not null,  mem_usage double precision not null,  primary key(hostname))";
    private static final String CREATE_TABLE_QUERY_SQLSERVER = "create table [dbo].[cluster_nodes] (  hostname nvarchar(512) not null,  password nvarchar(255) not null,  last_update [datetime] NULL,  port int,  cpu_usage double precision not null,  mem_usage double precision not null, CONSTRAINT [PK_cluster_nodes] PRIMARY KEY CLUSTERED ( [hostname] ASC ) ON [PRIMARY],  CONSTRAINT [IX_cluster_nodes_hostname] UNIQUE NONCLUSTERED ( [hostname] ASC ) ON [PRIMARY] ) ON [PRIMARY]ALTER TABLE [dbo].[cluster_nodes] ADD  CONSTRAINT [DF_cluster_nodes_last_update]  DEFAULT (getdate()) FOR [last_update] ";
    private static final String INSERT_ITEM_QUERY = "insert into cluster_nodes (hostname, password, last_update, port, cpu_usage, mem_usage)  (select ?, ?, CURRENT_TIMESTAMP, ?, ?, ? from cluster_nodes WHERE hostname=? HAVING count(*)=0)";
    private static final String UPDATE_ITEM_QUERY = "update cluster_nodes set hostname= ?, password= ?, last_update = CURRENT_TIMESTAMP,port= ?, cpu_usage= ?, mem_usage= ?  where hostname= ?";
    private DataRepository data_repo = null;

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put("repo-uri", repo_uri);
    }

    @Override
    public void initRepository(String conn_str, Map<String, String> params) throws DBInitException {
        super.initRepository(conn_str, params);
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, params);
            this.checkDB();
            this.data_repo.initPreparedStatement(GET_ITEM_QUERY, GET_ITEM_QUERY);
            this.data_repo.initPreparedStatement(GET_ALL_ITEMS_QUERY, GET_ALL_ITEMS_QUERY);
            this.data_repo.initPreparedStatement(INSERT_ITEM_QUERY, INSERT_ITEM_QUERY);
            this.data_repo.initPreparedStatement(UPDATE_ITEM_QUERY, UPDATE_ITEM_QUERY);
            this.data_repo.initPreparedStatement(DELETE_ITEM_QUERY, DELETE_ITEM_QUERY);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem initializing database: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(String key) {
        super.removeItem(key);
        try {
            PreparedStatement removeItem;
            PreparedStatement preparedStatement = removeItem = this.data_repo.getPreparedStatement(null, DELETE_ITEM_QUERY);
            synchronized (preparedStatement) {
                removeItem.setString(1, key);
                removeItem.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem removing elements from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeItem(ClusterRepoItem item) {
        try {
            PreparedStatement updateItemSt = this.data_repo.getPreparedStatement(null, UPDATE_ITEM_QUERY);
            PreparedStatement insertItemSt = this.data_repo.getPreparedStatement(null, INSERT_ITEM_QUERY);
            PreparedStatement preparedStatement = updateItemSt;
            synchronized (preparedStatement) {
                updateItemSt.setString(1, item.getHostname());
                updateItemSt.setString(2, item.getPassword());
                updateItemSt.setInt(3, item.getPortNo());
                updateItemSt.setFloat(4, item.getCpuUsage());
                updateItemSt.setFloat(5, item.getMemUsage());
                updateItemSt.setString(6, item.getHostname());
                updateItemSt.executeUpdate();
            }
            preparedStatement = insertItemSt;
            synchronized (preparedStatement) {
                insertItemSt.setString(1, item.getHostname());
                insertItemSt.setString(2, item.getPassword());
                insertItemSt.setInt(3, item.getPortNo());
                insertItemSt.setFloat(4, item.getCpuUsage());
                insertItemSt.setFloat(5, item.getMemUsage());
                insertItemSt.setString(6, item.getHostname());
                insertItemSt.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (System.currentTimeMillis() - this.lastReloadTime <= this.autoreload_interval * this.lastReloadTimeFactor) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Last reload performed in {0}, skipping: ", System.currentTimeMillis() - this.lastReloadTime);
            }
            return;
        }
        this.lastReloadTime = System.currentTimeMillis();
        super.reload();
        ResultSet rs = null;
        try {
            PreparedStatement getAllItemsSt;
            PreparedStatement preparedStatement = getAllItemsSt = this.data_repo.getPreparedStatement(null, GET_ALL_ITEMS_QUERY);
            synchronized (preparedStatement) {
                rs = getAllItemsSt.executeQuery();
                while (rs.next()) {
                    ClusterRepoItem item = this.getItemInstance();
                    item.setHostname(rs.getString("hostname"));
                    item.setPassword(rs.getString("password"));
                    item.setLastUpdate(rs.getTimestamp("last_update").getTime());
                    item.setPort(rs.getInt("port"));
                    item.setCpuUsage(rs.getFloat("cpu_usage"));
                    item.setMemUsage(rs.getFloat("mem_usage"));
                    this.itemLoaded(item);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
    }

    @Override
    public void store() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDB() throws SQLException {
        String createTableQuery;
        Object rs = null;
        Statement st = null;
        DataRepository.dbTypes databaseType = this.data_repo.getDatabaseType();
        switch (databaseType) {
            case mysql: {
                createTableQuery = CREATE_TABLE_QUERY_MYSQL;
                break;
            }
            case jtds: 
            case sqlserver: {
                createTableQuery = CREATE_TABLE_QUERY_SQLSERVER;
                break;
            }
            default: {
                createTableQuery = CREATE_TABLE_QUERY;
            }
        }
        try {
            if (!this.data_repo.checkTable("cluster_nodes")) {
                log.info("DB for external component is not OK, creating missing tables...");
                st = this.data_repo.createStatement(null);
                st.executeUpdate(createTableQuery);
                log.info("DB for external component created OK");
            }
        }
        finally {
            this.data_repo.release(st, rs);
            rs = null;
            st = null;
        }
    }
}

