/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterConnectionManager;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusterElement;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ClusterController
extends AbstractComponentRegistrator<ClusteredComponentIfc>
implements Configurable,
ClusterControllerIfc {
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String MY_DOMAIN_NAME_PROP_VAL = "localhost";
    private static final Logger log = Logger.getLogger(ClusterController.class.getName());
    private ConcurrentSkipListMap<String, CommandListener> commandListeners = new ConcurrentSkipListMap();
    private AtomicLong currId = new AtomicLong(1L);

    @Override
    public void componentAdded(ClusteredComponentIfc component) {
        if (component instanceof ClusterConnectionManager) {
            component.setClusterController(this);
        } else {
            Wrapper wrapper = new Wrapper(this, component);
            component.setClusterController(wrapper);
        }
        this.updateServiceDiscoveryItem(this.getName(), component.getName(), "Component: " + component.getName(), true);
    }

    @Override
    public void componentRemoved(ClusteredComponentIfc component) {
    }

    @Override
    public void handleClusterPacket(Element packet) {
        ClusterElement clel = new ClusterElement(packet);
        CommandListener cmdList = this.commandListeners.get(clel.getMethodName());
        if (cmdList != null) {
            clel.addVisitedNode(JID.jidInstanceNS(packet.getAttributeStaticStr("to")));
            Map<String, String> data = clel.getAllMethodParams();
            Set<JID> visitedNodes = clel.getVisitedNodes();
            Queue<Element> packets = clel.getDataPackets();
            try {
                cmdList.executeCommand(clel.getFirstNode(), visitedNodes, data, packets);
            }
            catch (ClusterCommandException ex) {
                ex.printStackTrace();
            }
        } else {
            log.log(Level.WARNING, "Missing CommandListener for cluster method: {0}", clel.getMethodName());
        }
    }

    @Override
    public void nodeConnected(String node) {
        for (ClusteredComponentIfc comp : this.components.values()) {
            comp.nodeConnected(node);
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        for (ClusteredComponentIfc comp : this.components.values()) {
            comp.nodeDisconnected(node);
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
    }

    @Override
    public void removeCommandListener(CommandListener listener) {
        this.removeCommandListener(listener.getName(), listener);
    }

    @Override
    public void sendToNodes(String command2, Map<String, String> data, Queue<Element> packets, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        CommandListener packetSender = this.commandListeners.get("deliver-cluster-packet-cmd");
        if (packetSender == null) {
            log.log(Level.SEVERE, "Misconfiguration or packaging error, can not send a cluster packet! No CommandListener for deliver-cluster-packet-cmd");
            return;
        }
        ArrayDeque<Element> results = new ArrayDeque<Element>();
        for (JID to : toNodes) {
            ClusterElement clel = ClusterElement.createClusterMethodCall(fromNode, to, StanzaType.set, command2, data);
            clel.addVisitedNodes(visitedNodes);
            clel.addDataPackets(packets);
            Element result = clel.getClusterElement(this.nextId());
            results.offer(result);
        }
        try {
            packetSender.executeCommand(null, null, null, results);
        }
        catch (ClusterCommandException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void sendToNodes(String command2, Queue<Element> packets, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        this.sendToNodes(command2, null, packets, fromNode, visitedNodes, toNodes);
    }

    @Override
    public void sendToNodes(String command2, Map<String, String> data, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        this.sendToNodes(command2, data, (Queue<Element>)null, fromNode, visitedNodes, toNodes);
    }

    @Override
    public void sendToNodes(String command2, Map<String, String> data, JID fromNode, JID ... toNodes) {
        this.sendToNodes(command2, data, (Queue<Element>)null, fromNode, null, toNodes);
    }

    @Override
    public void sendToNodes(String command2, JID fromNode, JID ... toNodes) {
        this.sendToNodes(command2, null, (Queue<Element>)null, fromNode, null, toNodes);
    }

    @Override
    public void sendToNodes(String command2, Element packet, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        this.sendToNodes(command2, null, packet, fromNode, visitedNodes, toNodes);
    }

    @Override
    public void sendToNodes(String command2, Map<String, String> data, Element packet, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        ArrayDeque<Element> packets = new ArrayDeque<Element>();
        packets.offer(packet);
        this.sendToNodes(command2, data, packets, fromNode, visitedNodes, toNodes);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return "load";
    }

    @Override
    public String getDiscoDescription() {
        return "Cluster controller";
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof ClusteredComponentIfc;
    }

    @Override
    public void setCommandListener(CommandListener listener) {
        this.setCommandListener(listener.getName(), listener);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setProperties(Map<String, Object> properties) throws ConfigurationException {
        super.setProperties(properties);
    }

    private String nextId() {
        return "cl-" + this.currId.incrementAndGet();
    }

    private void removeCommandListener(String name, CommandListener listener) {
        this.commandListeners.remove(name, listener);
    }

    private void setCommandListener(String name, CommandListener listener) {
        this.commandListeners.put(name, listener);
    }

    private class Wrapper
    implements ClusterControllerIfc {
        private final ClusterController controller;
        private final ClusteredComponentIfc component;
        private final String name;

        public Wrapper(ClusterController controller, ClusteredComponentIfc component) {
            this.controller = controller;
            this.component = component;
            this.name = component.getName();
        }

        @Override
        public void handleClusterPacket(Element packet) {
            this.controller.handleClusterPacket(packet);
        }

        @Override
        public void nodeConnected(String addr) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        @Override
        public void nodeDisconnected(String addr) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        @Override
        public void removeCommandListener(CommandListener listener) {
            String name = this.name + "-" + listener.getName();
            this.controller.removeCommandListener(name, listener);
        }

        @Override
        public void sendToNodes(String command2, Map<String, String> data, Queue<Element> packets, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, data, packets, fromNode, visitedNodes, toNodes);
        }

        @Override
        public void sendToNodes(String command2, Queue<Element> packets, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, packets, fromNode, visitedNodes, toNodes);
        }

        @Override
        public void sendToNodes(String command2, Map<String, String> data, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, data, fromNode, visitedNodes, toNodes);
        }

        @Override
        public void sendToNodes(String command2, Map<String, String> data, JID fromNode, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, data, fromNode, toNodes);
        }

        @Override
        public void sendToNodes(String command2, JID fromNode, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, fromNode, toNodes);
        }

        @Override
        public void sendToNodes(String command2, Element packet, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, packet, fromNode, visitedNodes, toNodes);
        }

        @Override
        public void sendToNodes(String command2, Map<String, String> data, Element packet, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
            command2 = this.name + "-" + command2;
            this.controller.sendToNodes(command2, data, packet, fromNode, visitedNodes, toNodes);
        }

        @Override
        public void setCommandListener(CommandListener listener) {
            String name = this.name + "-" + listener.getName();
            this.controller.setCommandListener(name, listener);
        }
    }
}

