/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.mechanisms.SaslANONYMOUS;
import tigase.auth.mechanisms.SaslEXTERNAL;
import tigase.auth.mechanisms.SaslPLAIN;
import tigase.auth.mechanisms.SaslSCRAM;

public class TigaseSaslServerFactory
implements SaslServerFactory {
    public static final String ANONYMOUS_MECHANISM_ALLOWED = "anonymous-mechanism-allowed";

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
        if (mechanism.equals("SCRAM-SHA-1")) {
            return new SaslSCRAM(props, callbackHandler);
        }
        if (mechanism.equals("PLAIN")) {
            return new SaslPLAIN(props, callbackHandler);
        }
        if (mechanism.equals("ANONYMOUS")) {
            return new SaslANONYMOUS(props, callbackHandler);
        }
        if (mechanism.equals("EXTERNAL")) {
            return new SaslEXTERNAL(props, callbackHandler);
        }
        throw new SaslException("Mechanism not supported yet.");
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"PLAIN", "ANONYMOUS", "EXTERNAL"};
    }
}

