/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import tigase.archive.AbstractCriteria;
import tigase.archive.db.MessageArchiveRepository;
import tigase.xml.Element;

public abstract class AbstractMessageArchiveRepository<Crit extends AbstractCriteria>
implements MessageArchiveRepository<Crit> {
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCollectionToResults(List<Element> results, String with, Date start) {
        String formattedStart = null;
        SimpleDateFormat simpleDateFormat = formatter2;
        synchronized (simpleDateFormat) {
            formattedStart = formatter2.format(start);
        }
        results.add(new Element("chat", new String[]{"with", "start"}, new String[]{with, formattedStart}));
    }

    protected void addMessageToResults(List<Element> results, Date collectionStart, Element msg, Date timestamp, MessageArchiveRepository.Direction direction, String with) {
        Element item = new Element(direction.toElementName());
        item.addChildren(msg.getChildren());
        item.setAttribute("secs", String.valueOf((timestamp.getTime() - collectionStart.getTime()) / 1000L));
        if (with != null) {
            item.setAttribute("with", with);
        }
        results.add(item);
    }

    static {
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

